/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.BiConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashObjObjMap}s, and
 * the default {@link HashObjObjMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashObjObjMap
 */
public final class HashObjObjMaps {

    

    private static final ServiceLoader<HashObjObjMapFactory> LOADER =
            ServiceLoader.load(HashObjObjMapFactory.class);
    private static HashObjObjMapFactory<Object, Object> defaultFactory = null;

    public static HashObjObjMapFactory<Object, Object> getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static <K, V> HashObjObjMap<K, V> newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static <K, V> HashObjObjMap<K, V> newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    

    /**
     * If the specified map doesn't have specific key equivalence, {@code expectedSize} is ignored.
     */
    public static <K, V> HashObjObjMap<K, V> newMutableMap(
            Map<? extends K, ? extends V> map, int expectedSize) {
        return getDefaultFactory().newMutableMap(map, expectedSize);
    }

    public static <K, V> HashObjObjMap<K, V> newMutableMap(Map<? extends K, ? extends V> map1,
            Map<? extends K, ? extends V> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static <K, V> HashObjObjMap<K, V> newMutableMap(Map<? extends K, ? extends V> map1,
            Map<? extends K, ? extends V> map2, Map<? extends K, ? extends V> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static <K, V> HashObjObjMap<K, V> newMutableMap(Map<? extends K, ? extends V> map1,
            Map<? extends K, ? extends V> map2, Map<? extends K, ? extends V> map3,
            Map<? extends K, ? extends V> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static <K, V> HashObjObjMap<K, V> newMutableMap(Map<? extends K, ? extends V> map1,
            Map<? extends K, ? extends V> map2, Map<? extends K, ? extends V> map3,
            Map<? extends K, ? extends V> map4, Map<? extends K, ? extends V> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static <K, V> HashObjObjMap<K, V> newMutableMap(
            Map<? extends K, ? extends V> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static <K, V> HashObjObjMap<K, V> newMutableMap(Map<? extends K, ? extends V> map1,
            Map<? extends K, ? extends V> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static <K, V> HashObjObjMap<K, V> newMutableMap(Map<? extends K, ? extends V> map1,
            Map<? extends K, ? extends V> map2, Map<? extends K, ? extends V> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static <K, V> HashObjObjMap<K, V> newMutableMap(Map<? extends K, ? extends V> map1,
            Map<? extends K, ? extends V> map2, Map<? extends K, ? extends V> map3,
            Map<? extends K, ? extends V> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static <K, V> HashObjObjMap<K, V> newMutableMap(Map<? extends K, ? extends V> map1,
            Map<? extends K, ? extends V> map2, Map<? extends K, ? extends V> map3,
            Map<? extends K, ? extends V> map4, Map<? extends K, ? extends V> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static <K, V> HashObjObjMap<K, V> newMutableMap(
            net.openhft.function.Consumer<BiConsumer<K, V>> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static <K, V> HashObjObjMap<K, V> newMutableMap(
            net.openhft.function.Consumer<BiConsumer<K, V>> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static <K, V> HashObjObjMap<K, V> newMutableMap(
            K[] keys, V[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static <K, V> HashObjObjMap<K, V> newMutableMap(
            K[] keys, V[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static <K, V> HashObjObjMap<K, V> newMutableMap(Iterable<? extends K> keys,
            Iterable<? extends V> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static <K, V> HashObjObjMap<K, V> newMutableMap(Iterable<? extends K> keys,
            Iterable<? extends V> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static <K, V> HashObjObjMap<K, V> newMutableMapOf(
            K k1, V v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static <K, V> HashObjObjMap<K, V> newMutableMapOf(
            K k1, V v1, K k2, V v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static <K, V> HashObjObjMap<K, V> newMutableMapOf(
            K k1, V v1, K k2, V v2,
            K k3, V v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static <K, V> HashObjObjMap<K, V> newMutableMapOf(
            K k1, V v1, K k2, V v2,
            K k3, V v3, K k4, V v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static <K, V> HashObjObjMap<K, V> newMutableMapOf(
            K k1, V v1, K k2, V v2,
            K k3, V v3, K k4, V v4,
            K k5, V v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    

    /**
     * If the specified map doesn't have specific key equivalence, {@code expectedSize} is ignored.
     */
    public static <K, V> HashObjObjMap<K, V> newUpdatableMap(
            Map<? extends K, ? extends V> map, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map, expectedSize);
    }

    public static <K, V> HashObjObjMap<K, V> newUpdatableMap(Map<? extends K, ? extends V> map1,
            Map<? extends K, ? extends V> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static <K, V> HashObjObjMap<K, V> newUpdatableMap(Map<? extends K, ? extends V> map1,
            Map<? extends K, ? extends V> map2, Map<? extends K, ? extends V> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static <K, V> HashObjObjMap<K, V> newUpdatableMap(Map<? extends K, ? extends V> map1,
            Map<? extends K, ? extends V> map2, Map<? extends K, ? extends V> map3,
            Map<? extends K, ? extends V> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static <K, V> HashObjObjMap<K, V> newUpdatableMap(Map<? extends K, ? extends V> map1,
            Map<? extends K, ? extends V> map2, Map<? extends K, ? extends V> map3,
            Map<? extends K, ? extends V> map4, Map<? extends K, ? extends V> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static <K, V> HashObjObjMap<K, V> newUpdatableMap(
            Map<? extends K, ? extends V> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static <K, V> HashObjObjMap<K, V> newUpdatableMap(Map<? extends K, ? extends V> map1,
            Map<? extends K, ? extends V> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static <K, V> HashObjObjMap<K, V> newUpdatableMap(Map<? extends K, ? extends V> map1,
            Map<? extends K, ? extends V> map2, Map<? extends K, ? extends V> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static <K, V> HashObjObjMap<K, V> newUpdatableMap(Map<? extends K, ? extends V> map1,
            Map<? extends K, ? extends V> map2, Map<? extends K, ? extends V> map3,
            Map<? extends K, ? extends V> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static <K, V> HashObjObjMap<K, V> newUpdatableMap(Map<? extends K, ? extends V> map1,
            Map<? extends K, ? extends V> map2, Map<? extends K, ? extends V> map3,
            Map<? extends K, ? extends V> map4, Map<? extends K, ? extends V> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static <K, V> HashObjObjMap<K, V> newUpdatableMap(
            net.openhft.function.Consumer<BiConsumer<K, V>> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static <K, V> HashObjObjMap<K, V> newUpdatableMap(
            net.openhft.function.Consumer<BiConsumer<K, V>> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static <K, V> HashObjObjMap<K, V> newUpdatableMap(
            K[] keys, V[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static <K, V> HashObjObjMap<K, V> newUpdatableMap(
            K[] keys, V[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static <K, V> HashObjObjMap<K, V> newUpdatableMap(Iterable<? extends K> keys,
            Iterable<? extends V> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static <K, V> HashObjObjMap<K, V> newUpdatableMap(Iterable<? extends K> keys,
            Iterable<? extends V> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static <K, V> HashObjObjMap<K, V> newUpdatableMapOf(
            K k1, V v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static <K, V> HashObjObjMap<K, V> newUpdatableMapOf(
            K k1, V v1, K k2, V v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static <K, V> HashObjObjMap<K, V> newUpdatableMapOf(
            K k1, V v1, K k2, V v2,
            K k3, V v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static <K, V> HashObjObjMap<K, V> newUpdatableMapOf(
            K k1, V v1, K k2, V v2,
            K k3, V v3, K k4, V v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static <K, V> HashObjObjMap<K, V> newUpdatableMapOf(
            K k1, V v1, K k2, V v2,
            K k3, V v3, K k4, V v4,
            K k5, V v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    

    /**
     * If the specified map doesn't have specific key equivalence, {@code expectedSize} is ignored.
     */
    public static <K, V> HashObjObjMap<K, V> newImmutableMap(
            Map<? extends K, ? extends V> map, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map, expectedSize);
    }

    public static <K, V> HashObjObjMap<K, V> newImmutableMap(Map<? extends K, ? extends V> map1,
            Map<? extends K, ? extends V> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static <K, V> HashObjObjMap<K, V> newImmutableMap(Map<? extends K, ? extends V> map1,
            Map<? extends K, ? extends V> map2, Map<? extends K, ? extends V> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static <K, V> HashObjObjMap<K, V> newImmutableMap(Map<? extends K, ? extends V> map1,
            Map<? extends K, ? extends V> map2, Map<? extends K, ? extends V> map3,
            Map<? extends K, ? extends V> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static <K, V> HashObjObjMap<K, V> newImmutableMap(Map<? extends K, ? extends V> map1,
            Map<? extends K, ? extends V> map2, Map<? extends K, ? extends V> map3,
            Map<? extends K, ? extends V> map4, Map<? extends K, ? extends V> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static <K, V> HashObjObjMap<K, V> newImmutableMap(
            Map<? extends K, ? extends V> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static <K, V> HashObjObjMap<K, V> newImmutableMap(Map<? extends K, ? extends V> map1,
            Map<? extends K, ? extends V> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static <K, V> HashObjObjMap<K, V> newImmutableMap(Map<? extends K, ? extends V> map1,
            Map<? extends K, ? extends V> map2, Map<? extends K, ? extends V> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static <K, V> HashObjObjMap<K, V> newImmutableMap(Map<? extends K, ? extends V> map1,
            Map<? extends K, ? extends V> map2, Map<? extends K, ? extends V> map3,
            Map<? extends K, ? extends V> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static <K, V> HashObjObjMap<K, V> newImmutableMap(Map<? extends K, ? extends V> map1,
            Map<? extends K, ? extends V> map2, Map<? extends K, ? extends V> map3,
            Map<? extends K, ? extends V> map4, Map<? extends K, ? extends V> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static <K, V> HashObjObjMap<K, V> newImmutableMap(
            net.openhft.function.Consumer<BiConsumer<K, V>> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static <K, V> HashObjObjMap<K, V> newImmutableMap(
            net.openhft.function.Consumer<BiConsumer<K, V>> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static <K, V> HashObjObjMap<K, V> newImmutableMap(
            K[] keys, V[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static <K, V> HashObjObjMap<K, V> newImmutableMap(
            K[] keys, V[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static <K, V> HashObjObjMap<K, V> newImmutableMap(Iterable<? extends K> keys,
            Iterable<? extends V> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static <K, V> HashObjObjMap<K, V> newImmutableMap(Iterable<? extends K> keys,
            Iterable<? extends V> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static <K, V> HashObjObjMap<K, V> newImmutableMapOf(
            K k1, V v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static <K, V> HashObjObjMap<K, V> newImmutableMapOf(
            K k1, V v1, K k2, V v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static <K, V> HashObjObjMap<K, V> newImmutableMapOf(
            K k1, V v1, K k2, V v2,
            K k3, V v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static <K, V> HashObjObjMap<K, V> newImmutableMapOf(
            K k1, V v1, K k2, V v2,
            K k3, V v3, K k4, V v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static <K, V> HashObjObjMap<K, V> newImmutableMapOf(
            K k1, V v1, K k2, V v2,
            K k3, V v3, K k4, V v4,
            K k5, V v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashObjObjMaps() {}
}

