/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.BiConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashObjObjMaps}
 *
 * @see HashObjObjMap
 * @see HashObjObjMaps#getDefaultFactory()
 */
public interface HashObjObjMapFactory<K, V> extends ObjObjMapFactory<K, V>
        , ObjHashFactory<HashObjObjMapFactory<K, V>>
         {

    

    

    

    

    

    
    

    
    

    <KE> HashObjObjMapFactory<KE, V>
    withKeyEquivalence(@Nullable Equivalence<KE> keyEquivalence);

    @Override
    <VE> HashObjObjMapFactory<K, VE>
    withValueEquivalence(@Nullable Equivalence<VE> valueEquivalence);


    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newMutableMap();

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newMutableMap(int expectedSize);

    

    /**
     * If the specified map has the same key equivalence with this factory,
     * {@code expectedSize} is ignored.
     */
    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newMutableMap(Map<? extends K2, ? extends V2> map, int expectedSize);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newMutableMap(Map<? extends K2, ? extends V2> map1,
            Map<? extends K2, ? extends V2> map2, int expectedSize);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newMutableMap(Map<? extends K2, ? extends V2> map1,
            Map<? extends K2, ? extends V2> map2, Map<? extends K2, ? extends V2> map3, int expectedSize);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newMutableMap(Map<? extends K2, ? extends V2> map1,
            Map<? extends K2, ? extends V2> map2, Map<? extends K2, ? extends V2> map3,
            Map<? extends K2, ? extends V2> map4, int expectedSize);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newMutableMap(Map<? extends K2, ? extends V2> map1,
            Map<? extends K2, ? extends V2> map2, Map<? extends K2, ? extends V2> map3,
            Map<? extends K2, ? extends V2> map4, Map<? extends K2, ? extends V2> map5, int expectedSize);

    

    
    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newMutableMap(Map<? extends K2, ? extends V2> map);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newMutableMap(Map<? extends K2, ? extends V2> map1,
            Map<? extends K2, ? extends V2> map2);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newMutableMap(Map<? extends K2, ? extends V2> map1,
            Map<? extends K2, ? extends V2> map2, Map<? extends K2, ? extends V2> map3);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newMutableMap(Map<? extends K2, ? extends V2> map1,
            Map<? extends K2, ? extends V2> map2, Map<? extends K2, ? extends V2> map3,
            Map<? extends K2, ? extends V2> map4);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newMutableMap(Map<? extends K2, ? extends V2> map1,
            Map<? extends K2, ? extends V2> map2, Map<? extends K2, ? extends V2> map3,
            Map<? extends K2, ? extends V2> map4, Map<? extends K2, ? extends V2> map5);


    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newMutableMap(
            net.openhft.function.Consumer<BiConsumer<K2, V2>> entriesSupplier);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newMutableMap(
            net.openhft.function.Consumer<BiConsumer<K2, V2>> entriesSupplier,
            int expectedSize);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newMutableMap(K2[] keys, V2[] values);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newMutableMap(K2[] keys, V2[] values,
            int expectedSize);


    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newMutableMap(Iterable<? extends K2> keys,
            Iterable<? extends V2> values);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newMutableMap(Iterable<? extends K2> keys,
            Iterable<? extends V2> values, int expectedSize);


    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newMutableMapOf(K2 k1, V2 v1);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newMutableMapOf(K2 k1, V2 v1,
            K2 k2, V2 v2);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newMutableMapOf(K2 k1, V2 v1,
            K2 k2, V2 v2, K2 k3, V2 v3);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newMutableMapOf(K2 k1, V2 v1,
            K2 k2, V2 v2, K2 k3, V2 v3,
            K2 k4, V2 v4);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newMutableMapOf(K2 k1, V2 v1,
            K2 k2, V2 v2, K2 k3, V2 v3,
            K2 k4, V2 v4, K2 k5, V2 v5);
    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newUpdatableMap();

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newUpdatableMap(int expectedSize);

    

    /**
     * If the specified map has the same key equivalence with this factory,
     * {@code expectedSize} is ignored.
     */
    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newUpdatableMap(Map<? extends K2, ? extends V2> map, int expectedSize);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newUpdatableMap(Map<? extends K2, ? extends V2> map1,
            Map<? extends K2, ? extends V2> map2, int expectedSize);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newUpdatableMap(Map<? extends K2, ? extends V2> map1,
            Map<? extends K2, ? extends V2> map2, Map<? extends K2, ? extends V2> map3, int expectedSize);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newUpdatableMap(Map<? extends K2, ? extends V2> map1,
            Map<? extends K2, ? extends V2> map2, Map<? extends K2, ? extends V2> map3,
            Map<? extends K2, ? extends V2> map4, int expectedSize);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newUpdatableMap(Map<? extends K2, ? extends V2> map1,
            Map<? extends K2, ? extends V2> map2, Map<? extends K2, ? extends V2> map3,
            Map<? extends K2, ? extends V2> map4, Map<? extends K2, ? extends V2> map5, int expectedSize);

    

    
    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newUpdatableMap(Map<? extends K2, ? extends V2> map);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newUpdatableMap(Map<? extends K2, ? extends V2> map1,
            Map<? extends K2, ? extends V2> map2);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newUpdatableMap(Map<? extends K2, ? extends V2> map1,
            Map<? extends K2, ? extends V2> map2, Map<? extends K2, ? extends V2> map3);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newUpdatableMap(Map<? extends K2, ? extends V2> map1,
            Map<? extends K2, ? extends V2> map2, Map<? extends K2, ? extends V2> map3,
            Map<? extends K2, ? extends V2> map4);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newUpdatableMap(Map<? extends K2, ? extends V2> map1,
            Map<? extends K2, ? extends V2> map2, Map<? extends K2, ? extends V2> map3,
            Map<? extends K2, ? extends V2> map4, Map<? extends K2, ? extends V2> map5);


    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newUpdatableMap(
            net.openhft.function.Consumer<BiConsumer<K2, V2>> entriesSupplier);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newUpdatableMap(
            net.openhft.function.Consumer<BiConsumer<K2, V2>> entriesSupplier,
            int expectedSize);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newUpdatableMap(K2[] keys, V2[] values);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newUpdatableMap(K2[] keys, V2[] values,
            int expectedSize);


    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newUpdatableMap(Iterable<? extends K2> keys,
            Iterable<? extends V2> values);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newUpdatableMap(Iterable<? extends K2> keys,
            Iterable<? extends V2> values, int expectedSize);


    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newUpdatableMapOf(K2 k1, V2 v1);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newUpdatableMapOf(K2 k1, V2 v1,
            K2 k2, V2 v2);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newUpdatableMapOf(K2 k1, V2 v1,
            K2 k2, V2 v2, K2 k3, V2 v3);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newUpdatableMapOf(K2 k1, V2 v1,
            K2 k2, V2 v2, K2 k3, V2 v3,
            K2 k4, V2 v4);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newUpdatableMapOf(K2 k1, V2 v1,
            K2 k2, V2 v2, K2 k3, V2 v3,
            K2 k4, V2 v4, K2 k5, V2 v5);

    

    /**
     * If the specified map has the same key equivalence with this factory,
     * {@code expectedSize} is ignored.
     */
    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newImmutableMap(Map<? extends K2, ? extends V2> map, int expectedSize);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newImmutableMap(Map<? extends K2, ? extends V2> map1,
            Map<? extends K2, ? extends V2> map2, int expectedSize);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newImmutableMap(Map<? extends K2, ? extends V2> map1,
            Map<? extends K2, ? extends V2> map2, Map<? extends K2, ? extends V2> map3, int expectedSize);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newImmutableMap(Map<? extends K2, ? extends V2> map1,
            Map<? extends K2, ? extends V2> map2, Map<? extends K2, ? extends V2> map3,
            Map<? extends K2, ? extends V2> map4, int expectedSize);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newImmutableMap(Map<? extends K2, ? extends V2> map1,
            Map<? extends K2, ? extends V2> map2, Map<? extends K2, ? extends V2> map3,
            Map<? extends K2, ? extends V2> map4, Map<? extends K2, ? extends V2> map5, int expectedSize);

    

    
    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newImmutableMap(Map<? extends K2, ? extends V2> map);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newImmutableMap(Map<? extends K2, ? extends V2> map1,
            Map<? extends K2, ? extends V2> map2);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newImmutableMap(Map<? extends K2, ? extends V2> map1,
            Map<? extends K2, ? extends V2> map2, Map<? extends K2, ? extends V2> map3);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newImmutableMap(Map<? extends K2, ? extends V2> map1,
            Map<? extends K2, ? extends V2> map2, Map<? extends K2, ? extends V2> map3,
            Map<? extends K2, ? extends V2> map4);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newImmutableMap(Map<? extends K2, ? extends V2> map1,
            Map<? extends K2, ? extends V2> map2, Map<? extends K2, ? extends V2> map3,
            Map<? extends K2, ? extends V2> map4, Map<? extends K2, ? extends V2> map5);


    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newImmutableMap(
            net.openhft.function.Consumer<BiConsumer<K2, V2>> entriesSupplier);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newImmutableMap(
            net.openhft.function.Consumer<BiConsumer<K2, V2>> entriesSupplier,
            int expectedSize);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newImmutableMap(K2[] keys, V2[] values);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newImmutableMap(K2[] keys, V2[] values,
            int expectedSize);


    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newImmutableMap(Iterable<? extends K2> keys,
            Iterable<? extends V2> values);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newImmutableMap(Iterable<? extends K2> keys,
            Iterable<? extends V2> values, int expectedSize);


    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newImmutableMapOf(K2 k1, V2 v1);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newImmutableMapOf(K2 k1, V2 v1,
            K2 k2, V2 v2);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newImmutableMapOf(K2 k1, V2 v1,
            K2 k2, V2 v2, K2 k3, V2 v3);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newImmutableMapOf(K2 k1, V2 v1,
            K2 k2, V2 v2, K2 k3, V2 v3,
            K2 k4, V2 v4);

    @Override
    <K2 extends K, V2 extends V> HashObjObjMap<K2, V2> newImmutableMapOf(K2 k1, V2 v1,
            K2 k2, V2 v2, K2 k3, V2 v3,
            K2 k4, V2 v4, K2 k5, V2 v5);
}

