/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.ObjIntConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashObjIntMaps}
 *
 * @see HashObjIntMap
 * @see HashObjIntMaps#getDefaultFactory()
 */
public interface HashObjIntMapFactory<K> extends ObjIntMapFactory<K>
        , ObjHashFactory<HashObjIntMapFactory<K>>
         {

    

    

    

    

    

    
    

    
    

    <KE> HashObjIntMapFactory<KE>
    withKeyEquivalence(@Nullable Equivalence<KE> keyEquivalence);

    @Override
    HashObjIntMapFactory<K> withDefaultValue(int defaultValue);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newMutableMap();

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newMutableMap(int expectedSize);

    

    /**
     * If the specified map has the same key equivalence with this factory,
     * {@code expectedSize} is ignored.
     */
    @Override
    <K2 extends K>
     HashObjIntMap<K2> newMutableMap(Map<? extends K2, Integer> map, int expectedSize);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newMutableMap(Map<? extends K2, Integer> map1,
            Map<? extends K2, Integer> map2, int expectedSize);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newMutableMap(Map<? extends K2, Integer> map1,
            Map<? extends K2, Integer> map2, Map<? extends K2, Integer> map3, int expectedSize);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newMutableMap(Map<? extends K2, Integer> map1,
            Map<? extends K2, Integer> map2, Map<? extends K2, Integer> map3,
            Map<? extends K2, Integer> map4, int expectedSize);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newMutableMap(Map<? extends K2, Integer> map1,
            Map<? extends K2, Integer> map2, Map<? extends K2, Integer> map3,
            Map<? extends K2, Integer> map4, Map<? extends K2, Integer> map5, int expectedSize);

    

    
    @Override
    <K2 extends K>
     HashObjIntMap<K2> newMutableMap(Map<? extends K2, Integer> map);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newMutableMap(Map<? extends K2, Integer> map1,
            Map<? extends K2, Integer> map2);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newMutableMap(Map<? extends K2, Integer> map1,
            Map<? extends K2, Integer> map2, Map<? extends K2, Integer> map3);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newMutableMap(Map<? extends K2, Integer> map1,
            Map<? extends K2, Integer> map2, Map<? extends K2, Integer> map3,
            Map<? extends K2, Integer> map4);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newMutableMap(Map<? extends K2, Integer> map1,
            Map<? extends K2, Integer> map2, Map<? extends K2, Integer> map3,
            Map<? extends K2, Integer> map4, Map<? extends K2, Integer> map5);


    @Override
    <K2 extends K>
     HashObjIntMap<K2> newMutableMap(
            net.openhft.function.Consumer<ObjIntConsumer<K2>> entriesSupplier);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newMutableMap(
            net.openhft.function.Consumer<ObjIntConsumer<K2>> entriesSupplier,
            int expectedSize);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newMutableMap(K2[] keys, int[] values);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newMutableMap(K2[] keys, int[] values,
            int expectedSize);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newMutableMap(
            K2[] keys, Integer[] values);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newMutableMap(
            K2[] keys, Integer[] values, int expectedSize);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newMutableMap(Iterable<? extends K2> keys,
            Iterable<Integer> values);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newMutableMap(Iterable<? extends K2> keys,
            Iterable<Integer> values, int expectedSize);


    @Override
    <K2 extends K>
     HashObjIntMap<K2> newMutableMapOf(K2 k1, int v1);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newMutableMapOf(K2 k1, int v1,
            K2 k2, int v2);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newMutableMapOf(K2 k1, int v1,
            K2 k2, int v2, K2 k3, int v3);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newMutableMapOf(K2 k1, int v1,
            K2 k2, int v2, K2 k3, int v3,
            K2 k4, int v4);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newMutableMapOf(K2 k1, int v1,
            K2 k2, int v2, K2 k3, int v3,
            K2 k4, int v4, K2 k5, int v5);
    @Override
    <K2 extends K>
     HashObjIntMap<K2> newUpdatableMap();

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newUpdatableMap(int expectedSize);

    

    /**
     * If the specified map has the same key equivalence with this factory,
     * {@code expectedSize} is ignored.
     */
    @Override
    <K2 extends K>
     HashObjIntMap<K2> newUpdatableMap(Map<? extends K2, Integer> map, int expectedSize);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newUpdatableMap(Map<? extends K2, Integer> map1,
            Map<? extends K2, Integer> map2, int expectedSize);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newUpdatableMap(Map<? extends K2, Integer> map1,
            Map<? extends K2, Integer> map2, Map<? extends K2, Integer> map3, int expectedSize);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newUpdatableMap(Map<? extends K2, Integer> map1,
            Map<? extends K2, Integer> map2, Map<? extends K2, Integer> map3,
            Map<? extends K2, Integer> map4, int expectedSize);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newUpdatableMap(Map<? extends K2, Integer> map1,
            Map<? extends K2, Integer> map2, Map<? extends K2, Integer> map3,
            Map<? extends K2, Integer> map4, Map<? extends K2, Integer> map5, int expectedSize);

    

    
    @Override
    <K2 extends K>
     HashObjIntMap<K2> newUpdatableMap(Map<? extends K2, Integer> map);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newUpdatableMap(Map<? extends K2, Integer> map1,
            Map<? extends K2, Integer> map2);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newUpdatableMap(Map<? extends K2, Integer> map1,
            Map<? extends K2, Integer> map2, Map<? extends K2, Integer> map3);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newUpdatableMap(Map<? extends K2, Integer> map1,
            Map<? extends K2, Integer> map2, Map<? extends K2, Integer> map3,
            Map<? extends K2, Integer> map4);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newUpdatableMap(Map<? extends K2, Integer> map1,
            Map<? extends K2, Integer> map2, Map<? extends K2, Integer> map3,
            Map<? extends K2, Integer> map4, Map<? extends K2, Integer> map5);


    @Override
    <K2 extends K>
     HashObjIntMap<K2> newUpdatableMap(
            net.openhft.function.Consumer<ObjIntConsumer<K2>> entriesSupplier);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newUpdatableMap(
            net.openhft.function.Consumer<ObjIntConsumer<K2>> entriesSupplier,
            int expectedSize);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newUpdatableMap(K2[] keys, int[] values);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newUpdatableMap(K2[] keys, int[] values,
            int expectedSize);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newUpdatableMap(
            K2[] keys, Integer[] values);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newUpdatableMap(
            K2[] keys, Integer[] values, int expectedSize);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newUpdatableMap(Iterable<? extends K2> keys,
            Iterable<Integer> values);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newUpdatableMap(Iterable<? extends K2> keys,
            Iterable<Integer> values, int expectedSize);


    @Override
    <K2 extends K>
     HashObjIntMap<K2> newUpdatableMapOf(K2 k1, int v1);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newUpdatableMapOf(K2 k1, int v1,
            K2 k2, int v2);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newUpdatableMapOf(K2 k1, int v1,
            K2 k2, int v2, K2 k3, int v3);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newUpdatableMapOf(K2 k1, int v1,
            K2 k2, int v2, K2 k3, int v3,
            K2 k4, int v4);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newUpdatableMapOf(K2 k1, int v1,
            K2 k2, int v2, K2 k3, int v3,
            K2 k4, int v4, K2 k5, int v5);

    

    /**
     * If the specified map has the same key equivalence with this factory,
     * {@code expectedSize} is ignored.
     */
    @Override
    <K2 extends K>
     HashObjIntMap<K2> newImmutableMap(Map<? extends K2, Integer> map, int expectedSize);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newImmutableMap(Map<? extends K2, Integer> map1,
            Map<? extends K2, Integer> map2, int expectedSize);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newImmutableMap(Map<? extends K2, Integer> map1,
            Map<? extends K2, Integer> map2, Map<? extends K2, Integer> map3, int expectedSize);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newImmutableMap(Map<? extends K2, Integer> map1,
            Map<? extends K2, Integer> map2, Map<? extends K2, Integer> map3,
            Map<? extends K2, Integer> map4, int expectedSize);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newImmutableMap(Map<? extends K2, Integer> map1,
            Map<? extends K2, Integer> map2, Map<? extends K2, Integer> map3,
            Map<? extends K2, Integer> map4, Map<? extends K2, Integer> map5, int expectedSize);

    

    
    @Override
    <K2 extends K>
     HashObjIntMap<K2> newImmutableMap(Map<? extends K2, Integer> map);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newImmutableMap(Map<? extends K2, Integer> map1,
            Map<? extends K2, Integer> map2);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newImmutableMap(Map<? extends K2, Integer> map1,
            Map<? extends K2, Integer> map2, Map<? extends K2, Integer> map3);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newImmutableMap(Map<? extends K2, Integer> map1,
            Map<? extends K2, Integer> map2, Map<? extends K2, Integer> map3,
            Map<? extends K2, Integer> map4);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newImmutableMap(Map<? extends K2, Integer> map1,
            Map<? extends K2, Integer> map2, Map<? extends K2, Integer> map3,
            Map<? extends K2, Integer> map4, Map<? extends K2, Integer> map5);


    @Override
    <K2 extends K>
     HashObjIntMap<K2> newImmutableMap(
            net.openhft.function.Consumer<ObjIntConsumer<K2>> entriesSupplier);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newImmutableMap(
            net.openhft.function.Consumer<ObjIntConsumer<K2>> entriesSupplier,
            int expectedSize);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newImmutableMap(K2[] keys, int[] values);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newImmutableMap(K2[] keys, int[] values,
            int expectedSize);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newImmutableMap(
            K2[] keys, Integer[] values);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newImmutableMap(
            K2[] keys, Integer[] values, int expectedSize);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newImmutableMap(Iterable<? extends K2> keys,
            Iterable<Integer> values);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newImmutableMap(Iterable<? extends K2> keys,
            Iterable<Integer> values, int expectedSize);


    @Override
    <K2 extends K>
     HashObjIntMap<K2> newImmutableMapOf(K2 k1, int v1);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newImmutableMapOf(K2 k1, int v1,
            K2 k2, int v2);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newImmutableMapOf(K2 k1, int v1,
            K2 k2, int v2, K2 k3, int v3);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newImmutableMapOf(K2 k1, int v1,
            K2 k2, int v2, K2 k3, int v3,
            K2 k4, int v4);

    @Override
    <K2 extends K>
     HashObjIntMap<K2> newImmutableMapOf(K2 k1, int v1,
            K2 k2, int v2, K2 k3, int v3,
            K2 k4, int v4, K2 k5, int v5);
}

