/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.ObjFloatConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashObjFloatMaps}
 *
 * @see HashObjFloatMap
 * @see HashObjFloatMaps#getDefaultFactory()
 */
public interface HashObjFloatMapFactory<K> extends ObjFloatMapFactory<K>
        , ObjHashFactory<HashObjFloatMapFactory<K>>
         {

    

    

    

    

    

    
    

    
    

    <KE> HashObjFloatMapFactory<KE>
    withKeyEquivalence(@Nullable Equivalence<KE> keyEquivalence);

    @Override
    HashObjFloatMapFactory<K> withDefaultValue(float defaultValue);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newMutableMap();

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newMutableMap(int expectedSize);

    

    /**
     * If the specified map has the same key equivalence with this factory,
     * {@code expectedSize} is ignored.
     */
    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newMutableMap(Map<? extends K2, Float> map, int expectedSize);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newMutableMap(Map<? extends K2, Float> map1,
            Map<? extends K2, Float> map2, int expectedSize);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newMutableMap(Map<? extends K2, Float> map1,
            Map<? extends K2, Float> map2, Map<? extends K2, Float> map3, int expectedSize);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newMutableMap(Map<? extends K2, Float> map1,
            Map<? extends K2, Float> map2, Map<? extends K2, Float> map3,
            Map<? extends K2, Float> map4, int expectedSize);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newMutableMap(Map<? extends K2, Float> map1,
            Map<? extends K2, Float> map2, Map<? extends K2, Float> map3,
            Map<? extends K2, Float> map4, Map<? extends K2, Float> map5, int expectedSize);

    

    
    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newMutableMap(Map<? extends K2, Float> map);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newMutableMap(Map<? extends K2, Float> map1,
            Map<? extends K2, Float> map2);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newMutableMap(Map<? extends K2, Float> map1,
            Map<? extends K2, Float> map2, Map<? extends K2, Float> map3);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newMutableMap(Map<? extends K2, Float> map1,
            Map<? extends K2, Float> map2, Map<? extends K2, Float> map3,
            Map<? extends K2, Float> map4);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newMutableMap(Map<? extends K2, Float> map1,
            Map<? extends K2, Float> map2, Map<? extends K2, Float> map3,
            Map<? extends K2, Float> map4, Map<? extends K2, Float> map5);


    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newMutableMap(
            net.openhft.function.Consumer<ObjFloatConsumer<K2>> entriesSupplier);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newMutableMap(
            net.openhft.function.Consumer<ObjFloatConsumer<K2>> entriesSupplier,
            int expectedSize);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newMutableMap(K2[] keys, float[] values);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newMutableMap(K2[] keys, float[] values,
            int expectedSize);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newMutableMap(
            K2[] keys, Float[] values);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newMutableMap(
            K2[] keys, Float[] values, int expectedSize);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newMutableMap(Iterable<? extends K2> keys,
            Iterable<Float> values);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newMutableMap(Iterable<? extends K2> keys,
            Iterable<Float> values, int expectedSize);


    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newMutableMapOf(K2 k1, float v1);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newMutableMapOf(K2 k1, float v1,
            K2 k2, float v2);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newMutableMapOf(K2 k1, float v1,
            K2 k2, float v2, K2 k3, float v3);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newMutableMapOf(K2 k1, float v1,
            K2 k2, float v2, K2 k3, float v3,
            K2 k4, float v4);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newMutableMapOf(K2 k1, float v1,
            K2 k2, float v2, K2 k3, float v3,
            K2 k4, float v4, K2 k5, float v5);
    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newUpdatableMap();

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newUpdatableMap(int expectedSize);

    

    /**
     * If the specified map has the same key equivalence with this factory,
     * {@code expectedSize} is ignored.
     */
    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newUpdatableMap(Map<? extends K2, Float> map, int expectedSize);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newUpdatableMap(Map<? extends K2, Float> map1,
            Map<? extends K2, Float> map2, int expectedSize);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newUpdatableMap(Map<? extends K2, Float> map1,
            Map<? extends K2, Float> map2, Map<? extends K2, Float> map3, int expectedSize);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newUpdatableMap(Map<? extends K2, Float> map1,
            Map<? extends K2, Float> map2, Map<? extends K2, Float> map3,
            Map<? extends K2, Float> map4, int expectedSize);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newUpdatableMap(Map<? extends K2, Float> map1,
            Map<? extends K2, Float> map2, Map<? extends K2, Float> map3,
            Map<? extends K2, Float> map4, Map<? extends K2, Float> map5, int expectedSize);

    

    
    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newUpdatableMap(Map<? extends K2, Float> map);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newUpdatableMap(Map<? extends K2, Float> map1,
            Map<? extends K2, Float> map2);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newUpdatableMap(Map<? extends K2, Float> map1,
            Map<? extends K2, Float> map2, Map<? extends K2, Float> map3);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newUpdatableMap(Map<? extends K2, Float> map1,
            Map<? extends K2, Float> map2, Map<? extends K2, Float> map3,
            Map<? extends K2, Float> map4);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newUpdatableMap(Map<? extends K2, Float> map1,
            Map<? extends K2, Float> map2, Map<? extends K2, Float> map3,
            Map<? extends K2, Float> map4, Map<? extends K2, Float> map5);


    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newUpdatableMap(
            net.openhft.function.Consumer<ObjFloatConsumer<K2>> entriesSupplier);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newUpdatableMap(
            net.openhft.function.Consumer<ObjFloatConsumer<K2>> entriesSupplier,
            int expectedSize);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newUpdatableMap(K2[] keys, float[] values);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newUpdatableMap(K2[] keys, float[] values,
            int expectedSize);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newUpdatableMap(
            K2[] keys, Float[] values);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newUpdatableMap(
            K2[] keys, Float[] values, int expectedSize);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newUpdatableMap(Iterable<? extends K2> keys,
            Iterable<Float> values);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newUpdatableMap(Iterable<? extends K2> keys,
            Iterable<Float> values, int expectedSize);


    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newUpdatableMapOf(K2 k1, float v1);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newUpdatableMapOf(K2 k1, float v1,
            K2 k2, float v2);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newUpdatableMapOf(K2 k1, float v1,
            K2 k2, float v2, K2 k3, float v3);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newUpdatableMapOf(K2 k1, float v1,
            K2 k2, float v2, K2 k3, float v3,
            K2 k4, float v4);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newUpdatableMapOf(K2 k1, float v1,
            K2 k2, float v2, K2 k3, float v3,
            K2 k4, float v4, K2 k5, float v5);

    

    /**
     * If the specified map has the same key equivalence with this factory,
     * {@code expectedSize} is ignored.
     */
    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newImmutableMap(Map<? extends K2, Float> map, int expectedSize);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newImmutableMap(Map<? extends K2, Float> map1,
            Map<? extends K2, Float> map2, int expectedSize);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newImmutableMap(Map<? extends K2, Float> map1,
            Map<? extends K2, Float> map2, Map<? extends K2, Float> map3, int expectedSize);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newImmutableMap(Map<? extends K2, Float> map1,
            Map<? extends K2, Float> map2, Map<? extends K2, Float> map3,
            Map<? extends K2, Float> map4, int expectedSize);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newImmutableMap(Map<? extends K2, Float> map1,
            Map<? extends K2, Float> map2, Map<? extends K2, Float> map3,
            Map<? extends K2, Float> map4, Map<? extends K2, Float> map5, int expectedSize);

    

    
    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newImmutableMap(Map<? extends K2, Float> map);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newImmutableMap(Map<? extends K2, Float> map1,
            Map<? extends K2, Float> map2);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newImmutableMap(Map<? extends K2, Float> map1,
            Map<? extends K2, Float> map2, Map<? extends K2, Float> map3);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newImmutableMap(Map<? extends K2, Float> map1,
            Map<? extends K2, Float> map2, Map<? extends K2, Float> map3,
            Map<? extends K2, Float> map4);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newImmutableMap(Map<? extends K2, Float> map1,
            Map<? extends K2, Float> map2, Map<? extends K2, Float> map3,
            Map<? extends K2, Float> map4, Map<? extends K2, Float> map5);


    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newImmutableMap(
            net.openhft.function.Consumer<ObjFloatConsumer<K2>> entriesSupplier);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newImmutableMap(
            net.openhft.function.Consumer<ObjFloatConsumer<K2>> entriesSupplier,
            int expectedSize);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newImmutableMap(K2[] keys, float[] values);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newImmutableMap(K2[] keys, float[] values,
            int expectedSize);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newImmutableMap(
            K2[] keys, Float[] values);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newImmutableMap(
            K2[] keys, Float[] values, int expectedSize);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newImmutableMap(Iterable<? extends K2> keys,
            Iterable<Float> values);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newImmutableMap(Iterable<? extends K2> keys,
            Iterable<Float> values, int expectedSize);


    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newImmutableMapOf(K2 k1, float v1);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newImmutableMapOf(K2 k1, float v1,
            K2 k2, float v2);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newImmutableMapOf(K2 k1, float v1,
            K2 k2, float v2, K2 k3, float v3);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newImmutableMapOf(K2 k1, float v1,
            K2 k2, float v2, K2 k3, float v3,
            K2 k4, float v4);

    @Override
    <K2 extends K>
     HashObjFloatMap<K2> newImmutableMapOf(K2 k1, float v1,
            K2 k2, float v2, K2 k3, float v3,
            K2 k4, float v4, K2 k5, float v5);
}

