/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.ObjDoubleConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashObjDoubleMap}s, and
 * the default {@link HashObjDoubleMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashObjDoubleMap
 */
public final class HashObjDoubleMaps {

    

    private static final ServiceLoader<HashObjDoubleMapFactory> LOADER =
            ServiceLoader.load(HashObjDoubleMapFactory.class);
    private static HashObjDoubleMapFactory<Object> defaultFactory = null;

    public static HashObjDoubleMapFactory<Object> getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static <K> HashObjDoubleMap<K> newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static <K> HashObjDoubleMap<K> newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    

    /**
     * If the specified map doesn't have specific key equivalence, {@code expectedSize} is ignored.
     */
    public static <K> HashObjDoubleMap<K> newMutableMap(
            Map<? extends K, Double> map, int expectedSize) {
        return getDefaultFactory().newMutableMap(map, expectedSize);
    }

    public static <K> HashObjDoubleMap<K> newMutableMap(Map<? extends K, Double> map1,
            Map<? extends K, Double> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static <K> HashObjDoubleMap<K> newMutableMap(Map<? extends K, Double> map1,
            Map<? extends K, Double> map2, Map<? extends K, Double> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static <K> HashObjDoubleMap<K> newMutableMap(Map<? extends K, Double> map1,
            Map<? extends K, Double> map2, Map<? extends K, Double> map3,
            Map<? extends K, Double> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static <K> HashObjDoubleMap<K> newMutableMap(Map<? extends K, Double> map1,
            Map<? extends K, Double> map2, Map<? extends K, Double> map3,
            Map<? extends K, Double> map4, Map<? extends K, Double> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static <K> HashObjDoubleMap<K> newMutableMap(
            Map<? extends K, Double> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static <K> HashObjDoubleMap<K> newMutableMap(Map<? extends K, Double> map1,
            Map<? extends K, Double> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static <K> HashObjDoubleMap<K> newMutableMap(Map<? extends K, Double> map1,
            Map<? extends K, Double> map2, Map<? extends K, Double> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static <K> HashObjDoubleMap<K> newMutableMap(Map<? extends K, Double> map1,
            Map<? extends K, Double> map2, Map<? extends K, Double> map3,
            Map<? extends K, Double> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static <K> HashObjDoubleMap<K> newMutableMap(Map<? extends K, Double> map1,
            Map<? extends K, Double> map2, Map<? extends K, Double> map3,
            Map<? extends K, Double> map4, Map<? extends K, Double> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static <K> HashObjDoubleMap<K> newMutableMap(
            net.openhft.function.Consumer<ObjDoubleConsumer<K>> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static <K> HashObjDoubleMap<K> newMutableMap(
            net.openhft.function.Consumer<ObjDoubleConsumer<K>> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static <K> HashObjDoubleMap<K> newMutableMap(
            K[] keys, double[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static <K> HashObjDoubleMap<K> newMutableMap(
            K[] keys, double[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static <K> HashObjDoubleMap<K> newMutableMap(
            K[] keys, Double[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static <K> HashObjDoubleMap<K> newMutableMap(
            K[] keys, Double[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static <K> HashObjDoubleMap<K> newMutableMap(Iterable<? extends K> keys,
            Iterable<Double> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static <K> HashObjDoubleMap<K> newMutableMap(Iterable<? extends K> keys,
            Iterable<Double> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static <K> HashObjDoubleMap<K> newMutableMapOf(
            K k1, double v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static <K> HashObjDoubleMap<K> newMutableMapOf(
            K k1, double v1, K k2, double v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static <K> HashObjDoubleMap<K> newMutableMapOf(
            K k1, double v1, K k2, double v2,
            K k3, double v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static <K> HashObjDoubleMap<K> newMutableMapOf(
            K k1, double v1, K k2, double v2,
            K k3, double v3, K k4, double v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static <K> HashObjDoubleMap<K> newMutableMapOf(
            K k1, double v1, K k2, double v2,
            K k3, double v3, K k4, double v4,
            K k5, double v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    

    /**
     * If the specified map doesn't have specific key equivalence, {@code expectedSize} is ignored.
     */
    public static <K> HashObjDoubleMap<K> newUpdatableMap(
            Map<? extends K, Double> map, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map, expectedSize);
    }

    public static <K> HashObjDoubleMap<K> newUpdatableMap(Map<? extends K, Double> map1,
            Map<? extends K, Double> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static <K> HashObjDoubleMap<K> newUpdatableMap(Map<? extends K, Double> map1,
            Map<? extends K, Double> map2, Map<? extends K, Double> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static <K> HashObjDoubleMap<K> newUpdatableMap(Map<? extends K, Double> map1,
            Map<? extends K, Double> map2, Map<? extends K, Double> map3,
            Map<? extends K, Double> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static <K> HashObjDoubleMap<K> newUpdatableMap(Map<? extends K, Double> map1,
            Map<? extends K, Double> map2, Map<? extends K, Double> map3,
            Map<? extends K, Double> map4, Map<? extends K, Double> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static <K> HashObjDoubleMap<K> newUpdatableMap(
            Map<? extends K, Double> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static <K> HashObjDoubleMap<K> newUpdatableMap(Map<? extends K, Double> map1,
            Map<? extends K, Double> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static <K> HashObjDoubleMap<K> newUpdatableMap(Map<? extends K, Double> map1,
            Map<? extends K, Double> map2, Map<? extends K, Double> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static <K> HashObjDoubleMap<K> newUpdatableMap(Map<? extends K, Double> map1,
            Map<? extends K, Double> map2, Map<? extends K, Double> map3,
            Map<? extends K, Double> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static <K> HashObjDoubleMap<K> newUpdatableMap(Map<? extends K, Double> map1,
            Map<? extends K, Double> map2, Map<? extends K, Double> map3,
            Map<? extends K, Double> map4, Map<? extends K, Double> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static <K> HashObjDoubleMap<K> newUpdatableMap(
            net.openhft.function.Consumer<ObjDoubleConsumer<K>> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static <K> HashObjDoubleMap<K> newUpdatableMap(
            net.openhft.function.Consumer<ObjDoubleConsumer<K>> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static <K> HashObjDoubleMap<K> newUpdatableMap(
            K[] keys, double[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static <K> HashObjDoubleMap<K> newUpdatableMap(
            K[] keys, double[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static <K> HashObjDoubleMap<K> newUpdatableMap(
            K[] keys, Double[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static <K> HashObjDoubleMap<K> newUpdatableMap(
            K[] keys, Double[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static <K> HashObjDoubleMap<K> newUpdatableMap(Iterable<? extends K> keys,
            Iterable<Double> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static <K> HashObjDoubleMap<K> newUpdatableMap(Iterable<? extends K> keys,
            Iterable<Double> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static <K> HashObjDoubleMap<K> newUpdatableMapOf(
            K k1, double v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static <K> HashObjDoubleMap<K> newUpdatableMapOf(
            K k1, double v1, K k2, double v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static <K> HashObjDoubleMap<K> newUpdatableMapOf(
            K k1, double v1, K k2, double v2,
            K k3, double v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static <K> HashObjDoubleMap<K> newUpdatableMapOf(
            K k1, double v1, K k2, double v2,
            K k3, double v3, K k4, double v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static <K> HashObjDoubleMap<K> newUpdatableMapOf(
            K k1, double v1, K k2, double v2,
            K k3, double v3, K k4, double v4,
            K k5, double v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    

    /**
     * If the specified map doesn't have specific key equivalence, {@code expectedSize} is ignored.
     */
    public static <K> HashObjDoubleMap<K> newImmutableMap(
            Map<? extends K, Double> map, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map, expectedSize);
    }

    public static <K> HashObjDoubleMap<K> newImmutableMap(Map<? extends K, Double> map1,
            Map<? extends K, Double> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static <K> HashObjDoubleMap<K> newImmutableMap(Map<? extends K, Double> map1,
            Map<? extends K, Double> map2, Map<? extends K, Double> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static <K> HashObjDoubleMap<K> newImmutableMap(Map<? extends K, Double> map1,
            Map<? extends K, Double> map2, Map<? extends K, Double> map3,
            Map<? extends K, Double> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static <K> HashObjDoubleMap<K> newImmutableMap(Map<? extends K, Double> map1,
            Map<? extends K, Double> map2, Map<? extends K, Double> map3,
            Map<? extends K, Double> map4, Map<? extends K, Double> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static <K> HashObjDoubleMap<K> newImmutableMap(
            Map<? extends K, Double> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static <K> HashObjDoubleMap<K> newImmutableMap(Map<? extends K, Double> map1,
            Map<? extends K, Double> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static <K> HashObjDoubleMap<K> newImmutableMap(Map<? extends K, Double> map1,
            Map<? extends K, Double> map2, Map<? extends K, Double> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static <K> HashObjDoubleMap<K> newImmutableMap(Map<? extends K, Double> map1,
            Map<? extends K, Double> map2, Map<? extends K, Double> map3,
            Map<? extends K, Double> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static <K> HashObjDoubleMap<K> newImmutableMap(Map<? extends K, Double> map1,
            Map<? extends K, Double> map2, Map<? extends K, Double> map3,
            Map<? extends K, Double> map4, Map<? extends K, Double> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static <K> HashObjDoubleMap<K> newImmutableMap(
            net.openhft.function.Consumer<ObjDoubleConsumer<K>> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static <K> HashObjDoubleMap<K> newImmutableMap(
            net.openhft.function.Consumer<ObjDoubleConsumer<K>> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static <K> HashObjDoubleMap<K> newImmutableMap(
            K[] keys, double[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static <K> HashObjDoubleMap<K> newImmutableMap(
            K[] keys, double[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static <K> HashObjDoubleMap<K> newImmutableMap(
            K[] keys, Double[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static <K> HashObjDoubleMap<K> newImmutableMap(
            K[] keys, Double[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static <K> HashObjDoubleMap<K> newImmutableMap(Iterable<? extends K> keys,
            Iterable<Double> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static <K> HashObjDoubleMap<K> newImmutableMap(Iterable<? extends K> keys,
            Iterable<Double> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static <K> HashObjDoubleMap<K> newImmutableMapOf(
            K k1, double v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static <K> HashObjDoubleMap<K> newImmutableMapOf(
            K k1, double v1, K k2, double v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static <K> HashObjDoubleMap<K> newImmutableMapOf(
            K k1, double v1, K k2, double v2,
            K k3, double v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static <K> HashObjDoubleMap<K> newImmutableMapOf(
            K k1, double v1, K k2, double v2,
            K k3, double v3, K k4, double v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static <K> HashObjDoubleMap<K> newImmutableMapOf(
            K k1, double v1, K k2, double v2,
            K k3, double v3, K k4, double v4,
            K k5, double v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashObjDoubleMaps() {}
}

