/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.ObjDoubleConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashObjDoubleMaps}
 *
 * @see HashObjDoubleMap
 * @see HashObjDoubleMaps#getDefaultFactory()
 */
public interface HashObjDoubleMapFactory<K> extends ObjDoubleMapFactory<K>
        , ObjHashFactory<HashObjDoubleMapFactory<K>>
         {

    

    

    

    

    

    
    

    
    

    <KE> HashObjDoubleMapFactory<KE>
    withKeyEquivalence(@Nullable Equivalence<KE> keyEquivalence);

    @Override
    HashObjDoubleMapFactory<K> withDefaultValue(double defaultValue);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newMutableMap();

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newMutableMap(int expectedSize);

    

    /**
     * If the specified map has the same key equivalence with this factory,
     * {@code expectedSize} is ignored.
     */
    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newMutableMap(Map<? extends K2, Double> map, int expectedSize);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newMutableMap(Map<? extends K2, Double> map1,
            Map<? extends K2, Double> map2, int expectedSize);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newMutableMap(Map<? extends K2, Double> map1,
            Map<? extends K2, Double> map2, Map<? extends K2, Double> map3, int expectedSize);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newMutableMap(Map<? extends K2, Double> map1,
            Map<? extends K2, Double> map2, Map<? extends K2, Double> map3,
            Map<? extends K2, Double> map4, int expectedSize);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newMutableMap(Map<? extends K2, Double> map1,
            Map<? extends K2, Double> map2, Map<? extends K2, Double> map3,
            Map<? extends K2, Double> map4, Map<? extends K2, Double> map5, int expectedSize);

    

    
    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newMutableMap(Map<? extends K2, Double> map);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newMutableMap(Map<? extends K2, Double> map1,
            Map<? extends K2, Double> map2);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newMutableMap(Map<? extends K2, Double> map1,
            Map<? extends K2, Double> map2, Map<? extends K2, Double> map3);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newMutableMap(Map<? extends K2, Double> map1,
            Map<? extends K2, Double> map2, Map<? extends K2, Double> map3,
            Map<? extends K2, Double> map4);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newMutableMap(Map<? extends K2, Double> map1,
            Map<? extends K2, Double> map2, Map<? extends K2, Double> map3,
            Map<? extends K2, Double> map4, Map<? extends K2, Double> map5);


    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newMutableMap(
            net.openhft.function.Consumer<ObjDoubleConsumer<K2>> entriesSupplier);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newMutableMap(
            net.openhft.function.Consumer<ObjDoubleConsumer<K2>> entriesSupplier,
            int expectedSize);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newMutableMap(K2[] keys, double[] values);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newMutableMap(K2[] keys, double[] values,
            int expectedSize);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newMutableMap(
            K2[] keys, Double[] values);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newMutableMap(
            K2[] keys, Double[] values, int expectedSize);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newMutableMap(Iterable<? extends K2> keys,
            Iterable<Double> values);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newMutableMap(Iterable<? extends K2> keys,
            Iterable<Double> values, int expectedSize);


    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newMutableMapOf(K2 k1, double v1);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newMutableMapOf(K2 k1, double v1,
            K2 k2, double v2);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newMutableMapOf(K2 k1, double v1,
            K2 k2, double v2, K2 k3, double v3);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newMutableMapOf(K2 k1, double v1,
            K2 k2, double v2, K2 k3, double v3,
            K2 k4, double v4);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newMutableMapOf(K2 k1, double v1,
            K2 k2, double v2, K2 k3, double v3,
            K2 k4, double v4, K2 k5, double v5);
    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newUpdatableMap();

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newUpdatableMap(int expectedSize);

    

    /**
     * If the specified map has the same key equivalence with this factory,
     * {@code expectedSize} is ignored.
     */
    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newUpdatableMap(Map<? extends K2, Double> map, int expectedSize);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newUpdatableMap(Map<? extends K2, Double> map1,
            Map<? extends K2, Double> map2, int expectedSize);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newUpdatableMap(Map<? extends K2, Double> map1,
            Map<? extends K2, Double> map2, Map<? extends K2, Double> map3, int expectedSize);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newUpdatableMap(Map<? extends K2, Double> map1,
            Map<? extends K2, Double> map2, Map<? extends K2, Double> map3,
            Map<? extends K2, Double> map4, int expectedSize);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newUpdatableMap(Map<? extends K2, Double> map1,
            Map<? extends K2, Double> map2, Map<? extends K2, Double> map3,
            Map<? extends K2, Double> map4, Map<? extends K2, Double> map5, int expectedSize);

    

    
    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newUpdatableMap(Map<? extends K2, Double> map);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newUpdatableMap(Map<? extends K2, Double> map1,
            Map<? extends K2, Double> map2);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newUpdatableMap(Map<? extends K2, Double> map1,
            Map<? extends K2, Double> map2, Map<? extends K2, Double> map3);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newUpdatableMap(Map<? extends K2, Double> map1,
            Map<? extends K2, Double> map2, Map<? extends K2, Double> map3,
            Map<? extends K2, Double> map4);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newUpdatableMap(Map<? extends K2, Double> map1,
            Map<? extends K2, Double> map2, Map<? extends K2, Double> map3,
            Map<? extends K2, Double> map4, Map<? extends K2, Double> map5);


    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newUpdatableMap(
            net.openhft.function.Consumer<ObjDoubleConsumer<K2>> entriesSupplier);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newUpdatableMap(
            net.openhft.function.Consumer<ObjDoubleConsumer<K2>> entriesSupplier,
            int expectedSize);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newUpdatableMap(K2[] keys, double[] values);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newUpdatableMap(K2[] keys, double[] values,
            int expectedSize);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newUpdatableMap(
            K2[] keys, Double[] values);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newUpdatableMap(
            K2[] keys, Double[] values, int expectedSize);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newUpdatableMap(Iterable<? extends K2> keys,
            Iterable<Double> values);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newUpdatableMap(Iterable<? extends K2> keys,
            Iterable<Double> values, int expectedSize);


    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newUpdatableMapOf(K2 k1, double v1);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newUpdatableMapOf(K2 k1, double v1,
            K2 k2, double v2);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newUpdatableMapOf(K2 k1, double v1,
            K2 k2, double v2, K2 k3, double v3);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newUpdatableMapOf(K2 k1, double v1,
            K2 k2, double v2, K2 k3, double v3,
            K2 k4, double v4);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newUpdatableMapOf(K2 k1, double v1,
            K2 k2, double v2, K2 k3, double v3,
            K2 k4, double v4, K2 k5, double v5);

    

    /**
     * If the specified map has the same key equivalence with this factory,
     * {@code expectedSize} is ignored.
     */
    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newImmutableMap(Map<? extends K2, Double> map, int expectedSize);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newImmutableMap(Map<? extends K2, Double> map1,
            Map<? extends K2, Double> map2, int expectedSize);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newImmutableMap(Map<? extends K2, Double> map1,
            Map<? extends K2, Double> map2, Map<? extends K2, Double> map3, int expectedSize);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newImmutableMap(Map<? extends K2, Double> map1,
            Map<? extends K2, Double> map2, Map<? extends K2, Double> map3,
            Map<? extends K2, Double> map4, int expectedSize);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newImmutableMap(Map<? extends K2, Double> map1,
            Map<? extends K2, Double> map2, Map<? extends K2, Double> map3,
            Map<? extends K2, Double> map4, Map<? extends K2, Double> map5, int expectedSize);

    

    
    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newImmutableMap(Map<? extends K2, Double> map);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newImmutableMap(Map<? extends K2, Double> map1,
            Map<? extends K2, Double> map2);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newImmutableMap(Map<? extends K2, Double> map1,
            Map<? extends K2, Double> map2, Map<? extends K2, Double> map3);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newImmutableMap(Map<? extends K2, Double> map1,
            Map<? extends K2, Double> map2, Map<? extends K2, Double> map3,
            Map<? extends K2, Double> map4);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newImmutableMap(Map<? extends K2, Double> map1,
            Map<? extends K2, Double> map2, Map<? extends K2, Double> map3,
            Map<? extends K2, Double> map4, Map<? extends K2, Double> map5);


    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newImmutableMap(
            net.openhft.function.Consumer<ObjDoubleConsumer<K2>> entriesSupplier);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newImmutableMap(
            net.openhft.function.Consumer<ObjDoubleConsumer<K2>> entriesSupplier,
            int expectedSize);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newImmutableMap(K2[] keys, double[] values);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newImmutableMap(K2[] keys, double[] values,
            int expectedSize);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newImmutableMap(
            K2[] keys, Double[] values);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newImmutableMap(
            K2[] keys, Double[] values, int expectedSize);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newImmutableMap(Iterable<? extends K2> keys,
            Iterable<Double> values);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newImmutableMap(Iterable<? extends K2> keys,
            Iterable<Double> values, int expectedSize);


    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newImmutableMapOf(K2 k1, double v1);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newImmutableMapOf(K2 k1, double v1,
            K2 k2, double v2);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newImmutableMapOf(K2 k1, double v1,
            K2 k2, double v2, K2 k3, double v3);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newImmutableMapOf(K2 k1, double v1,
            K2 k2, double v2, K2 k3, double v3,
            K2 k4, double v4);

    @Override
    <K2 extends K>
     HashObjDoubleMap<K2> newImmutableMapOf(K2 k1, double v1,
            K2 k2, double v2, K2 k3, double v3,
            K2 k4, double v4, K2 k5, double v5);
}

