/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.ObjCharConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashObjCharMap}s, and
 * the default {@link HashObjCharMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashObjCharMap
 */
public final class HashObjCharMaps {

    

    private static final ServiceLoader<HashObjCharMapFactory> LOADER =
            ServiceLoader.load(HashObjCharMapFactory.class);
    private static HashObjCharMapFactory<Object> defaultFactory = null;

    public static HashObjCharMapFactory<Object> getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static <K> HashObjCharMap<K> newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static <K> HashObjCharMap<K> newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    

    /**
     * If the specified map doesn't have specific key equivalence, {@code expectedSize} is ignored.
     */
    public static <K> HashObjCharMap<K> newMutableMap(
            Map<? extends K, Character> map, int expectedSize) {
        return getDefaultFactory().newMutableMap(map, expectedSize);
    }

    public static <K> HashObjCharMap<K> newMutableMap(Map<? extends K, Character> map1,
            Map<? extends K, Character> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static <K> HashObjCharMap<K> newMutableMap(Map<? extends K, Character> map1,
            Map<? extends K, Character> map2, Map<? extends K, Character> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static <K> HashObjCharMap<K> newMutableMap(Map<? extends K, Character> map1,
            Map<? extends K, Character> map2, Map<? extends K, Character> map3,
            Map<? extends K, Character> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static <K> HashObjCharMap<K> newMutableMap(Map<? extends K, Character> map1,
            Map<? extends K, Character> map2, Map<? extends K, Character> map3,
            Map<? extends K, Character> map4, Map<? extends K, Character> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static <K> HashObjCharMap<K> newMutableMap(
            Map<? extends K, Character> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static <K> HashObjCharMap<K> newMutableMap(Map<? extends K, Character> map1,
            Map<? extends K, Character> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static <K> HashObjCharMap<K> newMutableMap(Map<? extends K, Character> map1,
            Map<? extends K, Character> map2, Map<? extends K, Character> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static <K> HashObjCharMap<K> newMutableMap(Map<? extends K, Character> map1,
            Map<? extends K, Character> map2, Map<? extends K, Character> map3,
            Map<? extends K, Character> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static <K> HashObjCharMap<K> newMutableMap(Map<? extends K, Character> map1,
            Map<? extends K, Character> map2, Map<? extends K, Character> map3,
            Map<? extends K, Character> map4, Map<? extends K, Character> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static <K> HashObjCharMap<K> newMutableMap(
            net.openhft.function.Consumer<ObjCharConsumer<K>> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static <K> HashObjCharMap<K> newMutableMap(
            net.openhft.function.Consumer<ObjCharConsumer<K>> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static <K> HashObjCharMap<K> newMutableMap(
            K[] keys, char[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static <K> HashObjCharMap<K> newMutableMap(
            K[] keys, char[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static <K> HashObjCharMap<K> newMutableMap(
            K[] keys, Character[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static <K> HashObjCharMap<K> newMutableMap(
            K[] keys, Character[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static <K> HashObjCharMap<K> newMutableMap(Iterable<? extends K> keys,
            Iterable<Character> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static <K> HashObjCharMap<K> newMutableMap(Iterable<? extends K> keys,
            Iterable<Character> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static <K> HashObjCharMap<K> newMutableMapOf(
            K k1, char v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static <K> HashObjCharMap<K> newMutableMapOf(
            K k1, char v1, K k2, char v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static <K> HashObjCharMap<K> newMutableMapOf(
            K k1, char v1, K k2, char v2,
            K k3, char v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static <K> HashObjCharMap<K> newMutableMapOf(
            K k1, char v1, K k2, char v2,
            K k3, char v3, K k4, char v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static <K> HashObjCharMap<K> newMutableMapOf(
            K k1, char v1, K k2, char v2,
            K k3, char v3, K k4, char v4,
            K k5, char v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    

    /**
     * If the specified map doesn't have specific key equivalence, {@code expectedSize} is ignored.
     */
    public static <K> HashObjCharMap<K> newUpdatableMap(
            Map<? extends K, Character> map, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map, expectedSize);
    }

    public static <K> HashObjCharMap<K> newUpdatableMap(Map<? extends K, Character> map1,
            Map<? extends K, Character> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static <K> HashObjCharMap<K> newUpdatableMap(Map<? extends K, Character> map1,
            Map<? extends K, Character> map2, Map<? extends K, Character> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static <K> HashObjCharMap<K> newUpdatableMap(Map<? extends K, Character> map1,
            Map<? extends K, Character> map2, Map<? extends K, Character> map3,
            Map<? extends K, Character> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static <K> HashObjCharMap<K> newUpdatableMap(Map<? extends K, Character> map1,
            Map<? extends K, Character> map2, Map<? extends K, Character> map3,
            Map<? extends K, Character> map4, Map<? extends K, Character> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static <K> HashObjCharMap<K> newUpdatableMap(
            Map<? extends K, Character> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static <K> HashObjCharMap<K> newUpdatableMap(Map<? extends K, Character> map1,
            Map<? extends K, Character> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static <K> HashObjCharMap<K> newUpdatableMap(Map<? extends K, Character> map1,
            Map<? extends K, Character> map2, Map<? extends K, Character> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static <K> HashObjCharMap<K> newUpdatableMap(Map<? extends K, Character> map1,
            Map<? extends K, Character> map2, Map<? extends K, Character> map3,
            Map<? extends K, Character> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static <K> HashObjCharMap<K> newUpdatableMap(Map<? extends K, Character> map1,
            Map<? extends K, Character> map2, Map<? extends K, Character> map3,
            Map<? extends K, Character> map4, Map<? extends K, Character> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static <K> HashObjCharMap<K> newUpdatableMap(
            net.openhft.function.Consumer<ObjCharConsumer<K>> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static <K> HashObjCharMap<K> newUpdatableMap(
            net.openhft.function.Consumer<ObjCharConsumer<K>> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static <K> HashObjCharMap<K> newUpdatableMap(
            K[] keys, char[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static <K> HashObjCharMap<K> newUpdatableMap(
            K[] keys, char[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static <K> HashObjCharMap<K> newUpdatableMap(
            K[] keys, Character[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static <K> HashObjCharMap<K> newUpdatableMap(
            K[] keys, Character[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static <K> HashObjCharMap<K> newUpdatableMap(Iterable<? extends K> keys,
            Iterable<Character> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static <K> HashObjCharMap<K> newUpdatableMap(Iterable<? extends K> keys,
            Iterable<Character> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static <K> HashObjCharMap<K> newUpdatableMapOf(
            K k1, char v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static <K> HashObjCharMap<K> newUpdatableMapOf(
            K k1, char v1, K k2, char v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static <K> HashObjCharMap<K> newUpdatableMapOf(
            K k1, char v1, K k2, char v2,
            K k3, char v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static <K> HashObjCharMap<K> newUpdatableMapOf(
            K k1, char v1, K k2, char v2,
            K k3, char v3, K k4, char v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static <K> HashObjCharMap<K> newUpdatableMapOf(
            K k1, char v1, K k2, char v2,
            K k3, char v3, K k4, char v4,
            K k5, char v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    

    /**
     * If the specified map doesn't have specific key equivalence, {@code expectedSize} is ignored.
     */
    public static <K> HashObjCharMap<K> newImmutableMap(
            Map<? extends K, Character> map, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map, expectedSize);
    }

    public static <K> HashObjCharMap<K> newImmutableMap(Map<? extends K, Character> map1,
            Map<? extends K, Character> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static <K> HashObjCharMap<K> newImmutableMap(Map<? extends K, Character> map1,
            Map<? extends K, Character> map2, Map<? extends K, Character> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static <K> HashObjCharMap<K> newImmutableMap(Map<? extends K, Character> map1,
            Map<? extends K, Character> map2, Map<? extends K, Character> map3,
            Map<? extends K, Character> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static <K> HashObjCharMap<K> newImmutableMap(Map<? extends K, Character> map1,
            Map<? extends K, Character> map2, Map<? extends K, Character> map3,
            Map<? extends K, Character> map4, Map<? extends K, Character> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static <K> HashObjCharMap<K> newImmutableMap(
            Map<? extends K, Character> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static <K> HashObjCharMap<K> newImmutableMap(Map<? extends K, Character> map1,
            Map<? extends K, Character> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static <K> HashObjCharMap<K> newImmutableMap(Map<? extends K, Character> map1,
            Map<? extends K, Character> map2, Map<? extends K, Character> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static <K> HashObjCharMap<K> newImmutableMap(Map<? extends K, Character> map1,
            Map<? extends K, Character> map2, Map<? extends K, Character> map3,
            Map<? extends K, Character> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static <K> HashObjCharMap<K> newImmutableMap(Map<? extends K, Character> map1,
            Map<? extends K, Character> map2, Map<? extends K, Character> map3,
            Map<? extends K, Character> map4, Map<? extends K, Character> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static <K> HashObjCharMap<K> newImmutableMap(
            net.openhft.function.Consumer<ObjCharConsumer<K>> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static <K> HashObjCharMap<K> newImmutableMap(
            net.openhft.function.Consumer<ObjCharConsumer<K>> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static <K> HashObjCharMap<K> newImmutableMap(
            K[] keys, char[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static <K> HashObjCharMap<K> newImmutableMap(
            K[] keys, char[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static <K> HashObjCharMap<K> newImmutableMap(
            K[] keys, Character[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static <K> HashObjCharMap<K> newImmutableMap(
            K[] keys, Character[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static <K> HashObjCharMap<K> newImmutableMap(Iterable<? extends K> keys,
            Iterable<Character> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static <K> HashObjCharMap<K> newImmutableMap(Iterable<? extends K> keys,
            Iterable<Character> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static <K> HashObjCharMap<K> newImmutableMapOf(
            K k1, char v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static <K> HashObjCharMap<K> newImmutableMapOf(
            K k1, char v1, K k2, char v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static <K> HashObjCharMap<K> newImmutableMapOf(
            K k1, char v1, K k2, char v2,
            K k3, char v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static <K> HashObjCharMap<K> newImmutableMapOf(
            K k1, char v1, K k2, char v2,
            K k3, char v3, K k4, char v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static <K> HashObjCharMap<K> newImmutableMapOf(
            K k1, char v1, K k2, char v2,
            K k3, char v3, K k4, char v4,
            K k5, char v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashObjCharMaps() {}
}

