/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.LongShortConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashLongShortMap}s, and
 * the default {@link HashLongShortMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashLongShortMap
 */
public final class HashLongShortMaps {

    

    private static final ServiceLoader<HashLongShortMapFactory> LOADER =
            ServiceLoader.load(HashLongShortMapFactory.class);
    private static HashLongShortMapFactory defaultFactory = null;

    public static HashLongShortMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashLongShortMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashLongShortMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashLongShortMap newMutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashLongShortMap newMutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashLongShortMap newMutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashLongShortMap newMutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4, Map<Long, Short> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashLongShortMap newMutableMap(
            Map<Long, Short> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashLongShortMap newMutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashLongShortMap newMutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashLongShortMap newMutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashLongShortMap newMutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4, Map<Long, Short> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashLongShortMap newMutableMap(
            net.openhft.function.Consumer<LongShortConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashLongShortMap newMutableMap(
            net.openhft.function.Consumer<LongShortConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashLongShortMap newMutableMap(
            long[] keys, short[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashLongShortMap newMutableMap(
            long[] keys, short[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashLongShortMap newMutableMap(
            Long[] keys, Short[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashLongShortMap newMutableMap(
            Long[] keys, Short[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashLongShortMap newMutableMap(Iterable<Long> keys,
            Iterable<Short> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashLongShortMap newMutableMap(Iterable<Long> keys,
            Iterable<Short> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashLongShortMap newMutableMapOf(
            long k1, short v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashLongShortMap newMutableMapOf(
            long k1, short v1, long k2, short v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashLongShortMap newMutableMapOf(
            long k1, short v1, long k2, short v2,
            long k3, short v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashLongShortMap newMutableMapOf(
            long k1, short v1, long k2, short v2,
            long k3, short v3, long k4, short v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashLongShortMap newMutableMapOf(
            long k1, short v1, long k2, short v2,
            long k3, short v3, long k4, short v4,
            long k5, short v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashLongShortMap newUpdatableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashLongShortMap newUpdatableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashLongShortMap newUpdatableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashLongShortMap newUpdatableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4, Map<Long, Short> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashLongShortMap newUpdatableMap(
            Map<Long, Short> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashLongShortMap newUpdatableMap(Map<Long, Short> map1,
            Map<Long, Short> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashLongShortMap newUpdatableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashLongShortMap newUpdatableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashLongShortMap newUpdatableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4, Map<Long, Short> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashLongShortMap newUpdatableMap(
            net.openhft.function.Consumer<LongShortConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashLongShortMap newUpdatableMap(
            net.openhft.function.Consumer<LongShortConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashLongShortMap newUpdatableMap(
            long[] keys, short[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashLongShortMap newUpdatableMap(
            long[] keys, short[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashLongShortMap newUpdatableMap(
            Long[] keys, Short[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashLongShortMap newUpdatableMap(
            Long[] keys, Short[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashLongShortMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Short> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashLongShortMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Short> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashLongShortMap newUpdatableMapOf(
            long k1, short v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashLongShortMap newUpdatableMapOf(
            long k1, short v1, long k2, short v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashLongShortMap newUpdatableMapOf(
            long k1, short v1, long k2, short v2,
            long k3, short v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashLongShortMap newUpdatableMapOf(
            long k1, short v1, long k2, short v2,
            long k3, short v3, long k4, short v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashLongShortMap newUpdatableMapOf(
            long k1, short v1, long k2, short v2,
            long k3, short v3, long k4, short v4,
            long k5, short v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashLongShortMap newImmutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashLongShortMap newImmutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashLongShortMap newImmutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashLongShortMap newImmutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4, Map<Long, Short> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashLongShortMap newImmutableMap(
            Map<Long, Short> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashLongShortMap newImmutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashLongShortMap newImmutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashLongShortMap newImmutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashLongShortMap newImmutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4, Map<Long, Short> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashLongShortMap newImmutableMap(
            net.openhft.function.Consumer<LongShortConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashLongShortMap newImmutableMap(
            net.openhft.function.Consumer<LongShortConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashLongShortMap newImmutableMap(
            long[] keys, short[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashLongShortMap newImmutableMap(
            long[] keys, short[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashLongShortMap newImmutableMap(
            Long[] keys, Short[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashLongShortMap newImmutableMap(
            Long[] keys, Short[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashLongShortMap newImmutableMap(Iterable<Long> keys,
            Iterable<Short> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashLongShortMap newImmutableMap(Iterable<Long> keys,
            Iterable<Short> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashLongShortMap newImmutableMapOf(
            long k1, short v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashLongShortMap newImmutableMapOf(
            long k1, short v1, long k2, short v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashLongShortMap newImmutableMapOf(
            long k1, short v1, long k2, short v2,
            long k3, short v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashLongShortMap newImmutableMapOf(
            long k1, short v1, long k2, short v2,
            long k3, short v3, long k4, short v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashLongShortMap newImmutableMapOf(
            long k1, short v1, long k2, short v2,
            long k3, short v3, long k4, short v4,
            long k5, short v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashLongShortMaps() {}
}

