/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.LongShortConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashLongShortMaps}
 *
 * @see HashLongShortMap
 * @see HashLongShortMaps#getDefaultFactory()
 */
public interface HashLongShortMapFactory extends LongShortMapFactory
        , LongHashFactory<HashLongShortMapFactory>
         {

    

    

    

    

    

    
    

    
    


    @Override
    HashLongShortMapFactory withDefaultValue(short defaultValue);

    @Override
     HashLongShortMap newMutableMap();

    @Override
     HashLongShortMap newMutableMap(int expectedSize);

    


    @Override
     HashLongShortMap newMutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, int expectedSize);

    @Override
     HashLongShortMap newMutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3, int expectedSize);

    @Override
     HashLongShortMap newMutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4, int expectedSize);

    @Override
     HashLongShortMap newMutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4, Map<Long, Short> map5, int expectedSize);

    

    
    @Override
     HashLongShortMap newMutableMap(Map<Long, Short> map);

    @Override
     HashLongShortMap newMutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2);

    @Override
     HashLongShortMap newMutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3);

    @Override
     HashLongShortMap newMutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4);

    @Override
     HashLongShortMap newMutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4, Map<Long, Short> map5);


    @Override
     HashLongShortMap newMutableMap(
            net.openhft.function.Consumer<LongShortConsumer> entriesSupplier);

    @Override
     HashLongShortMap newMutableMap(
            net.openhft.function.Consumer<LongShortConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashLongShortMap newMutableMap(long[] keys, short[] values);

    @Override
     HashLongShortMap newMutableMap(long[] keys, short[] values,
            int expectedSize);

    @Override
     HashLongShortMap newMutableMap(
            Long[] keys, Short[] values);

    @Override
     HashLongShortMap newMutableMap(
            Long[] keys, Short[] values, int expectedSize);

    @Override
     HashLongShortMap newMutableMap(Iterable<Long> keys,
            Iterable<Short> values);

    @Override
     HashLongShortMap newMutableMap(Iterable<Long> keys,
            Iterable<Short> values, int expectedSize);


    @Override
     HashLongShortMap newMutableMapOf(long k1, short v1);

    @Override
     HashLongShortMap newMutableMapOf(long k1, short v1,
            long k2, short v2);

    @Override
     HashLongShortMap newMutableMapOf(long k1, short v1,
            long k2, short v2, long k3, short v3);

    @Override
     HashLongShortMap newMutableMapOf(long k1, short v1,
            long k2, short v2, long k3, short v3,
            long k4, short v4);

    @Override
     HashLongShortMap newMutableMapOf(long k1, short v1,
            long k2, short v2, long k3, short v3,
            long k4, short v4, long k5, short v5);
    @Override
     HashLongShortMap newUpdatableMap();

    @Override
     HashLongShortMap newUpdatableMap(int expectedSize);

    


    @Override
     HashLongShortMap newUpdatableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, int expectedSize);

    @Override
     HashLongShortMap newUpdatableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3, int expectedSize);

    @Override
     HashLongShortMap newUpdatableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4, int expectedSize);

    @Override
     HashLongShortMap newUpdatableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4, Map<Long, Short> map5, int expectedSize);

    

    
    @Override
     HashLongShortMap newUpdatableMap(Map<Long, Short> map);

    @Override
     HashLongShortMap newUpdatableMap(Map<Long, Short> map1,
            Map<Long, Short> map2);

    @Override
     HashLongShortMap newUpdatableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3);

    @Override
     HashLongShortMap newUpdatableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4);

    @Override
     HashLongShortMap newUpdatableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4, Map<Long, Short> map5);


    @Override
     HashLongShortMap newUpdatableMap(
            net.openhft.function.Consumer<LongShortConsumer> entriesSupplier);

    @Override
     HashLongShortMap newUpdatableMap(
            net.openhft.function.Consumer<LongShortConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashLongShortMap newUpdatableMap(long[] keys, short[] values);

    @Override
     HashLongShortMap newUpdatableMap(long[] keys, short[] values,
            int expectedSize);

    @Override
     HashLongShortMap newUpdatableMap(
            Long[] keys, Short[] values);

    @Override
     HashLongShortMap newUpdatableMap(
            Long[] keys, Short[] values, int expectedSize);

    @Override
     HashLongShortMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Short> values);

    @Override
     HashLongShortMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Short> values, int expectedSize);


    @Override
     HashLongShortMap newUpdatableMapOf(long k1, short v1);

    @Override
     HashLongShortMap newUpdatableMapOf(long k1, short v1,
            long k2, short v2);

    @Override
     HashLongShortMap newUpdatableMapOf(long k1, short v1,
            long k2, short v2, long k3, short v3);

    @Override
     HashLongShortMap newUpdatableMapOf(long k1, short v1,
            long k2, short v2, long k3, short v3,
            long k4, short v4);

    @Override
     HashLongShortMap newUpdatableMapOf(long k1, short v1,
            long k2, short v2, long k3, short v3,
            long k4, short v4, long k5, short v5);

    


    @Override
     HashLongShortMap newImmutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, int expectedSize);

    @Override
     HashLongShortMap newImmutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3, int expectedSize);

    @Override
     HashLongShortMap newImmutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4, int expectedSize);

    @Override
     HashLongShortMap newImmutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4, Map<Long, Short> map5, int expectedSize);

    

    
    @Override
     HashLongShortMap newImmutableMap(Map<Long, Short> map);

    @Override
     HashLongShortMap newImmutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2);

    @Override
     HashLongShortMap newImmutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3);

    @Override
     HashLongShortMap newImmutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4);

    @Override
     HashLongShortMap newImmutableMap(Map<Long, Short> map1,
            Map<Long, Short> map2, Map<Long, Short> map3,
            Map<Long, Short> map4, Map<Long, Short> map5);


    @Override
     HashLongShortMap newImmutableMap(
            net.openhft.function.Consumer<LongShortConsumer> entriesSupplier);

    @Override
     HashLongShortMap newImmutableMap(
            net.openhft.function.Consumer<LongShortConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashLongShortMap newImmutableMap(long[] keys, short[] values);

    @Override
     HashLongShortMap newImmutableMap(long[] keys, short[] values,
            int expectedSize);

    @Override
     HashLongShortMap newImmutableMap(
            Long[] keys, Short[] values);

    @Override
     HashLongShortMap newImmutableMap(
            Long[] keys, Short[] values, int expectedSize);

    @Override
     HashLongShortMap newImmutableMap(Iterable<Long> keys,
            Iterable<Short> values);

    @Override
     HashLongShortMap newImmutableMap(Iterable<Long> keys,
            Iterable<Short> values, int expectedSize);


    @Override
     HashLongShortMap newImmutableMapOf(long k1, short v1);

    @Override
     HashLongShortMap newImmutableMapOf(long k1, short v1,
            long k2, short v2);

    @Override
     HashLongShortMap newImmutableMapOf(long k1, short v1,
            long k2, short v2, long k3, short v3);

    @Override
     HashLongShortMap newImmutableMapOf(long k1, short v1,
            long k2, short v2, long k3, short v3,
            long k4, short v4);

    @Override
     HashLongShortMap newImmutableMapOf(long k1, short v1,
            long k2, short v2, long k3, short v3,
            long k4, short v4, long k5, short v5);
}

