/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.LongLongConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashLongLongMaps}
 *
 * @see HashLongLongMap
 * @see HashLongLongMaps#getDefaultFactory()
 */
public interface HashLongLongMapFactory extends LongLongMapFactory
        , LongHashFactory<HashLongLongMapFactory>
         {

    

    

    

    

    

    
    

    
    


    @Override
    HashLongLongMapFactory withDefaultValue(long defaultValue);

    @Override
     HashLongLongMap newMutableMap();

    @Override
     HashLongLongMap newMutableMap(int expectedSize);

    


    @Override
     HashLongLongMap newMutableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, int expectedSize);

    @Override
     HashLongLongMap newMutableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3, int expectedSize);

    @Override
     HashLongLongMap newMutableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3,
            Map<Long, Long> map4, int expectedSize);

    @Override
     HashLongLongMap newMutableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3,
            Map<Long, Long> map4, Map<Long, Long> map5, int expectedSize);

    

    
    @Override
     HashLongLongMap newMutableMap(Map<Long, Long> map);

    @Override
     HashLongLongMap newMutableMap(Map<Long, Long> map1,
            Map<Long, Long> map2);

    @Override
     HashLongLongMap newMutableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3);

    @Override
     HashLongLongMap newMutableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3,
            Map<Long, Long> map4);

    @Override
     HashLongLongMap newMutableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3,
            Map<Long, Long> map4, Map<Long, Long> map5);


    @Override
     HashLongLongMap newMutableMap(
            net.openhft.function.Consumer<LongLongConsumer> entriesSupplier);

    @Override
     HashLongLongMap newMutableMap(
            net.openhft.function.Consumer<LongLongConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashLongLongMap newMutableMap(long[] keys, long[] values);

    @Override
     HashLongLongMap newMutableMap(long[] keys, long[] values,
            int expectedSize);

    @Override
     HashLongLongMap newMutableMap(
            Long[] keys, Long[] values);

    @Override
     HashLongLongMap newMutableMap(
            Long[] keys, Long[] values, int expectedSize);

    @Override
     HashLongLongMap newMutableMap(Iterable<Long> keys,
            Iterable<Long> values);

    @Override
     HashLongLongMap newMutableMap(Iterable<Long> keys,
            Iterable<Long> values, int expectedSize);


    @Override
     HashLongLongMap newMutableMapOf(long k1, long v1);

    @Override
     HashLongLongMap newMutableMapOf(long k1, long v1,
            long k2, long v2);

    @Override
     HashLongLongMap newMutableMapOf(long k1, long v1,
            long k2, long v2, long k3, long v3);

    @Override
     HashLongLongMap newMutableMapOf(long k1, long v1,
            long k2, long v2, long k3, long v3,
            long k4, long v4);

    @Override
     HashLongLongMap newMutableMapOf(long k1, long v1,
            long k2, long v2, long k3, long v3,
            long k4, long v4, long k5, long v5);
    @Override
     HashLongLongMap newUpdatableMap();

    @Override
     HashLongLongMap newUpdatableMap(int expectedSize);

    


    @Override
     HashLongLongMap newUpdatableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, int expectedSize);

    @Override
     HashLongLongMap newUpdatableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3, int expectedSize);

    @Override
     HashLongLongMap newUpdatableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3,
            Map<Long, Long> map4, int expectedSize);

    @Override
     HashLongLongMap newUpdatableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3,
            Map<Long, Long> map4, Map<Long, Long> map5, int expectedSize);

    

    
    @Override
     HashLongLongMap newUpdatableMap(Map<Long, Long> map);

    @Override
     HashLongLongMap newUpdatableMap(Map<Long, Long> map1,
            Map<Long, Long> map2);

    @Override
     HashLongLongMap newUpdatableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3);

    @Override
     HashLongLongMap newUpdatableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3,
            Map<Long, Long> map4);

    @Override
     HashLongLongMap newUpdatableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3,
            Map<Long, Long> map4, Map<Long, Long> map5);


    @Override
     HashLongLongMap newUpdatableMap(
            net.openhft.function.Consumer<LongLongConsumer> entriesSupplier);

    @Override
     HashLongLongMap newUpdatableMap(
            net.openhft.function.Consumer<LongLongConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashLongLongMap newUpdatableMap(long[] keys, long[] values);

    @Override
     HashLongLongMap newUpdatableMap(long[] keys, long[] values,
            int expectedSize);

    @Override
     HashLongLongMap newUpdatableMap(
            Long[] keys, Long[] values);

    @Override
     HashLongLongMap newUpdatableMap(
            Long[] keys, Long[] values, int expectedSize);

    @Override
     HashLongLongMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Long> values);

    @Override
     HashLongLongMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Long> values, int expectedSize);


    @Override
     HashLongLongMap newUpdatableMapOf(long k1, long v1);

    @Override
     HashLongLongMap newUpdatableMapOf(long k1, long v1,
            long k2, long v2);

    @Override
     HashLongLongMap newUpdatableMapOf(long k1, long v1,
            long k2, long v2, long k3, long v3);

    @Override
     HashLongLongMap newUpdatableMapOf(long k1, long v1,
            long k2, long v2, long k3, long v3,
            long k4, long v4);

    @Override
     HashLongLongMap newUpdatableMapOf(long k1, long v1,
            long k2, long v2, long k3, long v3,
            long k4, long v4, long k5, long v5);

    


    @Override
     HashLongLongMap newImmutableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, int expectedSize);

    @Override
     HashLongLongMap newImmutableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3, int expectedSize);

    @Override
     HashLongLongMap newImmutableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3,
            Map<Long, Long> map4, int expectedSize);

    @Override
     HashLongLongMap newImmutableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3,
            Map<Long, Long> map4, Map<Long, Long> map5, int expectedSize);

    

    
    @Override
     HashLongLongMap newImmutableMap(Map<Long, Long> map);

    @Override
     HashLongLongMap newImmutableMap(Map<Long, Long> map1,
            Map<Long, Long> map2);

    @Override
     HashLongLongMap newImmutableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3);

    @Override
     HashLongLongMap newImmutableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3,
            Map<Long, Long> map4);

    @Override
     HashLongLongMap newImmutableMap(Map<Long, Long> map1,
            Map<Long, Long> map2, Map<Long, Long> map3,
            Map<Long, Long> map4, Map<Long, Long> map5);


    @Override
     HashLongLongMap newImmutableMap(
            net.openhft.function.Consumer<LongLongConsumer> entriesSupplier);

    @Override
     HashLongLongMap newImmutableMap(
            net.openhft.function.Consumer<LongLongConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashLongLongMap newImmutableMap(long[] keys, long[] values);

    @Override
     HashLongLongMap newImmutableMap(long[] keys, long[] values,
            int expectedSize);

    @Override
     HashLongLongMap newImmutableMap(
            Long[] keys, Long[] values);

    @Override
     HashLongLongMap newImmutableMap(
            Long[] keys, Long[] values, int expectedSize);

    @Override
     HashLongLongMap newImmutableMap(Iterable<Long> keys,
            Iterable<Long> values);

    @Override
     HashLongLongMap newImmutableMap(Iterable<Long> keys,
            Iterable<Long> values, int expectedSize);


    @Override
     HashLongLongMap newImmutableMapOf(long k1, long v1);

    @Override
     HashLongLongMap newImmutableMapOf(long k1, long v1,
            long k2, long v2);

    @Override
     HashLongLongMap newImmutableMapOf(long k1, long v1,
            long k2, long v2, long k3, long v3);

    @Override
     HashLongLongMap newImmutableMapOf(long k1, long v1,
            long k2, long v2, long k3, long v3,
            long k4, long v4);

    @Override
     HashLongLongMap newImmutableMapOf(long k1, long v1,
            long k2, long v2, long k3, long v3,
            long k4, long v4, long k5, long v5);
}

