/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.LongIntConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashLongIntMaps}
 *
 * @see HashLongIntMap
 * @see HashLongIntMaps#getDefaultFactory()
 */
public interface HashLongIntMapFactory extends LongIntMapFactory
        , LongHashFactory<HashLongIntMapFactory>
         {

    

    

    

    

    

    
    

    
    


    @Override
    HashLongIntMapFactory withDefaultValue(int defaultValue);

    @Override
     HashLongIntMap newMutableMap();

    @Override
     HashLongIntMap newMutableMap(int expectedSize);

    


    @Override
     HashLongIntMap newMutableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, int expectedSize);

    @Override
     HashLongIntMap newMutableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3, int expectedSize);

    @Override
     HashLongIntMap newMutableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3,
            Map<Long, Integer> map4, int expectedSize);

    @Override
     HashLongIntMap newMutableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3,
            Map<Long, Integer> map4, Map<Long, Integer> map5, int expectedSize);

    

    
    @Override
     HashLongIntMap newMutableMap(Map<Long, Integer> map);

    @Override
     HashLongIntMap newMutableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2);

    @Override
     HashLongIntMap newMutableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3);

    @Override
     HashLongIntMap newMutableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3,
            Map<Long, Integer> map4);

    @Override
     HashLongIntMap newMutableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3,
            Map<Long, Integer> map4, Map<Long, Integer> map5);


    @Override
     HashLongIntMap newMutableMap(
            net.openhft.function.Consumer<LongIntConsumer> entriesSupplier);

    @Override
     HashLongIntMap newMutableMap(
            net.openhft.function.Consumer<LongIntConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashLongIntMap newMutableMap(long[] keys, int[] values);

    @Override
     HashLongIntMap newMutableMap(long[] keys, int[] values,
            int expectedSize);

    @Override
     HashLongIntMap newMutableMap(
            Long[] keys, Integer[] values);

    @Override
     HashLongIntMap newMutableMap(
            Long[] keys, Integer[] values, int expectedSize);

    @Override
     HashLongIntMap newMutableMap(Iterable<Long> keys,
            Iterable<Integer> values);

    @Override
     HashLongIntMap newMutableMap(Iterable<Long> keys,
            Iterable<Integer> values, int expectedSize);


    @Override
     HashLongIntMap newMutableMapOf(long k1, int v1);

    @Override
     HashLongIntMap newMutableMapOf(long k1, int v1,
            long k2, int v2);

    @Override
     HashLongIntMap newMutableMapOf(long k1, int v1,
            long k2, int v2, long k3, int v3);

    @Override
     HashLongIntMap newMutableMapOf(long k1, int v1,
            long k2, int v2, long k3, int v3,
            long k4, int v4);

    @Override
     HashLongIntMap newMutableMapOf(long k1, int v1,
            long k2, int v2, long k3, int v3,
            long k4, int v4, long k5, int v5);
    @Override
     HashLongIntMap newUpdatableMap();

    @Override
     HashLongIntMap newUpdatableMap(int expectedSize);

    


    @Override
     HashLongIntMap newUpdatableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, int expectedSize);

    @Override
     HashLongIntMap newUpdatableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3, int expectedSize);

    @Override
     HashLongIntMap newUpdatableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3,
            Map<Long, Integer> map4, int expectedSize);

    @Override
     HashLongIntMap newUpdatableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3,
            Map<Long, Integer> map4, Map<Long, Integer> map5, int expectedSize);

    

    
    @Override
     HashLongIntMap newUpdatableMap(Map<Long, Integer> map);

    @Override
     HashLongIntMap newUpdatableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2);

    @Override
     HashLongIntMap newUpdatableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3);

    @Override
     HashLongIntMap newUpdatableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3,
            Map<Long, Integer> map4);

    @Override
     HashLongIntMap newUpdatableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3,
            Map<Long, Integer> map4, Map<Long, Integer> map5);


    @Override
     HashLongIntMap newUpdatableMap(
            net.openhft.function.Consumer<LongIntConsumer> entriesSupplier);

    @Override
     HashLongIntMap newUpdatableMap(
            net.openhft.function.Consumer<LongIntConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashLongIntMap newUpdatableMap(long[] keys, int[] values);

    @Override
     HashLongIntMap newUpdatableMap(long[] keys, int[] values,
            int expectedSize);

    @Override
     HashLongIntMap newUpdatableMap(
            Long[] keys, Integer[] values);

    @Override
     HashLongIntMap newUpdatableMap(
            Long[] keys, Integer[] values, int expectedSize);

    @Override
     HashLongIntMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Integer> values);

    @Override
     HashLongIntMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Integer> values, int expectedSize);


    @Override
     HashLongIntMap newUpdatableMapOf(long k1, int v1);

    @Override
     HashLongIntMap newUpdatableMapOf(long k1, int v1,
            long k2, int v2);

    @Override
     HashLongIntMap newUpdatableMapOf(long k1, int v1,
            long k2, int v2, long k3, int v3);

    @Override
     HashLongIntMap newUpdatableMapOf(long k1, int v1,
            long k2, int v2, long k3, int v3,
            long k4, int v4);

    @Override
     HashLongIntMap newUpdatableMapOf(long k1, int v1,
            long k2, int v2, long k3, int v3,
            long k4, int v4, long k5, int v5);

    


    @Override
     HashLongIntMap newImmutableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, int expectedSize);

    @Override
     HashLongIntMap newImmutableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3, int expectedSize);

    @Override
     HashLongIntMap newImmutableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3,
            Map<Long, Integer> map4, int expectedSize);

    @Override
     HashLongIntMap newImmutableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3,
            Map<Long, Integer> map4, Map<Long, Integer> map5, int expectedSize);

    

    
    @Override
     HashLongIntMap newImmutableMap(Map<Long, Integer> map);

    @Override
     HashLongIntMap newImmutableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2);

    @Override
     HashLongIntMap newImmutableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3);

    @Override
     HashLongIntMap newImmutableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3,
            Map<Long, Integer> map4);

    @Override
     HashLongIntMap newImmutableMap(Map<Long, Integer> map1,
            Map<Long, Integer> map2, Map<Long, Integer> map3,
            Map<Long, Integer> map4, Map<Long, Integer> map5);


    @Override
     HashLongIntMap newImmutableMap(
            net.openhft.function.Consumer<LongIntConsumer> entriesSupplier);

    @Override
     HashLongIntMap newImmutableMap(
            net.openhft.function.Consumer<LongIntConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashLongIntMap newImmutableMap(long[] keys, int[] values);

    @Override
     HashLongIntMap newImmutableMap(long[] keys, int[] values,
            int expectedSize);

    @Override
     HashLongIntMap newImmutableMap(
            Long[] keys, Integer[] values);

    @Override
     HashLongIntMap newImmutableMap(
            Long[] keys, Integer[] values, int expectedSize);

    @Override
     HashLongIntMap newImmutableMap(Iterable<Long> keys,
            Iterable<Integer> values);

    @Override
     HashLongIntMap newImmutableMap(Iterable<Long> keys,
            Iterable<Integer> values, int expectedSize);


    @Override
     HashLongIntMap newImmutableMapOf(long k1, int v1);

    @Override
     HashLongIntMap newImmutableMapOf(long k1, int v1,
            long k2, int v2);

    @Override
     HashLongIntMap newImmutableMapOf(long k1, int v1,
            long k2, int v2, long k3, int v3);

    @Override
     HashLongIntMap newImmutableMapOf(long k1, int v1,
            long k2, int v2, long k3, int v3,
            long k4, int v4);

    @Override
     HashLongIntMap newImmutableMapOf(long k1, int v1,
            long k2, int v2, long k3, int v3,
            long k4, int v4, long k5, int v5);
}

