/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.LongFloatConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashLongFloatMap}s, and
 * the default {@link HashLongFloatMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashLongFloatMap
 */
public final class HashLongFloatMaps {

    

    private static final ServiceLoader<HashLongFloatMapFactory> LOADER =
            ServiceLoader.load(HashLongFloatMapFactory.class);
    private static HashLongFloatMapFactory defaultFactory = null;

    public static HashLongFloatMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashLongFloatMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashLongFloatMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashLongFloatMap newMutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashLongFloatMap newMutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashLongFloatMap newMutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashLongFloatMap newMutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4, Map<Long, Float> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashLongFloatMap newMutableMap(
            Map<Long, Float> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashLongFloatMap newMutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashLongFloatMap newMutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashLongFloatMap newMutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashLongFloatMap newMutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4, Map<Long, Float> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashLongFloatMap newMutableMap(
            net.openhft.function.Consumer<LongFloatConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashLongFloatMap newMutableMap(
            net.openhft.function.Consumer<LongFloatConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashLongFloatMap newMutableMap(
            long[] keys, float[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashLongFloatMap newMutableMap(
            long[] keys, float[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashLongFloatMap newMutableMap(
            Long[] keys, Float[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashLongFloatMap newMutableMap(
            Long[] keys, Float[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashLongFloatMap newMutableMap(Iterable<Long> keys,
            Iterable<Float> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashLongFloatMap newMutableMap(Iterable<Long> keys,
            Iterable<Float> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashLongFloatMap newMutableMapOf(
            long k1, float v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashLongFloatMap newMutableMapOf(
            long k1, float v1, long k2, float v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashLongFloatMap newMutableMapOf(
            long k1, float v1, long k2, float v2,
            long k3, float v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashLongFloatMap newMutableMapOf(
            long k1, float v1, long k2, float v2,
            long k3, float v3, long k4, float v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashLongFloatMap newMutableMapOf(
            long k1, float v1, long k2, float v2,
            long k3, float v3, long k4, float v4,
            long k5, float v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashLongFloatMap newUpdatableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashLongFloatMap newUpdatableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashLongFloatMap newUpdatableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashLongFloatMap newUpdatableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4, Map<Long, Float> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashLongFloatMap newUpdatableMap(
            Map<Long, Float> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashLongFloatMap newUpdatableMap(Map<Long, Float> map1,
            Map<Long, Float> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashLongFloatMap newUpdatableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashLongFloatMap newUpdatableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashLongFloatMap newUpdatableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4, Map<Long, Float> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashLongFloatMap newUpdatableMap(
            net.openhft.function.Consumer<LongFloatConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashLongFloatMap newUpdatableMap(
            net.openhft.function.Consumer<LongFloatConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashLongFloatMap newUpdatableMap(
            long[] keys, float[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashLongFloatMap newUpdatableMap(
            long[] keys, float[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashLongFloatMap newUpdatableMap(
            Long[] keys, Float[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashLongFloatMap newUpdatableMap(
            Long[] keys, Float[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashLongFloatMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Float> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashLongFloatMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Float> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashLongFloatMap newUpdatableMapOf(
            long k1, float v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashLongFloatMap newUpdatableMapOf(
            long k1, float v1, long k2, float v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashLongFloatMap newUpdatableMapOf(
            long k1, float v1, long k2, float v2,
            long k3, float v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashLongFloatMap newUpdatableMapOf(
            long k1, float v1, long k2, float v2,
            long k3, float v3, long k4, float v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashLongFloatMap newUpdatableMapOf(
            long k1, float v1, long k2, float v2,
            long k3, float v3, long k4, float v4,
            long k5, float v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashLongFloatMap newImmutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashLongFloatMap newImmutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashLongFloatMap newImmutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashLongFloatMap newImmutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4, Map<Long, Float> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashLongFloatMap newImmutableMap(
            Map<Long, Float> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashLongFloatMap newImmutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashLongFloatMap newImmutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashLongFloatMap newImmutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashLongFloatMap newImmutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4, Map<Long, Float> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashLongFloatMap newImmutableMap(
            net.openhft.function.Consumer<LongFloatConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashLongFloatMap newImmutableMap(
            net.openhft.function.Consumer<LongFloatConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashLongFloatMap newImmutableMap(
            long[] keys, float[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashLongFloatMap newImmutableMap(
            long[] keys, float[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashLongFloatMap newImmutableMap(
            Long[] keys, Float[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashLongFloatMap newImmutableMap(
            Long[] keys, Float[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashLongFloatMap newImmutableMap(Iterable<Long> keys,
            Iterable<Float> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashLongFloatMap newImmutableMap(Iterable<Long> keys,
            Iterable<Float> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashLongFloatMap newImmutableMapOf(
            long k1, float v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashLongFloatMap newImmutableMapOf(
            long k1, float v1, long k2, float v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashLongFloatMap newImmutableMapOf(
            long k1, float v1, long k2, float v2,
            long k3, float v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashLongFloatMap newImmutableMapOf(
            long k1, float v1, long k2, float v2,
            long k3, float v3, long k4, float v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashLongFloatMap newImmutableMapOf(
            long k1, float v1, long k2, float v2,
            long k3, float v3, long k4, float v4,
            long k5, float v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashLongFloatMaps() {}
}

