/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.LongFloatConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashLongFloatMaps}
 *
 * @see HashLongFloatMap
 * @see HashLongFloatMaps#getDefaultFactory()
 */
public interface HashLongFloatMapFactory extends LongFloatMapFactory
        , LongHashFactory<HashLongFloatMapFactory>
         {

    

    

    

    

    

    
    

    
    


    @Override
    HashLongFloatMapFactory withDefaultValue(float defaultValue);

    @Override
     HashLongFloatMap newMutableMap();

    @Override
     HashLongFloatMap newMutableMap(int expectedSize);

    


    @Override
     HashLongFloatMap newMutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, int expectedSize);

    @Override
     HashLongFloatMap newMutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3, int expectedSize);

    @Override
     HashLongFloatMap newMutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4, int expectedSize);

    @Override
     HashLongFloatMap newMutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4, Map<Long, Float> map5, int expectedSize);

    

    
    @Override
     HashLongFloatMap newMutableMap(Map<Long, Float> map);

    @Override
     HashLongFloatMap newMutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2);

    @Override
     HashLongFloatMap newMutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3);

    @Override
     HashLongFloatMap newMutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4);

    @Override
     HashLongFloatMap newMutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4, Map<Long, Float> map5);


    @Override
     HashLongFloatMap newMutableMap(
            net.openhft.function.Consumer<LongFloatConsumer> entriesSupplier);

    @Override
     HashLongFloatMap newMutableMap(
            net.openhft.function.Consumer<LongFloatConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashLongFloatMap newMutableMap(long[] keys, float[] values);

    @Override
     HashLongFloatMap newMutableMap(long[] keys, float[] values,
            int expectedSize);

    @Override
     HashLongFloatMap newMutableMap(
            Long[] keys, Float[] values);

    @Override
     HashLongFloatMap newMutableMap(
            Long[] keys, Float[] values, int expectedSize);

    @Override
     HashLongFloatMap newMutableMap(Iterable<Long> keys,
            Iterable<Float> values);

    @Override
     HashLongFloatMap newMutableMap(Iterable<Long> keys,
            Iterable<Float> values, int expectedSize);


    @Override
     HashLongFloatMap newMutableMapOf(long k1, float v1);

    @Override
     HashLongFloatMap newMutableMapOf(long k1, float v1,
            long k2, float v2);

    @Override
     HashLongFloatMap newMutableMapOf(long k1, float v1,
            long k2, float v2, long k3, float v3);

    @Override
     HashLongFloatMap newMutableMapOf(long k1, float v1,
            long k2, float v2, long k3, float v3,
            long k4, float v4);

    @Override
     HashLongFloatMap newMutableMapOf(long k1, float v1,
            long k2, float v2, long k3, float v3,
            long k4, float v4, long k5, float v5);
    @Override
     HashLongFloatMap newUpdatableMap();

    @Override
     HashLongFloatMap newUpdatableMap(int expectedSize);

    


    @Override
     HashLongFloatMap newUpdatableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, int expectedSize);

    @Override
     HashLongFloatMap newUpdatableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3, int expectedSize);

    @Override
     HashLongFloatMap newUpdatableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4, int expectedSize);

    @Override
     HashLongFloatMap newUpdatableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4, Map<Long, Float> map5, int expectedSize);

    

    
    @Override
     HashLongFloatMap newUpdatableMap(Map<Long, Float> map);

    @Override
     HashLongFloatMap newUpdatableMap(Map<Long, Float> map1,
            Map<Long, Float> map2);

    @Override
     HashLongFloatMap newUpdatableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3);

    @Override
     HashLongFloatMap newUpdatableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4);

    @Override
     HashLongFloatMap newUpdatableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4, Map<Long, Float> map5);


    @Override
     HashLongFloatMap newUpdatableMap(
            net.openhft.function.Consumer<LongFloatConsumer> entriesSupplier);

    @Override
     HashLongFloatMap newUpdatableMap(
            net.openhft.function.Consumer<LongFloatConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashLongFloatMap newUpdatableMap(long[] keys, float[] values);

    @Override
     HashLongFloatMap newUpdatableMap(long[] keys, float[] values,
            int expectedSize);

    @Override
     HashLongFloatMap newUpdatableMap(
            Long[] keys, Float[] values);

    @Override
     HashLongFloatMap newUpdatableMap(
            Long[] keys, Float[] values, int expectedSize);

    @Override
     HashLongFloatMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Float> values);

    @Override
     HashLongFloatMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Float> values, int expectedSize);


    @Override
     HashLongFloatMap newUpdatableMapOf(long k1, float v1);

    @Override
     HashLongFloatMap newUpdatableMapOf(long k1, float v1,
            long k2, float v2);

    @Override
     HashLongFloatMap newUpdatableMapOf(long k1, float v1,
            long k2, float v2, long k3, float v3);

    @Override
     HashLongFloatMap newUpdatableMapOf(long k1, float v1,
            long k2, float v2, long k3, float v3,
            long k4, float v4);

    @Override
     HashLongFloatMap newUpdatableMapOf(long k1, float v1,
            long k2, float v2, long k3, float v3,
            long k4, float v4, long k5, float v5);

    


    @Override
     HashLongFloatMap newImmutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, int expectedSize);

    @Override
     HashLongFloatMap newImmutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3, int expectedSize);

    @Override
     HashLongFloatMap newImmutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4, int expectedSize);

    @Override
     HashLongFloatMap newImmutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4, Map<Long, Float> map5, int expectedSize);

    

    
    @Override
     HashLongFloatMap newImmutableMap(Map<Long, Float> map);

    @Override
     HashLongFloatMap newImmutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2);

    @Override
     HashLongFloatMap newImmutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3);

    @Override
     HashLongFloatMap newImmutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4);

    @Override
     HashLongFloatMap newImmutableMap(Map<Long, Float> map1,
            Map<Long, Float> map2, Map<Long, Float> map3,
            Map<Long, Float> map4, Map<Long, Float> map5);


    @Override
     HashLongFloatMap newImmutableMap(
            net.openhft.function.Consumer<LongFloatConsumer> entriesSupplier);

    @Override
     HashLongFloatMap newImmutableMap(
            net.openhft.function.Consumer<LongFloatConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashLongFloatMap newImmutableMap(long[] keys, float[] values);

    @Override
     HashLongFloatMap newImmutableMap(long[] keys, float[] values,
            int expectedSize);

    @Override
     HashLongFloatMap newImmutableMap(
            Long[] keys, Float[] values);

    @Override
     HashLongFloatMap newImmutableMap(
            Long[] keys, Float[] values, int expectedSize);

    @Override
     HashLongFloatMap newImmutableMap(Iterable<Long> keys,
            Iterable<Float> values);

    @Override
     HashLongFloatMap newImmutableMap(Iterable<Long> keys,
            Iterable<Float> values, int expectedSize);


    @Override
     HashLongFloatMap newImmutableMapOf(long k1, float v1);

    @Override
     HashLongFloatMap newImmutableMapOf(long k1, float v1,
            long k2, float v2);

    @Override
     HashLongFloatMap newImmutableMapOf(long k1, float v1,
            long k2, float v2, long k3, float v3);

    @Override
     HashLongFloatMap newImmutableMapOf(long k1, float v1,
            long k2, float v2, long k3, float v3,
            long k4, float v4);

    @Override
     HashLongFloatMap newImmutableMapOf(long k1, float v1,
            long k2, float v2, long k3, float v3,
            long k4, float v4, long k5, float v5);
}

