/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.LongDoubleConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashLongDoubleMap}s, and
 * the default {@link HashLongDoubleMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashLongDoubleMap
 */
public final class HashLongDoubleMaps {

    

    private static final ServiceLoader<HashLongDoubleMapFactory> LOADER =
            ServiceLoader.load(HashLongDoubleMapFactory.class);
    private static HashLongDoubleMapFactory defaultFactory = null;

    public static HashLongDoubleMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashLongDoubleMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashLongDoubleMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashLongDoubleMap newMutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashLongDoubleMap newMutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashLongDoubleMap newMutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashLongDoubleMap newMutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4, Map<Long, Double> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashLongDoubleMap newMutableMap(
            Map<Long, Double> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashLongDoubleMap newMutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashLongDoubleMap newMutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashLongDoubleMap newMutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashLongDoubleMap newMutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4, Map<Long, Double> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashLongDoubleMap newMutableMap(
            net.openhft.function.Consumer<LongDoubleConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashLongDoubleMap newMutableMap(
            net.openhft.function.Consumer<LongDoubleConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashLongDoubleMap newMutableMap(
            long[] keys, double[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashLongDoubleMap newMutableMap(
            long[] keys, double[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashLongDoubleMap newMutableMap(
            Long[] keys, Double[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashLongDoubleMap newMutableMap(
            Long[] keys, Double[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashLongDoubleMap newMutableMap(Iterable<Long> keys,
            Iterable<Double> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashLongDoubleMap newMutableMap(Iterable<Long> keys,
            Iterable<Double> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashLongDoubleMap newMutableMapOf(
            long k1, double v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashLongDoubleMap newMutableMapOf(
            long k1, double v1, long k2, double v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashLongDoubleMap newMutableMapOf(
            long k1, double v1, long k2, double v2,
            long k3, double v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashLongDoubleMap newMutableMapOf(
            long k1, double v1, long k2, double v2,
            long k3, double v3, long k4, double v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashLongDoubleMap newMutableMapOf(
            long k1, double v1, long k2, double v2,
            long k3, double v3, long k4, double v4,
            long k5, double v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashLongDoubleMap newUpdatableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashLongDoubleMap newUpdatableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashLongDoubleMap newUpdatableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashLongDoubleMap newUpdatableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4, Map<Long, Double> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashLongDoubleMap newUpdatableMap(
            Map<Long, Double> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashLongDoubleMap newUpdatableMap(Map<Long, Double> map1,
            Map<Long, Double> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashLongDoubleMap newUpdatableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashLongDoubleMap newUpdatableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashLongDoubleMap newUpdatableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4, Map<Long, Double> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashLongDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<LongDoubleConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashLongDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<LongDoubleConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashLongDoubleMap newUpdatableMap(
            long[] keys, double[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashLongDoubleMap newUpdatableMap(
            long[] keys, double[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashLongDoubleMap newUpdatableMap(
            Long[] keys, Double[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashLongDoubleMap newUpdatableMap(
            Long[] keys, Double[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashLongDoubleMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Double> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashLongDoubleMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Double> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashLongDoubleMap newUpdatableMapOf(
            long k1, double v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashLongDoubleMap newUpdatableMapOf(
            long k1, double v1, long k2, double v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashLongDoubleMap newUpdatableMapOf(
            long k1, double v1, long k2, double v2,
            long k3, double v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashLongDoubleMap newUpdatableMapOf(
            long k1, double v1, long k2, double v2,
            long k3, double v3, long k4, double v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashLongDoubleMap newUpdatableMapOf(
            long k1, double v1, long k2, double v2,
            long k3, double v3, long k4, double v4,
            long k5, double v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashLongDoubleMap newImmutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashLongDoubleMap newImmutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashLongDoubleMap newImmutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashLongDoubleMap newImmutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4, Map<Long, Double> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashLongDoubleMap newImmutableMap(
            Map<Long, Double> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashLongDoubleMap newImmutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashLongDoubleMap newImmutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashLongDoubleMap newImmutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashLongDoubleMap newImmutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4, Map<Long, Double> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashLongDoubleMap newImmutableMap(
            net.openhft.function.Consumer<LongDoubleConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashLongDoubleMap newImmutableMap(
            net.openhft.function.Consumer<LongDoubleConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashLongDoubleMap newImmutableMap(
            long[] keys, double[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashLongDoubleMap newImmutableMap(
            long[] keys, double[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashLongDoubleMap newImmutableMap(
            Long[] keys, Double[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashLongDoubleMap newImmutableMap(
            Long[] keys, Double[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashLongDoubleMap newImmutableMap(Iterable<Long> keys,
            Iterable<Double> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashLongDoubleMap newImmutableMap(Iterable<Long> keys,
            Iterable<Double> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashLongDoubleMap newImmutableMapOf(
            long k1, double v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashLongDoubleMap newImmutableMapOf(
            long k1, double v1, long k2, double v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashLongDoubleMap newImmutableMapOf(
            long k1, double v1, long k2, double v2,
            long k3, double v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashLongDoubleMap newImmutableMapOf(
            long k1, double v1, long k2, double v2,
            long k3, double v3, long k4, double v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashLongDoubleMap newImmutableMapOf(
            long k1, double v1, long k2, double v2,
            long k3, double v3, long k4, double v4,
            long k5, double v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashLongDoubleMaps() {}
}

