/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.LongDoubleConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashLongDoubleMaps}
 *
 * @see HashLongDoubleMap
 * @see HashLongDoubleMaps#getDefaultFactory()
 */
public interface HashLongDoubleMapFactory extends LongDoubleMapFactory
        , LongHashFactory<HashLongDoubleMapFactory>
         {

    

    

    

    

    

    
    

    
    


    @Override
    HashLongDoubleMapFactory withDefaultValue(double defaultValue);

    @Override
     HashLongDoubleMap newMutableMap();

    @Override
     HashLongDoubleMap newMutableMap(int expectedSize);

    


    @Override
     HashLongDoubleMap newMutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, int expectedSize);

    @Override
     HashLongDoubleMap newMutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3, int expectedSize);

    @Override
     HashLongDoubleMap newMutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4, int expectedSize);

    @Override
     HashLongDoubleMap newMutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4, Map<Long, Double> map5, int expectedSize);

    

    
    @Override
     HashLongDoubleMap newMutableMap(Map<Long, Double> map);

    @Override
     HashLongDoubleMap newMutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2);

    @Override
     HashLongDoubleMap newMutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3);

    @Override
     HashLongDoubleMap newMutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4);

    @Override
     HashLongDoubleMap newMutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4, Map<Long, Double> map5);


    @Override
     HashLongDoubleMap newMutableMap(
            net.openhft.function.Consumer<LongDoubleConsumer> entriesSupplier);

    @Override
     HashLongDoubleMap newMutableMap(
            net.openhft.function.Consumer<LongDoubleConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashLongDoubleMap newMutableMap(long[] keys, double[] values);

    @Override
     HashLongDoubleMap newMutableMap(long[] keys, double[] values,
            int expectedSize);

    @Override
     HashLongDoubleMap newMutableMap(
            Long[] keys, Double[] values);

    @Override
     HashLongDoubleMap newMutableMap(
            Long[] keys, Double[] values, int expectedSize);

    @Override
     HashLongDoubleMap newMutableMap(Iterable<Long> keys,
            Iterable<Double> values);

    @Override
     HashLongDoubleMap newMutableMap(Iterable<Long> keys,
            Iterable<Double> values, int expectedSize);


    @Override
     HashLongDoubleMap newMutableMapOf(long k1, double v1);

    @Override
     HashLongDoubleMap newMutableMapOf(long k1, double v1,
            long k2, double v2);

    @Override
     HashLongDoubleMap newMutableMapOf(long k1, double v1,
            long k2, double v2, long k3, double v3);

    @Override
     HashLongDoubleMap newMutableMapOf(long k1, double v1,
            long k2, double v2, long k3, double v3,
            long k4, double v4);

    @Override
     HashLongDoubleMap newMutableMapOf(long k1, double v1,
            long k2, double v2, long k3, double v3,
            long k4, double v4, long k5, double v5);
    @Override
     HashLongDoubleMap newUpdatableMap();

    @Override
     HashLongDoubleMap newUpdatableMap(int expectedSize);

    


    @Override
     HashLongDoubleMap newUpdatableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, int expectedSize);

    @Override
     HashLongDoubleMap newUpdatableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3, int expectedSize);

    @Override
     HashLongDoubleMap newUpdatableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4, int expectedSize);

    @Override
     HashLongDoubleMap newUpdatableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4, Map<Long, Double> map5, int expectedSize);

    

    
    @Override
     HashLongDoubleMap newUpdatableMap(Map<Long, Double> map);

    @Override
     HashLongDoubleMap newUpdatableMap(Map<Long, Double> map1,
            Map<Long, Double> map2);

    @Override
     HashLongDoubleMap newUpdatableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3);

    @Override
     HashLongDoubleMap newUpdatableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4);

    @Override
     HashLongDoubleMap newUpdatableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4, Map<Long, Double> map5);


    @Override
     HashLongDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<LongDoubleConsumer> entriesSupplier);

    @Override
     HashLongDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<LongDoubleConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashLongDoubleMap newUpdatableMap(long[] keys, double[] values);

    @Override
     HashLongDoubleMap newUpdatableMap(long[] keys, double[] values,
            int expectedSize);

    @Override
     HashLongDoubleMap newUpdatableMap(
            Long[] keys, Double[] values);

    @Override
     HashLongDoubleMap newUpdatableMap(
            Long[] keys, Double[] values, int expectedSize);

    @Override
     HashLongDoubleMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Double> values);

    @Override
     HashLongDoubleMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Double> values, int expectedSize);


    @Override
     HashLongDoubleMap newUpdatableMapOf(long k1, double v1);

    @Override
     HashLongDoubleMap newUpdatableMapOf(long k1, double v1,
            long k2, double v2);

    @Override
     HashLongDoubleMap newUpdatableMapOf(long k1, double v1,
            long k2, double v2, long k3, double v3);

    @Override
     HashLongDoubleMap newUpdatableMapOf(long k1, double v1,
            long k2, double v2, long k3, double v3,
            long k4, double v4);

    @Override
     HashLongDoubleMap newUpdatableMapOf(long k1, double v1,
            long k2, double v2, long k3, double v3,
            long k4, double v4, long k5, double v5);

    


    @Override
     HashLongDoubleMap newImmutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, int expectedSize);

    @Override
     HashLongDoubleMap newImmutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3, int expectedSize);

    @Override
     HashLongDoubleMap newImmutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4, int expectedSize);

    @Override
     HashLongDoubleMap newImmutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4, Map<Long, Double> map5, int expectedSize);

    

    
    @Override
     HashLongDoubleMap newImmutableMap(Map<Long, Double> map);

    @Override
     HashLongDoubleMap newImmutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2);

    @Override
     HashLongDoubleMap newImmutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3);

    @Override
     HashLongDoubleMap newImmutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4);

    @Override
     HashLongDoubleMap newImmutableMap(Map<Long, Double> map1,
            Map<Long, Double> map2, Map<Long, Double> map3,
            Map<Long, Double> map4, Map<Long, Double> map5);


    @Override
     HashLongDoubleMap newImmutableMap(
            net.openhft.function.Consumer<LongDoubleConsumer> entriesSupplier);

    @Override
     HashLongDoubleMap newImmutableMap(
            net.openhft.function.Consumer<LongDoubleConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashLongDoubleMap newImmutableMap(long[] keys, double[] values);

    @Override
     HashLongDoubleMap newImmutableMap(long[] keys, double[] values,
            int expectedSize);

    @Override
     HashLongDoubleMap newImmutableMap(
            Long[] keys, Double[] values);

    @Override
     HashLongDoubleMap newImmutableMap(
            Long[] keys, Double[] values, int expectedSize);

    @Override
     HashLongDoubleMap newImmutableMap(Iterable<Long> keys,
            Iterable<Double> values);

    @Override
     HashLongDoubleMap newImmutableMap(Iterable<Long> keys,
            Iterable<Double> values, int expectedSize);


    @Override
     HashLongDoubleMap newImmutableMapOf(long k1, double v1);

    @Override
     HashLongDoubleMap newImmutableMapOf(long k1, double v1,
            long k2, double v2);

    @Override
     HashLongDoubleMap newImmutableMapOf(long k1, double v1,
            long k2, double v2, long k3, double v3);

    @Override
     HashLongDoubleMap newImmutableMapOf(long k1, double v1,
            long k2, double v2, long k3, double v3,
            long k4, double v4);

    @Override
     HashLongDoubleMap newImmutableMapOf(long k1, double v1,
            long k2, double v2, long k3, double v3,
            long k4, double v4, long k5, double v5);
}

