/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.LongCharConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashLongCharMap}s, and
 * the default {@link HashLongCharMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashLongCharMap
 */
public final class HashLongCharMaps {

    

    private static final ServiceLoader<HashLongCharMapFactory> LOADER =
            ServiceLoader.load(HashLongCharMapFactory.class);
    private static HashLongCharMapFactory defaultFactory = null;

    public static HashLongCharMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashLongCharMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashLongCharMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashLongCharMap newMutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashLongCharMap newMutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashLongCharMap newMutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashLongCharMap newMutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4, Map<Long, Character> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashLongCharMap newMutableMap(
            Map<Long, Character> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashLongCharMap newMutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashLongCharMap newMutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashLongCharMap newMutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashLongCharMap newMutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4, Map<Long, Character> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashLongCharMap newMutableMap(
            net.openhft.function.Consumer<LongCharConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashLongCharMap newMutableMap(
            net.openhft.function.Consumer<LongCharConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashLongCharMap newMutableMap(
            long[] keys, char[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashLongCharMap newMutableMap(
            long[] keys, char[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashLongCharMap newMutableMap(
            Long[] keys, Character[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashLongCharMap newMutableMap(
            Long[] keys, Character[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashLongCharMap newMutableMap(Iterable<Long> keys,
            Iterable<Character> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashLongCharMap newMutableMap(Iterable<Long> keys,
            Iterable<Character> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashLongCharMap newMutableMapOf(
            long k1, char v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashLongCharMap newMutableMapOf(
            long k1, char v1, long k2, char v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashLongCharMap newMutableMapOf(
            long k1, char v1, long k2, char v2,
            long k3, char v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashLongCharMap newMutableMapOf(
            long k1, char v1, long k2, char v2,
            long k3, char v3, long k4, char v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashLongCharMap newMutableMapOf(
            long k1, char v1, long k2, char v2,
            long k3, char v3, long k4, char v4,
            long k5, char v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashLongCharMap newUpdatableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashLongCharMap newUpdatableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashLongCharMap newUpdatableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashLongCharMap newUpdatableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4, Map<Long, Character> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashLongCharMap newUpdatableMap(
            Map<Long, Character> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashLongCharMap newUpdatableMap(Map<Long, Character> map1,
            Map<Long, Character> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashLongCharMap newUpdatableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashLongCharMap newUpdatableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashLongCharMap newUpdatableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4, Map<Long, Character> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashLongCharMap newUpdatableMap(
            net.openhft.function.Consumer<LongCharConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashLongCharMap newUpdatableMap(
            net.openhft.function.Consumer<LongCharConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashLongCharMap newUpdatableMap(
            long[] keys, char[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashLongCharMap newUpdatableMap(
            long[] keys, char[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashLongCharMap newUpdatableMap(
            Long[] keys, Character[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashLongCharMap newUpdatableMap(
            Long[] keys, Character[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashLongCharMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Character> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashLongCharMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Character> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashLongCharMap newUpdatableMapOf(
            long k1, char v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashLongCharMap newUpdatableMapOf(
            long k1, char v1, long k2, char v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashLongCharMap newUpdatableMapOf(
            long k1, char v1, long k2, char v2,
            long k3, char v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashLongCharMap newUpdatableMapOf(
            long k1, char v1, long k2, char v2,
            long k3, char v3, long k4, char v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashLongCharMap newUpdatableMapOf(
            long k1, char v1, long k2, char v2,
            long k3, char v3, long k4, char v4,
            long k5, char v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashLongCharMap newImmutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashLongCharMap newImmutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashLongCharMap newImmutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashLongCharMap newImmutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4, Map<Long, Character> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashLongCharMap newImmutableMap(
            Map<Long, Character> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashLongCharMap newImmutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashLongCharMap newImmutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashLongCharMap newImmutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashLongCharMap newImmutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4, Map<Long, Character> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashLongCharMap newImmutableMap(
            net.openhft.function.Consumer<LongCharConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashLongCharMap newImmutableMap(
            net.openhft.function.Consumer<LongCharConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashLongCharMap newImmutableMap(
            long[] keys, char[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashLongCharMap newImmutableMap(
            long[] keys, char[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashLongCharMap newImmutableMap(
            Long[] keys, Character[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashLongCharMap newImmutableMap(
            Long[] keys, Character[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashLongCharMap newImmutableMap(Iterable<Long> keys,
            Iterable<Character> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashLongCharMap newImmutableMap(Iterable<Long> keys,
            Iterable<Character> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashLongCharMap newImmutableMapOf(
            long k1, char v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashLongCharMap newImmutableMapOf(
            long k1, char v1, long k2, char v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashLongCharMap newImmutableMapOf(
            long k1, char v1, long k2, char v2,
            long k3, char v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashLongCharMap newImmutableMapOf(
            long k1, char v1, long k2, char v2,
            long k3, char v3, long k4, char v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashLongCharMap newImmutableMapOf(
            long k1, char v1, long k2, char v2,
            long k3, char v3, long k4, char v4,
            long k5, char v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashLongCharMaps() {}
}

