/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.LongCharConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashLongCharMaps}
 *
 * @see HashLongCharMap
 * @see HashLongCharMaps#getDefaultFactory()
 */
public interface HashLongCharMapFactory extends LongCharMapFactory
        , LongHashFactory<HashLongCharMapFactory>
         {

    

    

    

    

    

    
    

    
    


    @Override
    HashLongCharMapFactory withDefaultValue(char defaultValue);

    @Override
     HashLongCharMap newMutableMap();

    @Override
     HashLongCharMap newMutableMap(int expectedSize);

    


    @Override
     HashLongCharMap newMutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, int expectedSize);

    @Override
     HashLongCharMap newMutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3, int expectedSize);

    @Override
     HashLongCharMap newMutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4, int expectedSize);

    @Override
     HashLongCharMap newMutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4, Map<Long, Character> map5, int expectedSize);

    

    
    @Override
     HashLongCharMap newMutableMap(Map<Long, Character> map);

    @Override
     HashLongCharMap newMutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2);

    @Override
     HashLongCharMap newMutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3);

    @Override
     HashLongCharMap newMutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4);

    @Override
     HashLongCharMap newMutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4, Map<Long, Character> map5);


    @Override
     HashLongCharMap newMutableMap(
            net.openhft.function.Consumer<LongCharConsumer> entriesSupplier);

    @Override
     HashLongCharMap newMutableMap(
            net.openhft.function.Consumer<LongCharConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashLongCharMap newMutableMap(long[] keys, char[] values);

    @Override
     HashLongCharMap newMutableMap(long[] keys, char[] values,
            int expectedSize);

    @Override
     HashLongCharMap newMutableMap(
            Long[] keys, Character[] values);

    @Override
     HashLongCharMap newMutableMap(
            Long[] keys, Character[] values, int expectedSize);

    @Override
     HashLongCharMap newMutableMap(Iterable<Long> keys,
            Iterable<Character> values);

    @Override
     HashLongCharMap newMutableMap(Iterable<Long> keys,
            Iterable<Character> values, int expectedSize);


    @Override
     HashLongCharMap newMutableMapOf(long k1, char v1);

    @Override
     HashLongCharMap newMutableMapOf(long k1, char v1,
            long k2, char v2);

    @Override
     HashLongCharMap newMutableMapOf(long k1, char v1,
            long k2, char v2, long k3, char v3);

    @Override
     HashLongCharMap newMutableMapOf(long k1, char v1,
            long k2, char v2, long k3, char v3,
            long k4, char v4);

    @Override
     HashLongCharMap newMutableMapOf(long k1, char v1,
            long k2, char v2, long k3, char v3,
            long k4, char v4, long k5, char v5);
    @Override
     HashLongCharMap newUpdatableMap();

    @Override
     HashLongCharMap newUpdatableMap(int expectedSize);

    


    @Override
     HashLongCharMap newUpdatableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, int expectedSize);

    @Override
     HashLongCharMap newUpdatableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3, int expectedSize);

    @Override
     HashLongCharMap newUpdatableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4, int expectedSize);

    @Override
     HashLongCharMap newUpdatableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4, Map<Long, Character> map5, int expectedSize);

    

    
    @Override
     HashLongCharMap newUpdatableMap(Map<Long, Character> map);

    @Override
     HashLongCharMap newUpdatableMap(Map<Long, Character> map1,
            Map<Long, Character> map2);

    @Override
     HashLongCharMap newUpdatableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3);

    @Override
     HashLongCharMap newUpdatableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4);

    @Override
     HashLongCharMap newUpdatableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4, Map<Long, Character> map5);


    @Override
     HashLongCharMap newUpdatableMap(
            net.openhft.function.Consumer<LongCharConsumer> entriesSupplier);

    @Override
     HashLongCharMap newUpdatableMap(
            net.openhft.function.Consumer<LongCharConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashLongCharMap newUpdatableMap(long[] keys, char[] values);

    @Override
     HashLongCharMap newUpdatableMap(long[] keys, char[] values,
            int expectedSize);

    @Override
     HashLongCharMap newUpdatableMap(
            Long[] keys, Character[] values);

    @Override
     HashLongCharMap newUpdatableMap(
            Long[] keys, Character[] values, int expectedSize);

    @Override
     HashLongCharMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Character> values);

    @Override
     HashLongCharMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Character> values, int expectedSize);


    @Override
     HashLongCharMap newUpdatableMapOf(long k1, char v1);

    @Override
     HashLongCharMap newUpdatableMapOf(long k1, char v1,
            long k2, char v2);

    @Override
     HashLongCharMap newUpdatableMapOf(long k1, char v1,
            long k2, char v2, long k3, char v3);

    @Override
     HashLongCharMap newUpdatableMapOf(long k1, char v1,
            long k2, char v2, long k3, char v3,
            long k4, char v4);

    @Override
     HashLongCharMap newUpdatableMapOf(long k1, char v1,
            long k2, char v2, long k3, char v3,
            long k4, char v4, long k5, char v5);

    


    @Override
     HashLongCharMap newImmutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, int expectedSize);

    @Override
     HashLongCharMap newImmutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3, int expectedSize);

    @Override
     HashLongCharMap newImmutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4, int expectedSize);

    @Override
     HashLongCharMap newImmutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4, Map<Long, Character> map5, int expectedSize);

    

    
    @Override
     HashLongCharMap newImmutableMap(Map<Long, Character> map);

    @Override
     HashLongCharMap newImmutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2);

    @Override
     HashLongCharMap newImmutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3);

    @Override
     HashLongCharMap newImmutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4);

    @Override
     HashLongCharMap newImmutableMap(Map<Long, Character> map1,
            Map<Long, Character> map2, Map<Long, Character> map3,
            Map<Long, Character> map4, Map<Long, Character> map5);


    @Override
     HashLongCharMap newImmutableMap(
            net.openhft.function.Consumer<LongCharConsumer> entriesSupplier);

    @Override
     HashLongCharMap newImmutableMap(
            net.openhft.function.Consumer<LongCharConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashLongCharMap newImmutableMap(long[] keys, char[] values);

    @Override
     HashLongCharMap newImmutableMap(long[] keys, char[] values,
            int expectedSize);

    @Override
     HashLongCharMap newImmutableMap(
            Long[] keys, Character[] values);

    @Override
     HashLongCharMap newImmutableMap(
            Long[] keys, Character[] values, int expectedSize);

    @Override
     HashLongCharMap newImmutableMap(Iterable<Long> keys,
            Iterable<Character> values);

    @Override
     HashLongCharMap newImmutableMap(Iterable<Long> keys,
            Iterable<Character> values, int expectedSize);


    @Override
     HashLongCharMap newImmutableMapOf(long k1, char v1);

    @Override
     HashLongCharMap newImmutableMapOf(long k1, char v1,
            long k2, char v2);

    @Override
     HashLongCharMap newImmutableMapOf(long k1, char v1,
            long k2, char v2, long k3, char v3);

    @Override
     HashLongCharMap newImmutableMapOf(long k1, char v1,
            long k2, char v2, long k3, char v3,
            long k4, char v4);

    @Override
     HashLongCharMap newImmutableMapOf(long k1, char v1,
            long k2, char v2, long k3, char v3,
            long k4, char v4, long k5, char v5);
}

