/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.LongByteConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashLongByteMap}s, and
 * the default {@link HashLongByteMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashLongByteMap
 */
public final class HashLongByteMaps {

    

    private static final ServiceLoader<HashLongByteMapFactory> LOADER =
            ServiceLoader.load(HashLongByteMapFactory.class);
    private static HashLongByteMapFactory defaultFactory = null;

    public static HashLongByteMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashLongByteMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashLongByteMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashLongByteMap newMutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashLongByteMap newMutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashLongByteMap newMutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashLongByteMap newMutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4, Map<Long, Byte> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashLongByteMap newMutableMap(
            Map<Long, Byte> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashLongByteMap newMutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashLongByteMap newMutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashLongByteMap newMutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashLongByteMap newMutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4, Map<Long, Byte> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashLongByteMap newMutableMap(
            net.openhft.function.Consumer<LongByteConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashLongByteMap newMutableMap(
            net.openhft.function.Consumer<LongByteConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashLongByteMap newMutableMap(
            long[] keys, byte[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashLongByteMap newMutableMap(
            long[] keys, byte[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashLongByteMap newMutableMap(
            Long[] keys, Byte[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashLongByteMap newMutableMap(
            Long[] keys, Byte[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashLongByteMap newMutableMap(Iterable<Long> keys,
            Iterable<Byte> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashLongByteMap newMutableMap(Iterable<Long> keys,
            Iterable<Byte> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashLongByteMap newMutableMapOf(
            long k1, byte v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashLongByteMap newMutableMapOf(
            long k1, byte v1, long k2, byte v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashLongByteMap newMutableMapOf(
            long k1, byte v1, long k2, byte v2,
            long k3, byte v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashLongByteMap newMutableMapOf(
            long k1, byte v1, long k2, byte v2,
            long k3, byte v3, long k4, byte v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashLongByteMap newMutableMapOf(
            long k1, byte v1, long k2, byte v2,
            long k3, byte v3, long k4, byte v4,
            long k5, byte v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashLongByteMap newUpdatableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashLongByteMap newUpdatableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashLongByteMap newUpdatableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashLongByteMap newUpdatableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4, Map<Long, Byte> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashLongByteMap newUpdatableMap(
            Map<Long, Byte> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashLongByteMap newUpdatableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashLongByteMap newUpdatableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashLongByteMap newUpdatableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashLongByteMap newUpdatableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4, Map<Long, Byte> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashLongByteMap newUpdatableMap(
            net.openhft.function.Consumer<LongByteConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashLongByteMap newUpdatableMap(
            net.openhft.function.Consumer<LongByteConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashLongByteMap newUpdatableMap(
            long[] keys, byte[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashLongByteMap newUpdatableMap(
            long[] keys, byte[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashLongByteMap newUpdatableMap(
            Long[] keys, Byte[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashLongByteMap newUpdatableMap(
            Long[] keys, Byte[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashLongByteMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Byte> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashLongByteMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Byte> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashLongByteMap newUpdatableMapOf(
            long k1, byte v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashLongByteMap newUpdatableMapOf(
            long k1, byte v1, long k2, byte v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashLongByteMap newUpdatableMapOf(
            long k1, byte v1, long k2, byte v2,
            long k3, byte v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashLongByteMap newUpdatableMapOf(
            long k1, byte v1, long k2, byte v2,
            long k3, byte v3, long k4, byte v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashLongByteMap newUpdatableMapOf(
            long k1, byte v1, long k2, byte v2,
            long k3, byte v3, long k4, byte v4,
            long k5, byte v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashLongByteMap newImmutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashLongByteMap newImmutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashLongByteMap newImmutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashLongByteMap newImmutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4, Map<Long, Byte> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashLongByteMap newImmutableMap(
            Map<Long, Byte> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashLongByteMap newImmutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashLongByteMap newImmutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashLongByteMap newImmutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashLongByteMap newImmutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4, Map<Long, Byte> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashLongByteMap newImmutableMap(
            net.openhft.function.Consumer<LongByteConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashLongByteMap newImmutableMap(
            net.openhft.function.Consumer<LongByteConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashLongByteMap newImmutableMap(
            long[] keys, byte[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashLongByteMap newImmutableMap(
            long[] keys, byte[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashLongByteMap newImmutableMap(
            Long[] keys, Byte[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashLongByteMap newImmutableMap(
            Long[] keys, Byte[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashLongByteMap newImmutableMap(Iterable<Long> keys,
            Iterable<Byte> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashLongByteMap newImmutableMap(Iterable<Long> keys,
            Iterable<Byte> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashLongByteMap newImmutableMapOf(
            long k1, byte v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashLongByteMap newImmutableMapOf(
            long k1, byte v1, long k2, byte v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashLongByteMap newImmutableMapOf(
            long k1, byte v1, long k2, byte v2,
            long k3, byte v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashLongByteMap newImmutableMapOf(
            long k1, byte v1, long k2, byte v2,
            long k3, byte v3, long k4, byte v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashLongByteMap newImmutableMapOf(
            long k1, byte v1, long k2, byte v2,
            long k3, byte v3, long k4, byte v4,
            long k5, byte v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashLongByteMaps() {}
}

