/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.LongByteConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashLongByteMaps}
 *
 * @see HashLongByteMap
 * @see HashLongByteMaps#getDefaultFactory()
 */
public interface HashLongByteMapFactory extends LongByteMapFactory
        , LongHashFactory<HashLongByteMapFactory>
         {

    

    

    

    

    

    
    

    
    


    @Override
    HashLongByteMapFactory withDefaultValue(byte defaultValue);

    @Override
     HashLongByteMap newMutableMap();

    @Override
     HashLongByteMap newMutableMap(int expectedSize);

    


    @Override
     HashLongByteMap newMutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, int expectedSize);

    @Override
     HashLongByteMap newMutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3, int expectedSize);

    @Override
     HashLongByteMap newMutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4, int expectedSize);

    @Override
     HashLongByteMap newMutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4, Map<Long, Byte> map5, int expectedSize);

    

    
    @Override
     HashLongByteMap newMutableMap(Map<Long, Byte> map);

    @Override
     HashLongByteMap newMutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2);

    @Override
     HashLongByteMap newMutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3);

    @Override
     HashLongByteMap newMutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4);

    @Override
     HashLongByteMap newMutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4, Map<Long, Byte> map5);


    @Override
     HashLongByteMap newMutableMap(
            net.openhft.function.Consumer<LongByteConsumer> entriesSupplier);

    @Override
     HashLongByteMap newMutableMap(
            net.openhft.function.Consumer<LongByteConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashLongByteMap newMutableMap(long[] keys, byte[] values);

    @Override
     HashLongByteMap newMutableMap(long[] keys, byte[] values,
            int expectedSize);

    @Override
     HashLongByteMap newMutableMap(
            Long[] keys, Byte[] values);

    @Override
     HashLongByteMap newMutableMap(
            Long[] keys, Byte[] values, int expectedSize);

    @Override
     HashLongByteMap newMutableMap(Iterable<Long> keys,
            Iterable<Byte> values);

    @Override
     HashLongByteMap newMutableMap(Iterable<Long> keys,
            Iterable<Byte> values, int expectedSize);


    @Override
     HashLongByteMap newMutableMapOf(long k1, byte v1);

    @Override
     HashLongByteMap newMutableMapOf(long k1, byte v1,
            long k2, byte v2);

    @Override
     HashLongByteMap newMutableMapOf(long k1, byte v1,
            long k2, byte v2, long k3, byte v3);

    @Override
     HashLongByteMap newMutableMapOf(long k1, byte v1,
            long k2, byte v2, long k3, byte v3,
            long k4, byte v4);

    @Override
     HashLongByteMap newMutableMapOf(long k1, byte v1,
            long k2, byte v2, long k3, byte v3,
            long k4, byte v4, long k5, byte v5);
    @Override
     HashLongByteMap newUpdatableMap();

    @Override
     HashLongByteMap newUpdatableMap(int expectedSize);

    


    @Override
     HashLongByteMap newUpdatableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, int expectedSize);

    @Override
     HashLongByteMap newUpdatableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3, int expectedSize);

    @Override
     HashLongByteMap newUpdatableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4, int expectedSize);

    @Override
     HashLongByteMap newUpdatableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4, Map<Long, Byte> map5, int expectedSize);

    

    
    @Override
     HashLongByteMap newUpdatableMap(Map<Long, Byte> map);

    @Override
     HashLongByteMap newUpdatableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2);

    @Override
     HashLongByteMap newUpdatableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3);

    @Override
     HashLongByteMap newUpdatableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4);

    @Override
     HashLongByteMap newUpdatableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4, Map<Long, Byte> map5);


    @Override
     HashLongByteMap newUpdatableMap(
            net.openhft.function.Consumer<LongByteConsumer> entriesSupplier);

    @Override
     HashLongByteMap newUpdatableMap(
            net.openhft.function.Consumer<LongByteConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashLongByteMap newUpdatableMap(long[] keys, byte[] values);

    @Override
     HashLongByteMap newUpdatableMap(long[] keys, byte[] values,
            int expectedSize);

    @Override
     HashLongByteMap newUpdatableMap(
            Long[] keys, Byte[] values);

    @Override
     HashLongByteMap newUpdatableMap(
            Long[] keys, Byte[] values, int expectedSize);

    @Override
     HashLongByteMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Byte> values);

    @Override
     HashLongByteMap newUpdatableMap(Iterable<Long> keys,
            Iterable<Byte> values, int expectedSize);


    @Override
     HashLongByteMap newUpdatableMapOf(long k1, byte v1);

    @Override
     HashLongByteMap newUpdatableMapOf(long k1, byte v1,
            long k2, byte v2);

    @Override
     HashLongByteMap newUpdatableMapOf(long k1, byte v1,
            long k2, byte v2, long k3, byte v3);

    @Override
     HashLongByteMap newUpdatableMapOf(long k1, byte v1,
            long k2, byte v2, long k3, byte v3,
            long k4, byte v4);

    @Override
     HashLongByteMap newUpdatableMapOf(long k1, byte v1,
            long k2, byte v2, long k3, byte v3,
            long k4, byte v4, long k5, byte v5);

    


    @Override
     HashLongByteMap newImmutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, int expectedSize);

    @Override
     HashLongByteMap newImmutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3, int expectedSize);

    @Override
     HashLongByteMap newImmutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4, int expectedSize);

    @Override
     HashLongByteMap newImmutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4, Map<Long, Byte> map5, int expectedSize);

    

    
    @Override
     HashLongByteMap newImmutableMap(Map<Long, Byte> map);

    @Override
     HashLongByteMap newImmutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2);

    @Override
     HashLongByteMap newImmutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3);

    @Override
     HashLongByteMap newImmutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4);

    @Override
     HashLongByteMap newImmutableMap(Map<Long, Byte> map1,
            Map<Long, Byte> map2, Map<Long, Byte> map3,
            Map<Long, Byte> map4, Map<Long, Byte> map5);


    @Override
     HashLongByteMap newImmutableMap(
            net.openhft.function.Consumer<LongByteConsumer> entriesSupplier);

    @Override
     HashLongByteMap newImmutableMap(
            net.openhft.function.Consumer<LongByteConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashLongByteMap newImmutableMap(long[] keys, byte[] values);

    @Override
     HashLongByteMap newImmutableMap(long[] keys, byte[] values,
            int expectedSize);

    @Override
     HashLongByteMap newImmutableMap(
            Long[] keys, Byte[] values);

    @Override
     HashLongByteMap newImmutableMap(
            Long[] keys, Byte[] values, int expectedSize);

    @Override
     HashLongByteMap newImmutableMap(Iterable<Long> keys,
            Iterable<Byte> values);

    @Override
     HashLongByteMap newImmutableMap(Iterable<Long> keys,
            Iterable<Byte> values, int expectedSize);


    @Override
     HashLongByteMap newImmutableMapOf(long k1, byte v1);

    @Override
     HashLongByteMap newImmutableMapOf(long k1, byte v1,
            long k2, byte v2);

    @Override
     HashLongByteMap newImmutableMapOf(long k1, byte v1,
            long k2, byte v2, long k3, byte v3);

    @Override
     HashLongByteMap newImmutableMapOf(long k1, byte v1,
            long k2, byte v2, long k3, byte v3,
            long k4, byte v4);

    @Override
     HashLongByteMap newImmutableMapOf(long k1, byte v1,
            long k2, byte v2, long k3, byte v3,
            long k4, byte v4, long k5, byte v5);
}

