/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.IntShortConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashIntShortMap}s, and
 * the default {@link HashIntShortMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashIntShortMap
 */
public final class HashIntShortMaps {

    

    private static final ServiceLoader<HashIntShortMapFactory> LOADER =
            ServiceLoader.load(HashIntShortMapFactory.class);
    private static HashIntShortMapFactory defaultFactory = null;

    public static HashIntShortMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashIntShortMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashIntShortMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashIntShortMap newMutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashIntShortMap newMutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashIntShortMap newMutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashIntShortMap newMutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4, Map<Integer, Short> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashIntShortMap newMutableMap(
            Map<Integer, Short> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashIntShortMap newMutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashIntShortMap newMutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashIntShortMap newMutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashIntShortMap newMutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4, Map<Integer, Short> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashIntShortMap newMutableMap(
            net.openhft.function.Consumer<IntShortConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashIntShortMap newMutableMap(
            net.openhft.function.Consumer<IntShortConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashIntShortMap newMutableMap(
            int[] keys, short[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashIntShortMap newMutableMap(
            int[] keys, short[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashIntShortMap newMutableMap(
            Integer[] keys, Short[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashIntShortMap newMutableMap(
            Integer[] keys, Short[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashIntShortMap newMutableMap(Iterable<Integer> keys,
            Iterable<Short> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashIntShortMap newMutableMap(Iterable<Integer> keys,
            Iterable<Short> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashIntShortMap newMutableMapOf(
            int k1, short v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashIntShortMap newMutableMapOf(
            int k1, short v1, int k2, short v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashIntShortMap newMutableMapOf(
            int k1, short v1, int k2, short v2,
            int k3, short v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashIntShortMap newMutableMapOf(
            int k1, short v1, int k2, short v2,
            int k3, short v3, int k4, short v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashIntShortMap newMutableMapOf(
            int k1, short v1, int k2, short v2,
            int k3, short v3, int k4, short v4,
            int k5, short v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashIntShortMap newUpdatableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashIntShortMap newUpdatableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashIntShortMap newUpdatableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashIntShortMap newUpdatableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4, Map<Integer, Short> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashIntShortMap newUpdatableMap(
            Map<Integer, Short> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashIntShortMap newUpdatableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashIntShortMap newUpdatableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashIntShortMap newUpdatableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashIntShortMap newUpdatableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4, Map<Integer, Short> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashIntShortMap newUpdatableMap(
            net.openhft.function.Consumer<IntShortConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashIntShortMap newUpdatableMap(
            net.openhft.function.Consumer<IntShortConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashIntShortMap newUpdatableMap(
            int[] keys, short[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashIntShortMap newUpdatableMap(
            int[] keys, short[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashIntShortMap newUpdatableMap(
            Integer[] keys, Short[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashIntShortMap newUpdatableMap(
            Integer[] keys, Short[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashIntShortMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Short> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashIntShortMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Short> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashIntShortMap newUpdatableMapOf(
            int k1, short v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashIntShortMap newUpdatableMapOf(
            int k1, short v1, int k2, short v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashIntShortMap newUpdatableMapOf(
            int k1, short v1, int k2, short v2,
            int k3, short v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashIntShortMap newUpdatableMapOf(
            int k1, short v1, int k2, short v2,
            int k3, short v3, int k4, short v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashIntShortMap newUpdatableMapOf(
            int k1, short v1, int k2, short v2,
            int k3, short v3, int k4, short v4,
            int k5, short v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashIntShortMap newImmutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashIntShortMap newImmutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashIntShortMap newImmutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashIntShortMap newImmutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4, Map<Integer, Short> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashIntShortMap newImmutableMap(
            Map<Integer, Short> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashIntShortMap newImmutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashIntShortMap newImmutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashIntShortMap newImmutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashIntShortMap newImmutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4, Map<Integer, Short> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashIntShortMap newImmutableMap(
            net.openhft.function.Consumer<IntShortConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashIntShortMap newImmutableMap(
            net.openhft.function.Consumer<IntShortConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashIntShortMap newImmutableMap(
            int[] keys, short[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashIntShortMap newImmutableMap(
            int[] keys, short[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashIntShortMap newImmutableMap(
            Integer[] keys, Short[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashIntShortMap newImmutableMap(
            Integer[] keys, Short[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashIntShortMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Short> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashIntShortMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Short> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashIntShortMap newImmutableMapOf(
            int k1, short v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashIntShortMap newImmutableMapOf(
            int k1, short v1, int k2, short v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashIntShortMap newImmutableMapOf(
            int k1, short v1, int k2, short v2,
            int k3, short v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashIntShortMap newImmutableMapOf(
            int k1, short v1, int k2, short v2,
            int k3, short v3, int k4, short v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashIntShortMap newImmutableMapOf(
            int k1, short v1, int k2, short v2,
            int k3, short v3, int k4, short v4,
            int k5, short v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashIntShortMaps() {}
}

