/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.IntShortConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashIntShortMaps}
 *
 * @see HashIntShortMap
 * @see HashIntShortMaps#getDefaultFactory()
 */
public interface HashIntShortMapFactory extends IntShortMapFactory
        , IntHashFactory<HashIntShortMapFactory>
         {

    

    

    

    

    

    
    

    
    


    @Override
    HashIntShortMapFactory withDefaultValue(short defaultValue);

    @Override
     HashIntShortMap newMutableMap();

    @Override
     HashIntShortMap newMutableMap(int expectedSize);

    


    @Override
     HashIntShortMap newMutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, int expectedSize);

    @Override
     HashIntShortMap newMutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3, int expectedSize);

    @Override
     HashIntShortMap newMutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4, int expectedSize);

    @Override
     HashIntShortMap newMutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4, Map<Integer, Short> map5, int expectedSize);

    

    
    @Override
     HashIntShortMap newMutableMap(Map<Integer, Short> map);

    @Override
     HashIntShortMap newMutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2);

    @Override
     HashIntShortMap newMutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3);

    @Override
     HashIntShortMap newMutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4);

    @Override
     HashIntShortMap newMutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4, Map<Integer, Short> map5);


    @Override
     HashIntShortMap newMutableMap(
            net.openhft.function.Consumer<IntShortConsumer> entriesSupplier);

    @Override
     HashIntShortMap newMutableMap(
            net.openhft.function.Consumer<IntShortConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashIntShortMap newMutableMap(int[] keys, short[] values);

    @Override
     HashIntShortMap newMutableMap(int[] keys, short[] values,
            int expectedSize);

    @Override
     HashIntShortMap newMutableMap(
            Integer[] keys, Short[] values);

    @Override
     HashIntShortMap newMutableMap(
            Integer[] keys, Short[] values, int expectedSize);

    @Override
     HashIntShortMap newMutableMap(Iterable<Integer> keys,
            Iterable<Short> values);

    @Override
     HashIntShortMap newMutableMap(Iterable<Integer> keys,
            Iterable<Short> values, int expectedSize);


    @Override
     HashIntShortMap newMutableMapOf(int k1, short v1);

    @Override
     HashIntShortMap newMutableMapOf(int k1, short v1,
            int k2, short v2);

    @Override
     HashIntShortMap newMutableMapOf(int k1, short v1,
            int k2, short v2, int k3, short v3);

    @Override
     HashIntShortMap newMutableMapOf(int k1, short v1,
            int k2, short v2, int k3, short v3,
            int k4, short v4);

    @Override
     HashIntShortMap newMutableMapOf(int k1, short v1,
            int k2, short v2, int k3, short v3,
            int k4, short v4, int k5, short v5);
    @Override
     HashIntShortMap newUpdatableMap();

    @Override
     HashIntShortMap newUpdatableMap(int expectedSize);

    


    @Override
     HashIntShortMap newUpdatableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, int expectedSize);

    @Override
     HashIntShortMap newUpdatableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3, int expectedSize);

    @Override
     HashIntShortMap newUpdatableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4, int expectedSize);

    @Override
     HashIntShortMap newUpdatableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4, Map<Integer, Short> map5, int expectedSize);

    

    
    @Override
     HashIntShortMap newUpdatableMap(Map<Integer, Short> map);

    @Override
     HashIntShortMap newUpdatableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2);

    @Override
     HashIntShortMap newUpdatableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3);

    @Override
     HashIntShortMap newUpdatableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4);

    @Override
     HashIntShortMap newUpdatableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4, Map<Integer, Short> map5);


    @Override
     HashIntShortMap newUpdatableMap(
            net.openhft.function.Consumer<IntShortConsumer> entriesSupplier);

    @Override
     HashIntShortMap newUpdatableMap(
            net.openhft.function.Consumer<IntShortConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashIntShortMap newUpdatableMap(int[] keys, short[] values);

    @Override
     HashIntShortMap newUpdatableMap(int[] keys, short[] values,
            int expectedSize);

    @Override
     HashIntShortMap newUpdatableMap(
            Integer[] keys, Short[] values);

    @Override
     HashIntShortMap newUpdatableMap(
            Integer[] keys, Short[] values, int expectedSize);

    @Override
     HashIntShortMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Short> values);

    @Override
     HashIntShortMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Short> values, int expectedSize);


    @Override
     HashIntShortMap newUpdatableMapOf(int k1, short v1);

    @Override
     HashIntShortMap newUpdatableMapOf(int k1, short v1,
            int k2, short v2);

    @Override
     HashIntShortMap newUpdatableMapOf(int k1, short v1,
            int k2, short v2, int k3, short v3);

    @Override
     HashIntShortMap newUpdatableMapOf(int k1, short v1,
            int k2, short v2, int k3, short v3,
            int k4, short v4);

    @Override
     HashIntShortMap newUpdatableMapOf(int k1, short v1,
            int k2, short v2, int k3, short v3,
            int k4, short v4, int k5, short v5);

    


    @Override
     HashIntShortMap newImmutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, int expectedSize);

    @Override
     HashIntShortMap newImmutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3, int expectedSize);

    @Override
     HashIntShortMap newImmutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4, int expectedSize);

    @Override
     HashIntShortMap newImmutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4, Map<Integer, Short> map5, int expectedSize);

    

    
    @Override
     HashIntShortMap newImmutableMap(Map<Integer, Short> map);

    @Override
     HashIntShortMap newImmutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2);

    @Override
     HashIntShortMap newImmutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3);

    @Override
     HashIntShortMap newImmutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4);

    @Override
     HashIntShortMap newImmutableMap(Map<Integer, Short> map1,
            Map<Integer, Short> map2, Map<Integer, Short> map3,
            Map<Integer, Short> map4, Map<Integer, Short> map5);


    @Override
     HashIntShortMap newImmutableMap(
            net.openhft.function.Consumer<IntShortConsumer> entriesSupplier);

    @Override
     HashIntShortMap newImmutableMap(
            net.openhft.function.Consumer<IntShortConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashIntShortMap newImmutableMap(int[] keys, short[] values);

    @Override
     HashIntShortMap newImmutableMap(int[] keys, short[] values,
            int expectedSize);

    @Override
     HashIntShortMap newImmutableMap(
            Integer[] keys, Short[] values);

    @Override
     HashIntShortMap newImmutableMap(
            Integer[] keys, Short[] values, int expectedSize);

    @Override
     HashIntShortMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Short> values);

    @Override
     HashIntShortMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Short> values, int expectedSize);


    @Override
     HashIntShortMap newImmutableMapOf(int k1, short v1);

    @Override
     HashIntShortMap newImmutableMapOf(int k1, short v1,
            int k2, short v2);

    @Override
     HashIntShortMap newImmutableMapOf(int k1, short v1,
            int k2, short v2, int k3, short v3);

    @Override
     HashIntShortMap newImmutableMapOf(int k1, short v1,
            int k2, short v2, int k3, short v3,
            int k4, short v4);

    @Override
     HashIntShortMap newImmutableMapOf(int k1, short v1,
            int k2, short v2, int k3, short v3,
            int k4, short v4, int k5, short v5);
}

