/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.IntObjConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashIntObjMaps}
 *
 * @see HashIntObjMap
 * @see HashIntObjMaps#getDefaultFactory()
 */
public interface HashIntObjMapFactory<V> extends IntObjMapFactory<V>
        , IntHashFactory<HashIntObjMapFactory<V>>
         {

    

    

    

    

    

    
    

    
    


    @Override
    <VE> HashIntObjMapFactory<VE>
    withValueEquivalence(@Nullable Equivalence<VE> valueEquivalence);


    @Override
    <V2 extends V> HashIntObjMap<V2> newMutableMap();

    @Override
    <V2 extends V> HashIntObjMap<V2> newMutableMap(int expectedSize);

    


    @Override
    <V2 extends V> HashIntObjMap<V2> newMutableMap(Map<Integer, ? extends V2> map1,
            Map<Integer, ? extends V2> map2, int expectedSize);

    @Override
    <V2 extends V> HashIntObjMap<V2> newMutableMap(Map<Integer, ? extends V2> map1,
            Map<Integer, ? extends V2> map2, Map<Integer, ? extends V2> map3, int expectedSize);

    @Override
    <V2 extends V> HashIntObjMap<V2> newMutableMap(Map<Integer, ? extends V2> map1,
            Map<Integer, ? extends V2> map2, Map<Integer, ? extends V2> map3,
            Map<Integer, ? extends V2> map4, int expectedSize);

    @Override
    <V2 extends V> HashIntObjMap<V2> newMutableMap(Map<Integer, ? extends V2> map1,
            Map<Integer, ? extends V2> map2, Map<Integer, ? extends V2> map3,
            Map<Integer, ? extends V2> map4, Map<Integer, ? extends V2> map5, int expectedSize);

    

    
    @Override
    <V2 extends V> HashIntObjMap<V2> newMutableMap(Map<Integer, ? extends V2> map);

    @Override
    <V2 extends V> HashIntObjMap<V2> newMutableMap(Map<Integer, ? extends V2> map1,
            Map<Integer, ? extends V2> map2);

    @Override
    <V2 extends V> HashIntObjMap<V2> newMutableMap(Map<Integer, ? extends V2> map1,
            Map<Integer, ? extends V2> map2, Map<Integer, ? extends V2> map3);

    @Override
    <V2 extends V> HashIntObjMap<V2> newMutableMap(Map<Integer, ? extends V2> map1,
            Map<Integer, ? extends V2> map2, Map<Integer, ? extends V2> map3,
            Map<Integer, ? extends V2> map4);

    @Override
    <V2 extends V> HashIntObjMap<V2> newMutableMap(Map<Integer, ? extends V2> map1,
            Map<Integer, ? extends V2> map2, Map<Integer, ? extends V2> map3,
            Map<Integer, ? extends V2> map4, Map<Integer, ? extends V2> map5);


    @Override
    <V2 extends V> HashIntObjMap<V2> newMutableMap(
            net.openhft.function.Consumer<IntObjConsumer<V2>> entriesSupplier);

    @Override
    <V2 extends V> HashIntObjMap<V2> newMutableMap(
            net.openhft.function.Consumer<IntObjConsumer<V2>> entriesSupplier,
            int expectedSize);

    @Override
    <V2 extends V> HashIntObjMap<V2> newMutableMap(int[] keys, V2[] values);

    @Override
    <V2 extends V> HashIntObjMap<V2> newMutableMap(int[] keys, V2[] values,
            int expectedSize);

    @Override
    <V2 extends V> HashIntObjMap<V2> newMutableMap(
            Integer[] keys, V2[] values);

    @Override
    <V2 extends V> HashIntObjMap<V2> newMutableMap(
            Integer[] keys, V2[] values, int expectedSize);

    @Override
    <V2 extends V> HashIntObjMap<V2> newMutableMap(Iterable<Integer> keys,
            Iterable<? extends V2> values);

    @Override
    <V2 extends V> HashIntObjMap<V2> newMutableMap(Iterable<Integer> keys,
            Iterable<? extends V2> values, int expectedSize);


    @Override
    <V2 extends V> HashIntObjMap<V2> newMutableMapOf(int k1, V2 v1);

    @Override
    <V2 extends V> HashIntObjMap<V2> newMutableMapOf(int k1, V2 v1,
            int k2, V2 v2);

    @Override
    <V2 extends V> HashIntObjMap<V2> newMutableMapOf(int k1, V2 v1,
            int k2, V2 v2, int k3, V2 v3);

    @Override
    <V2 extends V> HashIntObjMap<V2> newMutableMapOf(int k1, V2 v1,
            int k2, V2 v2, int k3, V2 v3,
            int k4, V2 v4);

    @Override
    <V2 extends V> HashIntObjMap<V2> newMutableMapOf(int k1, V2 v1,
            int k2, V2 v2, int k3, V2 v3,
            int k4, V2 v4, int k5, V2 v5);
    @Override
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap();

    @Override
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(int expectedSize);

    


    @Override
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(Map<Integer, ? extends V2> map1,
            Map<Integer, ? extends V2> map2, int expectedSize);

    @Override
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(Map<Integer, ? extends V2> map1,
            Map<Integer, ? extends V2> map2, Map<Integer, ? extends V2> map3, int expectedSize);

    @Override
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(Map<Integer, ? extends V2> map1,
            Map<Integer, ? extends V2> map2, Map<Integer, ? extends V2> map3,
            Map<Integer, ? extends V2> map4, int expectedSize);

    @Override
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(Map<Integer, ? extends V2> map1,
            Map<Integer, ? extends V2> map2, Map<Integer, ? extends V2> map3,
            Map<Integer, ? extends V2> map4, Map<Integer, ? extends V2> map5, int expectedSize);

    

    
    @Override
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(Map<Integer, ? extends V2> map);

    @Override
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(Map<Integer, ? extends V2> map1,
            Map<Integer, ? extends V2> map2);

    @Override
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(Map<Integer, ? extends V2> map1,
            Map<Integer, ? extends V2> map2, Map<Integer, ? extends V2> map3);

    @Override
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(Map<Integer, ? extends V2> map1,
            Map<Integer, ? extends V2> map2, Map<Integer, ? extends V2> map3,
            Map<Integer, ? extends V2> map4);

    @Override
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(Map<Integer, ? extends V2> map1,
            Map<Integer, ? extends V2> map2, Map<Integer, ? extends V2> map3,
            Map<Integer, ? extends V2> map4, Map<Integer, ? extends V2> map5);


    @Override
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(
            net.openhft.function.Consumer<IntObjConsumer<V2>> entriesSupplier);

    @Override
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(
            net.openhft.function.Consumer<IntObjConsumer<V2>> entriesSupplier,
            int expectedSize);

    @Override
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(int[] keys, V2[] values);

    @Override
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(int[] keys, V2[] values,
            int expectedSize);

    @Override
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(
            Integer[] keys, V2[] values);

    @Override
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(
            Integer[] keys, V2[] values, int expectedSize);

    @Override
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(Iterable<Integer> keys,
            Iterable<? extends V2> values);

    @Override
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(Iterable<Integer> keys,
            Iterable<? extends V2> values, int expectedSize);


    @Override
    <V2 extends V> HashIntObjMap<V2> newUpdatableMapOf(int k1, V2 v1);

    @Override
    <V2 extends V> HashIntObjMap<V2> newUpdatableMapOf(int k1, V2 v1,
            int k2, V2 v2);

    @Override
    <V2 extends V> HashIntObjMap<V2> newUpdatableMapOf(int k1, V2 v1,
            int k2, V2 v2, int k3, V2 v3);

    @Override
    <V2 extends V> HashIntObjMap<V2> newUpdatableMapOf(int k1, V2 v1,
            int k2, V2 v2, int k3, V2 v3,
            int k4, V2 v4);

    @Override
    <V2 extends V> HashIntObjMap<V2> newUpdatableMapOf(int k1, V2 v1,
            int k2, V2 v2, int k3, V2 v3,
            int k4, V2 v4, int k5, V2 v5);

    


    @Override
    <V2 extends V> HashIntObjMap<V2> newImmutableMap(Map<Integer, ? extends V2> map1,
            Map<Integer, ? extends V2> map2, int expectedSize);

    @Override
    <V2 extends V> HashIntObjMap<V2> newImmutableMap(Map<Integer, ? extends V2> map1,
            Map<Integer, ? extends V2> map2, Map<Integer, ? extends V2> map3, int expectedSize);

    @Override
    <V2 extends V> HashIntObjMap<V2> newImmutableMap(Map<Integer, ? extends V2> map1,
            Map<Integer, ? extends V2> map2, Map<Integer, ? extends V2> map3,
            Map<Integer, ? extends V2> map4, int expectedSize);

    @Override
    <V2 extends V> HashIntObjMap<V2> newImmutableMap(Map<Integer, ? extends V2> map1,
            Map<Integer, ? extends V2> map2, Map<Integer, ? extends V2> map3,
            Map<Integer, ? extends V2> map4, Map<Integer, ? extends V2> map5, int expectedSize);

    

    
    @Override
    <V2 extends V> HashIntObjMap<V2> newImmutableMap(Map<Integer, ? extends V2> map);

    @Override
    <V2 extends V> HashIntObjMap<V2> newImmutableMap(Map<Integer, ? extends V2> map1,
            Map<Integer, ? extends V2> map2);

    @Override
    <V2 extends V> HashIntObjMap<V2> newImmutableMap(Map<Integer, ? extends V2> map1,
            Map<Integer, ? extends V2> map2, Map<Integer, ? extends V2> map3);

    @Override
    <V2 extends V> HashIntObjMap<V2> newImmutableMap(Map<Integer, ? extends V2> map1,
            Map<Integer, ? extends V2> map2, Map<Integer, ? extends V2> map3,
            Map<Integer, ? extends V2> map4);

    @Override
    <V2 extends V> HashIntObjMap<V2> newImmutableMap(Map<Integer, ? extends V2> map1,
            Map<Integer, ? extends V2> map2, Map<Integer, ? extends V2> map3,
            Map<Integer, ? extends V2> map4, Map<Integer, ? extends V2> map5);


    @Override
    <V2 extends V> HashIntObjMap<V2> newImmutableMap(
            net.openhft.function.Consumer<IntObjConsumer<V2>> entriesSupplier);

    @Override
    <V2 extends V> HashIntObjMap<V2> newImmutableMap(
            net.openhft.function.Consumer<IntObjConsumer<V2>> entriesSupplier,
            int expectedSize);

    @Override
    <V2 extends V> HashIntObjMap<V2> newImmutableMap(int[] keys, V2[] values);

    @Override
    <V2 extends V> HashIntObjMap<V2> newImmutableMap(int[] keys, V2[] values,
            int expectedSize);

    @Override
    <V2 extends V> HashIntObjMap<V2> newImmutableMap(
            Integer[] keys, V2[] values);

    @Override
    <V2 extends V> HashIntObjMap<V2> newImmutableMap(
            Integer[] keys, V2[] values, int expectedSize);

    @Override
    <V2 extends V> HashIntObjMap<V2> newImmutableMap(Iterable<Integer> keys,
            Iterable<? extends V2> values);

    @Override
    <V2 extends V> HashIntObjMap<V2> newImmutableMap(Iterable<Integer> keys,
            Iterable<? extends V2> values, int expectedSize);


    @Override
    <V2 extends V> HashIntObjMap<V2> newImmutableMapOf(int k1, V2 v1);

    @Override
    <V2 extends V> HashIntObjMap<V2> newImmutableMapOf(int k1, V2 v1,
            int k2, V2 v2);

    @Override
    <V2 extends V> HashIntObjMap<V2> newImmutableMapOf(int k1, V2 v1,
            int k2, V2 v2, int k3, V2 v3);

    @Override
    <V2 extends V> HashIntObjMap<V2> newImmutableMapOf(int k1, V2 v1,
            int k2, V2 v2, int k3, V2 v3,
            int k4, V2 v4);

    @Override
    <V2 extends V> HashIntObjMap<V2> newImmutableMapOf(int k1, V2 v1,
            int k2, V2 v2, int k3, V2 v3,
            int k4, V2 v4, int k5, V2 v5);
}

