/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.IntLongConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashIntLongMaps}
 *
 * @see HashIntLongMap
 * @see HashIntLongMaps#getDefaultFactory()
 */
public interface HashIntLongMapFactory extends IntLongMapFactory
        , IntHashFactory<HashIntLongMapFactory>
         {

    

    

    

    

    

    
    

    
    


    @Override
    HashIntLongMapFactory withDefaultValue(long defaultValue);

    @Override
     HashIntLongMap newMutableMap();

    @Override
     HashIntLongMap newMutableMap(int expectedSize);

    


    @Override
     HashIntLongMap newMutableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, int expectedSize);

    @Override
     HashIntLongMap newMutableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3, int expectedSize);

    @Override
     HashIntLongMap newMutableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3,
            Map<Integer, Long> map4, int expectedSize);

    @Override
     HashIntLongMap newMutableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3,
            Map<Integer, Long> map4, Map<Integer, Long> map5, int expectedSize);

    

    
    @Override
     HashIntLongMap newMutableMap(Map<Integer, Long> map);

    @Override
     HashIntLongMap newMutableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2);

    @Override
     HashIntLongMap newMutableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3);

    @Override
     HashIntLongMap newMutableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3,
            Map<Integer, Long> map4);

    @Override
     HashIntLongMap newMutableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3,
            Map<Integer, Long> map4, Map<Integer, Long> map5);


    @Override
     HashIntLongMap newMutableMap(
            net.openhft.function.Consumer<IntLongConsumer> entriesSupplier);

    @Override
     HashIntLongMap newMutableMap(
            net.openhft.function.Consumer<IntLongConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashIntLongMap newMutableMap(int[] keys, long[] values);

    @Override
     HashIntLongMap newMutableMap(int[] keys, long[] values,
            int expectedSize);

    @Override
     HashIntLongMap newMutableMap(
            Integer[] keys, Long[] values);

    @Override
     HashIntLongMap newMutableMap(
            Integer[] keys, Long[] values, int expectedSize);

    @Override
     HashIntLongMap newMutableMap(Iterable<Integer> keys,
            Iterable<Long> values);

    @Override
     HashIntLongMap newMutableMap(Iterable<Integer> keys,
            Iterable<Long> values, int expectedSize);


    @Override
     HashIntLongMap newMutableMapOf(int k1, long v1);

    @Override
     HashIntLongMap newMutableMapOf(int k1, long v1,
            int k2, long v2);

    @Override
     HashIntLongMap newMutableMapOf(int k1, long v1,
            int k2, long v2, int k3, long v3);

    @Override
     HashIntLongMap newMutableMapOf(int k1, long v1,
            int k2, long v2, int k3, long v3,
            int k4, long v4);

    @Override
     HashIntLongMap newMutableMapOf(int k1, long v1,
            int k2, long v2, int k3, long v3,
            int k4, long v4, int k5, long v5);
    @Override
     HashIntLongMap newUpdatableMap();

    @Override
     HashIntLongMap newUpdatableMap(int expectedSize);

    


    @Override
     HashIntLongMap newUpdatableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, int expectedSize);

    @Override
     HashIntLongMap newUpdatableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3, int expectedSize);

    @Override
     HashIntLongMap newUpdatableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3,
            Map<Integer, Long> map4, int expectedSize);

    @Override
     HashIntLongMap newUpdatableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3,
            Map<Integer, Long> map4, Map<Integer, Long> map5, int expectedSize);

    

    
    @Override
     HashIntLongMap newUpdatableMap(Map<Integer, Long> map);

    @Override
     HashIntLongMap newUpdatableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2);

    @Override
     HashIntLongMap newUpdatableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3);

    @Override
     HashIntLongMap newUpdatableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3,
            Map<Integer, Long> map4);

    @Override
     HashIntLongMap newUpdatableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3,
            Map<Integer, Long> map4, Map<Integer, Long> map5);


    @Override
     HashIntLongMap newUpdatableMap(
            net.openhft.function.Consumer<IntLongConsumer> entriesSupplier);

    @Override
     HashIntLongMap newUpdatableMap(
            net.openhft.function.Consumer<IntLongConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashIntLongMap newUpdatableMap(int[] keys, long[] values);

    @Override
     HashIntLongMap newUpdatableMap(int[] keys, long[] values,
            int expectedSize);

    @Override
     HashIntLongMap newUpdatableMap(
            Integer[] keys, Long[] values);

    @Override
     HashIntLongMap newUpdatableMap(
            Integer[] keys, Long[] values, int expectedSize);

    @Override
     HashIntLongMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Long> values);

    @Override
     HashIntLongMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Long> values, int expectedSize);


    @Override
     HashIntLongMap newUpdatableMapOf(int k1, long v1);

    @Override
     HashIntLongMap newUpdatableMapOf(int k1, long v1,
            int k2, long v2);

    @Override
     HashIntLongMap newUpdatableMapOf(int k1, long v1,
            int k2, long v2, int k3, long v3);

    @Override
     HashIntLongMap newUpdatableMapOf(int k1, long v1,
            int k2, long v2, int k3, long v3,
            int k4, long v4);

    @Override
     HashIntLongMap newUpdatableMapOf(int k1, long v1,
            int k2, long v2, int k3, long v3,
            int k4, long v4, int k5, long v5);

    


    @Override
     HashIntLongMap newImmutableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, int expectedSize);

    @Override
     HashIntLongMap newImmutableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3, int expectedSize);

    @Override
     HashIntLongMap newImmutableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3,
            Map<Integer, Long> map4, int expectedSize);

    @Override
     HashIntLongMap newImmutableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3,
            Map<Integer, Long> map4, Map<Integer, Long> map5, int expectedSize);

    

    
    @Override
     HashIntLongMap newImmutableMap(Map<Integer, Long> map);

    @Override
     HashIntLongMap newImmutableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2);

    @Override
     HashIntLongMap newImmutableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3);

    @Override
     HashIntLongMap newImmutableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3,
            Map<Integer, Long> map4);

    @Override
     HashIntLongMap newImmutableMap(Map<Integer, Long> map1,
            Map<Integer, Long> map2, Map<Integer, Long> map3,
            Map<Integer, Long> map4, Map<Integer, Long> map5);


    @Override
     HashIntLongMap newImmutableMap(
            net.openhft.function.Consumer<IntLongConsumer> entriesSupplier);

    @Override
     HashIntLongMap newImmutableMap(
            net.openhft.function.Consumer<IntLongConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashIntLongMap newImmutableMap(int[] keys, long[] values);

    @Override
     HashIntLongMap newImmutableMap(int[] keys, long[] values,
            int expectedSize);

    @Override
     HashIntLongMap newImmutableMap(
            Integer[] keys, Long[] values);

    @Override
     HashIntLongMap newImmutableMap(
            Integer[] keys, Long[] values, int expectedSize);

    @Override
     HashIntLongMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Long> values);

    @Override
     HashIntLongMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Long> values, int expectedSize);


    @Override
     HashIntLongMap newImmutableMapOf(int k1, long v1);

    @Override
     HashIntLongMap newImmutableMapOf(int k1, long v1,
            int k2, long v2);

    @Override
     HashIntLongMap newImmutableMapOf(int k1, long v1,
            int k2, long v2, int k3, long v3);

    @Override
     HashIntLongMap newImmutableMapOf(int k1, long v1,
            int k2, long v2, int k3, long v3,
            int k4, long v4);

    @Override
     HashIntLongMap newImmutableMapOf(int k1, long v1,
            int k2, long v2, int k3, long v3,
            int k4, long v4, int k5, long v5);
}

