/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.IntIntConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashIntIntMap}s, and
 * the default {@link HashIntIntMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashIntIntMap
 */
public final class HashIntIntMaps {

    

    private static final ServiceLoader<HashIntIntMapFactory> LOADER =
            ServiceLoader.load(HashIntIntMapFactory.class);
    private static HashIntIntMapFactory defaultFactory = null;

    public static HashIntIntMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashIntIntMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashIntIntMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashIntIntMap newMutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashIntIntMap newMutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashIntIntMap newMutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashIntIntMap newMutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4, Map<Integer, Integer> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashIntIntMap newMutableMap(
            Map<Integer, Integer> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashIntIntMap newMutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashIntIntMap newMutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashIntIntMap newMutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashIntIntMap newMutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4, Map<Integer, Integer> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashIntIntMap newMutableMap(
            net.openhft.function.Consumer<IntIntConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashIntIntMap newMutableMap(
            net.openhft.function.Consumer<IntIntConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashIntIntMap newMutableMap(
            int[] keys, int[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashIntIntMap newMutableMap(
            int[] keys, int[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashIntIntMap newMutableMap(
            Integer[] keys, Integer[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashIntIntMap newMutableMap(
            Integer[] keys, Integer[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashIntIntMap newMutableMap(Iterable<Integer> keys,
            Iterable<Integer> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashIntIntMap newMutableMap(Iterable<Integer> keys,
            Iterable<Integer> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashIntIntMap newMutableMapOf(
            int k1, int v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashIntIntMap newMutableMapOf(
            int k1, int v1, int k2, int v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashIntIntMap newMutableMapOf(
            int k1, int v1, int k2, int v2,
            int k3, int v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashIntIntMap newMutableMapOf(
            int k1, int v1, int k2, int v2,
            int k3, int v3, int k4, int v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashIntIntMap newMutableMapOf(
            int k1, int v1, int k2, int v2,
            int k3, int v3, int k4, int v4,
            int k5, int v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashIntIntMap newUpdatableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashIntIntMap newUpdatableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashIntIntMap newUpdatableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashIntIntMap newUpdatableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4, Map<Integer, Integer> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashIntIntMap newUpdatableMap(
            Map<Integer, Integer> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashIntIntMap newUpdatableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashIntIntMap newUpdatableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashIntIntMap newUpdatableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashIntIntMap newUpdatableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4, Map<Integer, Integer> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashIntIntMap newUpdatableMap(
            net.openhft.function.Consumer<IntIntConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashIntIntMap newUpdatableMap(
            net.openhft.function.Consumer<IntIntConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashIntIntMap newUpdatableMap(
            int[] keys, int[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashIntIntMap newUpdatableMap(
            int[] keys, int[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashIntIntMap newUpdatableMap(
            Integer[] keys, Integer[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashIntIntMap newUpdatableMap(
            Integer[] keys, Integer[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashIntIntMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Integer> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashIntIntMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Integer> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashIntIntMap newUpdatableMapOf(
            int k1, int v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashIntIntMap newUpdatableMapOf(
            int k1, int v1, int k2, int v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashIntIntMap newUpdatableMapOf(
            int k1, int v1, int k2, int v2,
            int k3, int v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashIntIntMap newUpdatableMapOf(
            int k1, int v1, int k2, int v2,
            int k3, int v3, int k4, int v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashIntIntMap newUpdatableMapOf(
            int k1, int v1, int k2, int v2,
            int k3, int v3, int k4, int v4,
            int k5, int v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashIntIntMap newImmutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashIntIntMap newImmutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashIntIntMap newImmutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashIntIntMap newImmutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4, Map<Integer, Integer> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashIntIntMap newImmutableMap(
            Map<Integer, Integer> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashIntIntMap newImmutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashIntIntMap newImmutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashIntIntMap newImmutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashIntIntMap newImmutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4, Map<Integer, Integer> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashIntIntMap newImmutableMap(
            net.openhft.function.Consumer<IntIntConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashIntIntMap newImmutableMap(
            net.openhft.function.Consumer<IntIntConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashIntIntMap newImmutableMap(
            int[] keys, int[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashIntIntMap newImmutableMap(
            int[] keys, int[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashIntIntMap newImmutableMap(
            Integer[] keys, Integer[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashIntIntMap newImmutableMap(
            Integer[] keys, Integer[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashIntIntMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Integer> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashIntIntMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Integer> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashIntIntMap newImmutableMapOf(
            int k1, int v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashIntIntMap newImmutableMapOf(
            int k1, int v1, int k2, int v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashIntIntMap newImmutableMapOf(
            int k1, int v1, int k2, int v2,
            int k3, int v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashIntIntMap newImmutableMapOf(
            int k1, int v1, int k2, int v2,
            int k3, int v3, int k4, int v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashIntIntMap newImmutableMapOf(
            int k1, int v1, int k2, int v2,
            int k3, int v3, int k4, int v4,
            int k5, int v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashIntIntMaps() {}
}

