/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.IntIntConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashIntIntMaps}
 *
 * @see HashIntIntMap
 * @see HashIntIntMaps#getDefaultFactory()
 */
public interface HashIntIntMapFactory extends IntIntMapFactory
        , IntHashFactory<HashIntIntMapFactory>
         {

    

    

    

    

    

    
    

    
    


    @Override
    HashIntIntMapFactory withDefaultValue(int defaultValue);

    @Override
     HashIntIntMap newMutableMap();

    @Override
     HashIntIntMap newMutableMap(int expectedSize);

    


    @Override
     HashIntIntMap newMutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, int expectedSize);

    @Override
     HashIntIntMap newMutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3, int expectedSize);

    @Override
     HashIntIntMap newMutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4, int expectedSize);

    @Override
     HashIntIntMap newMutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4, Map<Integer, Integer> map5, int expectedSize);

    

    
    @Override
     HashIntIntMap newMutableMap(Map<Integer, Integer> map);

    @Override
     HashIntIntMap newMutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2);

    @Override
     HashIntIntMap newMutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3);

    @Override
     HashIntIntMap newMutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4);

    @Override
     HashIntIntMap newMutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4, Map<Integer, Integer> map5);


    @Override
     HashIntIntMap newMutableMap(
            net.openhft.function.Consumer<IntIntConsumer> entriesSupplier);

    @Override
     HashIntIntMap newMutableMap(
            net.openhft.function.Consumer<IntIntConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashIntIntMap newMutableMap(int[] keys, int[] values);

    @Override
     HashIntIntMap newMutableMap(int[] keys, int[] values,
            int expectedSize);

    @Override
     HashIntIntMap newMutableMap(
            Integer[] keys, Integer[] values);

    @Override
     HashIntIntMap newMutableMap(
            Integer[] keys, Integer[] values, int expectedSize);

    @Override
     HashIntIntMap newMutableMap(Iterable<Integer> keys,
            Iterable<Integer> values);

    @Override
     HashIntIntMap newMutableMap(Iterable<Integer> keys,
            Iterable<Integer> values, int expectedSize);


    @Override
     HashIntIntMap newMutableMapOf(int k1, int v1);

    @Override
     HashIntIntMap newMutableMapOf(int k1, int v1,
            int k2, int v2);

    @Override
     HashIntIntMap newMutableMapOf(int k1, int v1,
            int k2, int v2, int k3, int v3);

    @Override
     HashIntIntMap newMutableMapOf(int k1, int v1,
            int k2, int v2, int k3, int v3,
            int k4, int v4);

    @Override
     HashIntIntMap newMutableMapOf(int k1, int v1,
            int k2, int v2, int k3, int v3,
            int k4, int v4, int k5, int v5);
    @Override
     HashIntIntMap newUpdatableMap();

    @Override
     HashIntIntMap newUpdatableMap(int expectedSize);

    


    @Override
     HashIntIntMap newUpdatableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, int expectedSize);

    @Override
     HashIntIntMap newUpdatableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3, int expectedSize);

    @Override
     HashIntIntMap newUpdatableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4, int expectedSize);

    @Override
     HashIntIntMap newUpdatableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4, Map<Integer, Integer> map5, int expectedSize);

    

    
    @Override
     HashIntIntMap newUpdatableMap(Map<Integer, Integer> map);

    @Override
     HashIntIntMap newUpdatableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2);

    @Override
     HashIntIntMap newUpdatableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3);

    @Override
     HashIntIntMap newUpdatableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4);

    @Override
     HashIntIntMap newUpdatableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4, Map<Integer, Integer> map5);


    @Override
     HashIntIntMap newUpdatableMap(
            net.openhft.function.Consumer<IntIntConsumer> entriesSupplier);

    @Override
     HashIntIntMap newUpdatableMap(
            net.openhft.function.Consumer<IntIntConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashIntIntMap newUpdatableMap(int[] keys, int[] values);

    @Override
     HashIntIntMap newUpdatableMap(int[] keys, int[] values,
            int expectedSize);

    @Override
     HashIntIntMap newUpdatableMap(
            Integer[] keys, Integer[] values);

    @Override
     HashIntIntMap newUpdatableMap(
            Integer[] keys, Integer[] values, int expectedSize);

    @Override
     HashIntIntMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Integer> values);

    @Override
     HashIntIntMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Integer> values, int expectedSize);


    @Override
     HashIntIntMap newUpdatableMapOf(int k1, int v1);

    @Override
     HashIntIntMap newUpdatableMapOf(int k1, int v1,
            int k2, int v2);

    @Override
     HashIntIntMap newUpdatableMapOf(int k1, int v1,
            int k2, int v2, int k3, int v3);

    @Override
     HashIntIntMap newUpdatableMapOf(int k1, int v1,
            int k2, int v2, int k3, int v3,
            int k4, int v4);

    @Override
     HashIntIntMap newUpdatableMapOf(int k1, int v1,
            int k2, int v2, int k3, int v3,
            int k4, int v4, int k5, int v5);

    


    @Override
     HashIntIntMap newImmutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, int expectedSize);

    @Override
     HashIntIntMap newImmutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3, int expectedSize);

    @Override
     HashIntIntMap newImmutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4, int expectedSize);

    @Override
     HashIntIntMap newImmutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4, Map<Integer, Integer> map5, int expectedSize);

    

    
    @Override
     HashIntIntMap newImmutableMap(Map<Integer, Integer> map);

    @Override
     HashIntIntMap newImmutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2);

    @Override
     HashIntIntMap newImmutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3);

    @Override
     HashIntIntMap newImmutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4);

    @Override
     HashIntIntMap newImmutableMap(Map<Integer, Integer> map1,
            Map<Integer, Integer> map2, Map<Integer, Integer> map3,
            Map<Integer, Integer> map4, Map<Integer, Integer> map5);


    @Override
     HashIntIntMap newImmutableMap(
            net.openhft.function.Consumer<IntIntConsumer> entriesSupplier);

    @Override
     HashIntIntMap newImmutableMap(
            net.openhft.function.Consumer<IntIntConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashIntIntMap newImmutableMap(int[] keys, int[] values);

    @Override
     HashIntIntMap newImmutableMap(int[] keys, int[] values,
            int expectedSize);

    @Override
     HashIntIntMap newImmutableMap(
            Integer[] keys, Integer[] values);

    @Override
     HashIntIntMap newImmutableMap(
            Integer[] keys, Integer[] values, int expectedSize);

    @Override
     HashIntIntMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Integer> values);

    @Override
     HashIntIntMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Integer> values, int expectedSize);


    @Override
     HashIntIntMap newImmutableMapOf(int k1, int v1);

    @Override
     HashIntIntMap newImmutableMapOf(int k1, int v1,
            int k2, int v2);

    @Override
     HashIntIntMap newImmutableMapOf(int k1, int v1,
            int k2, int v2, int k3, int v3);

    @Override
     HashIntIntMap newImmutableMapOf(int k1, int v1,
            int k2, int v2, int k3, int v3,
            int k4, int v4);

    @Override
     HashIntIntMap newImmutableMapOf(int k1, int v1,
            int k2, int v2, int k3, int v3,
            int k4, int v4, int k5, int v5);
}

