/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.IntFloatConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashIntFloatMap}s, and
 * the default {@link HashIntFloatMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashIntFloatMap
 */
public final class HashIntFloatMaps {

    

    private static final ServiceLoader<HashIntFloatMapFactory> LOADER =
            ServiceLoader.load(HashIntFloatMapFactory.class);
    private static HashIntFloatMapFactory defaultFactory = null;

    public static HashIntFloatMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashIntFloatMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashIntFloatMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashIntFloatMap newMutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashIntFloatMap newMutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashIntFloatMap newMutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashIntFloatMap newMutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4, Map<Integer, Float> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashIntFloatMap newMutableMap(
            Map<Integer, Float> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashIntFloatMap newMutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashIntFloatMap newMutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashIntFloatMap newMutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashIntFloatMap newMutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4, Map<Integer, Float> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashIntFloatMap newMutableMap(
            net.openhft.function.Consumer<IntFloatConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashIntFloatMap newMutableMap(
            net.openhft.function.Consumer<IntFloatConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashIntFloatMap newMutableMap(
            int[] keys, float[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashIntFloatMap newMutableMap(
            int[] keys, float[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashIntFloatMap newMutableMap(
            Integer[] keys, Float[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashIntFloatMap newMutableMap(
            Integer[] keys, Float[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashIntFloatMap newMutableMap(Iterable<Integer> keys,
            Iterable<Float> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashIntFloatMap newMutableMap(Iterable<Integer> keys,
            Iterable<Float> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashIntFloatMap newMutableMapOf(
            int k1, float v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashIntFloatMap newMutableMapOf(
            int k1, float v1, int k2, float v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashIntFloatMap newMutableMapOf(
            int k1, float v1, int k2, float v2,
            int k3, float v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashIntFloatMap newMutableMapOf(
            int k1, float v1, int k2, float v2,
            int k3, float v3, int k4, float v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashIntFloatMap newMutableMapOf(
            int k1, float v1, int k2, float v2,
            int k3, float v3, int k4, float v4,
            int k5, float v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashIntFloatMap newUpdatableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashIntFloatMap newUpdatableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashIntFloatMap newUpdatableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashIntFloatMap newUpdatableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4, Map<Integer, Float> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashIntFloatMap newUpdatableMap(
            Map<Integer, Float> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashIntFloatMap newUpdatableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashIntFloatMap newUpdatableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashIntFloatMap newUpdatableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashIntFloatMap newUpdatableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4, Map<Integer, Float> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashIntFloatMap newUpdatableMap(
            net.openhft.function.Consumer<IntFloatConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashIntFloatMap newUpdatableMap(
            net.openhft.function.Consumer<IntFloatConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashIntFloatMap newUpdatableMap(
            int[] keys, float[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashIntFloatMap newUpdatableMap(
            int[] keys, float[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashIntFloatMap newUpdatableMap(
            Integer[] keys, Float[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashIntFloatMap newUpdatableMap(
            Integer[] keys, Float[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashIntFloatMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Float> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashIntFloatMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Float> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashIntFloatMap newUpdatableMapOf(
            int k1, float v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashIntFloatMap newUpdatableMapOf(
            int k1, float v1, int k2, float v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashIntFloatMap newUpdatableMapOf(
            int k1, float v1, int k2, float v2,
            int k3, float v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashIntFloatMap newUpdatableMapOf(
            int k1, float v1, int k2, float v2,
            int k3, float v3, int k4, float v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashIntFloatMap newUpdatableMapOf(
            int k1, float v1, int k2, float v2,
            int k3, float v3, int k4, float v4,
            int k5, float v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashIntFloatMap newImmutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashIntFloatMap newImmutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashIntFloatMap newImmutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashIntFloatMap newImmutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4, Map<Integer, Float> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashIntFloatMap newImmutableMap(
            Map<Integer, Float> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashIntFloatMap newImmutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashIntFloatMap newImmutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashIntFloatMap newImmutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashIntFloatMap newImmutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4, Map<Integer, Float> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashIntFloatMap newImmutableMap(
            net.openhft.function.Consumer<IntFloatConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashIntFloatMap newImmutableMap(
            net.openhft.function.Consumer<IntFloatConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashIntFloatMap newImmutableMap(
            int[] keys, float[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashIntFloatMap newImmutableMap(
            int[] keys, float[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashIntFloatMap newImmutableMap(
            Integer[] keys, Float[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashIntFloatMap newImmutableMap(
            Integer[] keys, Float[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashIntFloatMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Float> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashIntFloatMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Float> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashIntFloatMap newImmutableMapOf(
            int k1, float v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashIntFloatMap newImmutableMapOf(
            int k1, float v1, int k2, float v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashIntFloatMap newImmutableMapOf(
            int k1, float v1, int k2, float v2,
            int k3, float v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashIntFloatMap newImmutableMapOf(
            int k1, float v1, int k2, float v2,
            int k3, float v3, int k4, float v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashIntFloatMap newImmutableMapOf(
            int k1, float v1, int k2, float v2,
            int k3, float v3, int k4, float v4,
            int k5, float v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashIntFloatMaps() {}
}

