/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.IntFloatConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashIntFloatMaps}
 *
 * @see HashIntFloatMap
 * @see HashIntFloatMaps#getDefaultFactory()
 */
public interface HashIntFloatMapFactory extends IntFloatMapFactory
        , IntHashFactory<HashIntFloatMapFactory>
         {

    

    

    

    

    

    
    

    
    


    @Override
    HashIntFloatMapFactory withDefaultValue(float defaultValue);

    @Override
     HashIntFloatMap newMutableMap();

    @Override
     HashIntFloatMap newMutableMap(int expectedSize);

    


    @Override
     HashIntFloatMap newMutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, int expectedSize);

    @Override
     HashIntFloatMap newMutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3, int expectedSize);

    @Override
     HashIntFloatMap newMutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4, int expectedSize);

    @Override
     HashIntFloatMap newMutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4, Map<Integer, Float> map5, int expectedSize);

    

    
    @Override
     HashIntFloatMap newMutableMap(Map<Integer, Float> map);

    @Override
     HashIntFloatMap newMutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2);

    @Override
     HashIntFloatMap newMutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3);

    @Override
     HashIntFloatMap newMutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4);

    @Override
     HashIntFloatMap newMutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4, Map<Integer, Float> map5);


    @Override
     HashIntFloatMap newMutableMap(
            net.openhft.function.Consumer<IntFloatConsumer> entriesSupplier);

    @Override
     HashIntFloatMap newMutableMap(
            net.openhft.function.Consumer<IntFloatConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashIntFloatMap newMutableMap(int[] keys, float[] values);

    @Override
     HashIntFloatMap newMutableMap(int[] keys, float[] values,
            int expectedSize);

    @Override
     HashIntFloatMap newMutableMap(
            Integer[] keys, Float[] values);

    @Override
     HashIntFloatMap newMutableMap(
            Integer[] keys, Float[] values, int expectedSize);

    @Override
     HashIntFloatMap newMutableMap(Iterable<Integer> keys,
            Iterable<Float> values);

    @Override
     HashIntFloatMap newMutableMap(Iterable<Integer> keys,
            Iterable<Float> values, int expectedSize);


    @Override
     HashIntFloatMap newMutableMapOf(int k1, float v1);

    @Override
     HashIntFloatMap newMutableMapOf(int k1, float v1,
            int k2, float v2);

    @Override
     HashIntFloatMap newMutableMapOf(int k1, float v1,
            int k2, float v2, int k3, float v3);

    @Override
     HashIntFloatMap newMutableMapOf(int k1, float v1,
            int k2, float v2, int k3, float v3,
            int k4, float v4);

    @Override
     HashIntFloatMap newMutableMapOf(int k1, float v1,
            int k2, float v2, int k3, float v3,
            int k4, float v4, int k5, float v5);
    @Override
     HashIntFloatMap newUpdatableMap();

    @Override
     HashIntFloatMap newUpdatableMap(int expectedSize);

    


    @Override
     HashIntFloatMap newUpdatableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, int expectedSize);

    @Override
     HashIntFloatMap newUpdatableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3, int expectedSize);

    @Override
     HashIntFloatMap newUpdatableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4, int expectedSize);

    @Override
     HashIntFloatMap newUpdatableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4, Map<Integer, Float> map5, int expectedSize);

    

    
    @Override
     HashIntFloatMap newUpdatableMap(Map<Integer, Float> map);

    @Override
     HashIntFloatMap newUpdatableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2);

    @Override
     HashIntFloatMap newUpdatableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3);

    @Override
     HashIntFloatMap newUpdatableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4);

    @Override
     HashIntFloatMap newUpdatableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4, Map<Integer, Float> map5);


    @Override
     HashIntFloatMap newUpdatableMap(
            net.openhft.function.Consumer<IntFloatConsumer> entriesSupplier);

    @Override
     HashIntFloatMap newUpdatableMap(
            net.openhft.function.Consumer<IntFloatConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashIntFloatMap newUpdatableMap(int[] keys, float[] values);

    @Override
     HashIntFloatMap newUpdatableMap(int[] keys, float[] values,
            int expectedSize);

    @Override
     HashIntFloatMap newUpdatableMap(
            Integer[] keys, Float[] values);

    @Override
     HashIntFloatMap newUpdatableMap(
            Integer[] keys, Float[] values, int expectedSize);

    @Override
     HashIntFloatMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Float> values);

    @Override
     HashIntFloatMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Float> values, int expectedSize);


    @Override
     HashIntFloatMap newUpdatableMapOf(int k1, float v1);

    @Override
     HashIntFloatMap newUpdatableMapOf(int k1, float v1,
            int k2, float v2);

    @Override
     HashIntFloatMap newUpdatableMapOf(int k1, float v1,
            int k2, float v2, int k3, float v3);

    @Override
     HashIntFloatMap newUpdatableMapOf(int k1, float v1,
            int k2, float v2, int k3, float v3,
            int k4, float v4);

    @Override
     HashIntFloatMap newUpdatableMapOf(int k1, float v1,
            int k2, float v2, int k3, float v3,
            int k4, float v4, int k5, float v5);

    


    @Override
     HashIntFloatMap newImmutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, int expectedSize);

    @Override
     HashIntFloatMap newImmutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3, int expectedSize);

    @Override
     HashIntFloatMap newImmutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4, int expectedSize);

    @Override
     HashIntFloatMap newImmutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4, Map<Integer, Float> map5, int expectedSize);

    

    
    @Override
     HashIntFloatMap newImmutableMap(Map<Integer, Float> map);

    @Override
     HashIntFloatMap newImmutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2);

    @Override
     HashIntFloatMap newImmutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3);

    @Override
     HashIntFloatMap newImmutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4);

    @Override
     HashIntFloatMap newImmutableMap(Map<Integer, Float> map1,
            Map<Integer, Float> map2, Map<Integer, Float> map3,
            Map<Integer, Float> map4, Map<Integer, Float> map5);


    @Override
     HashIntFloatMap newImmutableMap(
            net.openhft.function.Consumer<IntFloatConsumer> entriesSupplier);

    @Override
     HashIntFloatMap newImmutableMap(
            net.openhft.function.Consumer<IntFloatConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashIntFloatMap newImmutableMap(int[] keys, float[] values);

    @Override
     HashIntFloatMap newImmutableMap(int[] keys, float[] values,
            int expectedSize);

    @Override
     HashIntFloatMap newImmutableMap(
            Integer[] keys, Float[] values);

    @Override
     HashIntFloatMap newImmutableMap(
            Integer[] keys, Float[] values, int expectedSize);

    @Override
     HashIntFloatMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Float> values);

    @Override
     HashIntFloatMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Float> values, int expectedSize);


    @Override
     HashIntFloatMap newImmutableMapOf(int k1, float v1);

    @Override
     HashIntFloatMap newImmutableMapOf(int k1, float v1,
            int k2, float v2);

    @Override
     HashIntFloatMap newImmutableMapOf(int k1, float v1,
            int k2, float v2, int k3, float v3);

    @Override
     HashIntFloatMap newImmutableMapOf(int k1, float v1,
            int k2, float v2, int k3, float v3,
            int k4, float v4);

    @Override
     HashIntFloatMap newImmutableMapOf(int k1, float v1,
            int k2, float v2, int k3, float v3,
            int k4, float v4, int k5, float v5);
}

