/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.IntDoubleConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashIntDoubleMap}s, and
 * the default {@link HashIntDoubleMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashIntDoubleMap
 */
public final class HashIntDoubleMaps {

    

    private static final ServiceLoader<HashIntDoubleMapFactory> LOADER =
            ServiceLoader.load(HashIntDoubleMapFactory.class);
    private static HashIntDoubleMapFactory defaultFactory = null;

    public static HashIntDoubleMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashIntDoubleMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashIntDoubleMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashIntDoubleMap newMutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashIntDoubleMap newMutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashIntDoubleMap newMutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashIntDoubleMap newMutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4, Map<Integer, Double> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashIntDoubleMap newMutableMap(
            Map<Integer, Double> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashIntDoubleMap newMutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashIntDoubleMap newMutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashIntDoubleMap newMutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashIntDoubleMap newMutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4, Map<Integer, Double> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashIntDoubleMap newMutableMap(
            net.openhft.function.Consumer<IntDoubleConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashIntDoubleMap newMutableMap(
            net.openhft.function.Consumer<IntDoubleConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashIntDoubleMap newMutableMap(
            int[] keys, double[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashIntDoubleMap newMutableMap(
            int[] keys, double[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashIntDoubleMap newMutableMap(
            Integer[] keys, Double[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashIntDoubleMap newMutableMap(
            Integer[] keys, Double[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashIntDoubleMap newMutableMap(Iterable<Integer> keys,
            Iterable<Double> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashIntDoubleMap newMutableMap(Iterable<Integer> keys,
            Iterable<Double> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashIntDoubleMap newMutableMapOf(
            int k1, double v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashIntDoubleMap newMutableMapOf(
            int k1, double v1, int k2, double v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashIntDoubleMap newMutableMapOf(
            int k1, double v1, int k2, double v2,
            int k3, double v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashIntDoubleMap newMutableMapOf(
            int k1, double v1, int k2, double v2,
            int k3, double v3, int k4, double v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashIntDoubleMap newMutableMapOf(
            int k1, double v1, int k2, double v2,
            int k3, double v3, int k4, double v4,
            int k5, double v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashIntDoubleMap newUpdatableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashIntDoubleMap newUpdatableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashIntDoubleMap newUpdatableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashIntDoubleMap newUpdatableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4, Map<Integer, Double> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashIntDoubleMap newUpdatableMap(
            Map<Integer, Double> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashIntDoubleMap newUpdatableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashIntDoubleMap newUpdatableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashIntDoubleMap newUpdatableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashIntDoubleMap newUpdatableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4, Map<Integer, Double> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashIntDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<IntDoubleConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashIntDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<IntDoubleConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashIntDoubleMap newUpdatableMap(
            int[] keys, double[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashIntDoubleMap newUpdatableMap(
            int[] keys, double[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashIntDoubleMap newUpdatableMap(
            Integer[] keys, Double[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashIntDoubleMap newUpdatableMap(
            Integer[] keys, Double[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashIntDoubleMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Double> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashIntDoubleMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Double> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashIntDoubleMap newUpdatableMapOf(
            int k1, double v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashIntDoubleMap newUpdatableMapOf(
            int k1, double v1, int k2, double v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashIntDoubleMap newUpdatableMapOf(
            int k1, double v1, int k2, double v2,
            int k3, double v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashIntDoubleMap newUpdatableMapOf(
            int k1, double v1, int k2, double v2,
            int k3, double v3, int k4, double v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashIntDoubleMap newUpdatableMapOf(
            int k1, double v1, int k2, double v2,
            int k3, double v3, int k4, double v4,
            int k5, double v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashIntDoubleMap newImmutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashIntDoubleMap newImmutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashIntDoubleMap newImmutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashIntDoubleMap newImmutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4, Map<Integer, Double> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashIntDoubleMap newImmutableMap(
            Map<Integer, Double> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashIntDoubleMap newImmutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashIntDoubleMap newImmutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashIntDoubleMap newImmutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashIntDoubleMap newImmutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4, Map<Integer, Double> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashIntDoubleMap newImmutableMap(
            net.openhft.function.Consumer<IntDoubleConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashIntDoubleMap newImmutableMap(
            net.openhft.function.Consumer<IntDoubleConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashIntDoubleMap newImmutableMap(
            int[] keys, double[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashIntDoubleMap newImmutableMap(
            int[] keys, double[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashIntDoubleMap newImmutableMap(
            Integer[] keys, Double[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashIntDoubleMap newImmutableMap(
            Integer[] keys, Double[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashIntDoubleMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Double> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashIntDoubleMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Double> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashIntDoubleMap newImmutableMapOf(
            int k1, double v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashIntDoubleMap newImmutableMapOf(
            int k1, double v1, int k2, double v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashIntDoubleMap newImmutableMapOf(
            int k1, double v1, int k2, double v2,
            int k3, double v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashIntDoubleMap newImmutableMapOf(
            int k1, double v1, int k2, double v2,
            int k3, double v3, int k4, double v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashIntDoubleMap newImmutableMapOf(
            int k1, double v1, int k2, double v2,
            int k3, double v3, int k4, double v4,
            int k5, double v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashIntDoubleMaps() {}
}

