/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.IntDoubleConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashIntDoubleMaps}
 *
 * @see HashIntDoubleMap
 * @see HashIntDoubleMaps#getDefaultFactory()
 */
public interface HashIntDoubleMapFactory extends IntDoubleMapFactory
        , IntHashFactory<HashIntDoubleMapFactory>
         {

    

    

    

    

    

    
    

    
    


    @Override
    HashIntDoubleMapFactory withDefaultValue(double defaultValue);

    @Override
     HashIntDoubleMap newMutableMap();

    @Override
     HashIntDoubleMap newMutableMap(int expectedSize);

    


    @Override
     HashIntDoubleMap newMutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, int expectedSize);

    @Override
     HashIntDoubleMap newMutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3, int expectedSize);

    @Override
     HashIntDoubleMap newMutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4, int expectedSize);

    @Override
     HashIntDoubleMap newMutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4, Map<Integer, Double> map5, int expectedSize);

    

    
    @Override
     HashIntDoubleMap newMutableMap(Map<Integer, Double> map);

    @Override
     HashIntDoubleMap newMutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2);

    @Override
     HashIntDoubleMap newMutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3);

    @Override
     HashIntDoubleMap newMutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4);

    @Override
     HashIntDoubleMap newMutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4, Map<Integer, Double> map5);


    @Override
     HashIntDoubleMap newMutableMap(
            net.openhft.function.Consumer<IntDoubleConsumer> entriesSupplier);

    @Override
     HashIntDoubleMap newMutableMap(
            net.openhft.function.Consumer<IntDoubleConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashIntDoubleMap newMutableMap(int[] keys, double[] values);

    @Override
     HashIntDoubleMap newMutableMap(int[] keys, double[] values,
            int expectedSize);

    @Override
     HashIntDoubleMap newMutableMap(
            Integer[] keys, Double[] values);

    @Override
     HashIntDoubleMap newMutableMap(
            Integer[] keys, Double[] values, int expectedSize);

    @Override
     HashIntDoubleMap newMutableMap(Iterable<Integer> keys,
            Iterable<Double> values);

    @Override
     HashIntDoubleMap newMutableMap(Iterable<Integer> keys,
            Iterable<Double> values, int expectedSize);


    @Override
     HashIntDoubleMap newMutableMapOf(int k1, double v1);

    @Override
     HashIntDoubleMap newMutableMapOf(int k1, double v1,
            int k2, double v2);

    @Override
     HashIntDoubleMap newMutableMapOf(int k1, double v1,
            int k2, double v2, int k3, double v3);

    @Override
     HashIntDoubleMap newMutableMapOf(int k1, double v1,
            int k2, double v2, int k3, double v3,
            int k4, double v4);

    @Override
     HashIntDoubleMap newMutableMapOf(int k1, double v1,
            int k2, double v2, int k3, double v3,
            int k4, double v4, int k5, double v5);
    @Override
     HashIntDoubleMap newUpdatableMap();

    @Override
     HashIntDoubleMap newUpdatableMap(int expectedSize);

    


    @Override
     HashIntDoubleMap newUpdatableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, int expectedSize);

    @Override
     HashIntDoubleMap newUpdatableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3, int expectedSize);

    @Override
     HashIntDoubleMap newUpdatableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4, int expectedSize);

    @Override
     HashIntDoubleMap newUpdatableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4, Map<Integer, Double> map5, int expectedSize);

    

    
    @Override
     HashIntDoubleMap newUpdatableMap(Map<Integer, Double> map);

    @Override
     HashIntDoubleMap newUpdatableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2);

    @Override
     HashIntDoubleMap newUpdatableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3);

    @Override
     HashIntDoubleMap newUpdatableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4);

    @Override
     HashIntDoubleMap newUpdatableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4, Map<Integer, Double> map5);


    @Override
     HashIntDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<IntDoubleConsumer> entriesSupplier);

    @Override
     HashIntDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<IntDoubleConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashIntDoubleMap newUpdatableMap(int[] keys, double[] values);

    @Override
     HashIntDoubleMap newUpdatableMap(int[] keys, double[] values,
            int expectedSize);

    @Override
     HashIntDoubleMap newUpdatableMap(
            Integer[] keys, Double[] values);

    @Override
     HashIntDoubleMap newUpdatableMap(
            Integer[] keys, Double[] values, int expectedSize);

    @Override
     HashIntDoubleMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Double> values);

    @Override
     HashIntDoubleMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Double> values, int expectedSize);


    @Override
     HashIntDoubleMap newUpdatableMapOf(int k1, double v1);

    @Override
     HashIntDoubleMap newUpdatableMapOf(int k1, double v1,
            int k2, double v2);

    @Override
     HashIntDoubleMap newUpdatableMapOf(int k1, double v1,
            int k2, double v2, int k3, double v3);

    @Override
     HashIntDoubleMap newUpdatableMapOf(int k1, double v1,
            int k2, double v2, int k3, double v3,
            int k4, double v4);

    @Override
     HashIntDoubleMap newUpdatableMapOf(int k1, double v1,
            int k2, double v2, int k3, double v3,
            int k4, double v4, int k5, double v5);

    


    @Override
     HashIntDoubleMap newImmutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, int expectedSize);

    @Override
     HashIntDoubleMap newImmutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3, int expectedSize);

    @Override
     HashIntDoubleMap newImmutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4, int expectedSize);

    @Override
     HashIntDoubleMap newImmutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4, Map<Integer, Double> map5, int expectedSize);

    

    
    @Override
     HashIntDoubleMap newImmutableMap(Map<Integer, Double> map);

    @Override
     HashIntDoubleMap newImmutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2);

    @Override
     HashIntDoubleMap newImmutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3);

    @Override
     HashIntDoubleMap newImmutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4);

    @Override
     HashIntDoubleMap newImmutableMap(Map<Integer, Double> map1,
            Map<Integer, Double> map2, Map<Integer, Double> map3,
            Map<Integer, Double> map4, Map<Integer, Double> map5);


    @Override
     HashIntDoubleMap newImmutableMap(
            net.openhft.function.Consumer<IntDoubleConsumer> entriesSupplier);

    @Override
     HashIntDoubleMap newImmutableMap(
            net.openhft.function.Consumer<IntDoubleConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashIntDoubleMap newImmutableMap(int[] keys, double[] values);

    @Override
     HashIntDoubleMap newImmutableMap(int[] keys, double[] values,
            int expectedSize);

    @Override
     HashIntDoubleMap newImmutableMap(
            Integer[] keys, Double[] values);

    @Override
     HashIntDoubleMap newImmutableMap(
            Integer[] keys, Double[] values, int expectedSize);

    @Override
     HashIntDoubleMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Double> values);

    @Override
     HashIntDoubleMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Double> values, int expectedSize);


    @Override
     HashIntDoubleMap newImmutableMapOf(int k1, double v1);

    @Override
     HashIntDoubleMap newImmutableMapOf(int k1, double v1,
            int k2, double v2);

    @Override
     HashIntDoubleMap newImmutableMapOf(int k1, double v1,
            int k2, double v2, int k3, double v3);

    @Override
     HashIntDoubleMap newImmutableMapOf(int k1, double v1,
            int k2, double v2, int k3, double v3,
            int k4, double v4);

    @Override
     HashIntDoubleMap newImmutableMapOf(int k1, double v1,
            int k2, double v2, int k3, double v3,
            int k4, double v4, int k5, double v5);
}

