/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.IntCharConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashIntCharMaps}
 *
 * @see HashIntCharMap
 * @see HashIntCharMaps#getDefaultFactory()
 */
public interface HashIntCharMapFactory extends IntCharMapFactory
        , IntHashFactory<HashIntCharMapFactory>
         {

    

    

    

    

    

    
    

    
    


    @Override
    HashIntCharMapFactory withDefaultValue(char defaultValue);

    @Override
     HashIntCharMap newMutableMap();

    @Override
     HashIntCharMap newMutableMap(int expectedSize);

    


    @Override
     HashIntCharMap newMutableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, int expectedSize);

    @Override
     HashIntCharMap newMutableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3, int expectedSize);

    @Override
     HashIntCharMap newMutableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3,
            Map<Integer, Character> map4, int expectedSize);

    @Override
     HashIntCharMap newMutableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3,
            Map<Integer, Character> map4, Map<Integer, Character> map5, int expectedSize);

    

    
    @Override
     HashIntCharMap newMutableMap(Map<Integer, Character> map);

    @Override
     HashIntCharMap newMutableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2);

    @Override
     HashIntCharMap newMutableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3);

    @Override
     HashIntCharMap newMutableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3,
            Map<Integer, Character> map4);

    @Override
     HashIntCharMap newMutableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3,
            Map<Integer, Character> map4, Map<Integer, Character> map5);


    @Override
     HashIntCharMap newMutableMap(
            net.openhft.function.Consumer<IntCharConsumer> entriesSupplier);

    @Override
     HashIntCharMap newMutableMap(
            net.openhft.function.Consumer<IntCharConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashIntCharMap newMutableMap(int[] keys, char[] values);

    @Override
     HashIntCharMap newMutableMap(int[] keys, char[] values,
            int expectedSize);

    @Override
     HashIntCharMap newMutableMap(
            Integer[] keys, Character[] values);

    @Override
     HashIntCharMap newMutableMap(
            Integer[] keys, Character[] values, int expectedSize);

    @Override
     HashIntCharMap newMutableMap(Iterable<Integer> keys,
            Iterable<Character> values);

    @Override
     HashIntCharMap newMutableMap(Iterable<Integer> keys,
            Iterable<Character> values, int expectedSize);


    @Override
     HashIntCharMap newMutableMapOf(int k1, char v1);

    @Override
     HashIntCharMap newMutableMapOf(int k1, char v1,
            int k2, char v2);

    @Override
     HashIntCharMap newMutableMapOf(int k1, char v1,
            int k2, char v2, int k3, char v3);

    @Override
     HashIntCharMap newMutableMapOf(int k1, char v1,
            int k2, char v2, int k3, char v3,
            int k4, char v4);

    @Override
     HashIntCharMap newMutableMapOf(int k1, char v1,
            int k2, char v2, int k3, char v3,
            int k4, char v4, int k5, char v5);
    @Override
     HashIntCharMap newUpdatableMap();

    @Override
     HashIntCharMap newUpdatableMap(int expectedSize);

    


    @Override
     HashIntCharMap newUpdatableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, int expectedSize);

    @Override
     HashIntCharMap newUpdatableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3, int expectedSize);

    @Override
     HashIntCharMap newUpdatableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3,
            Map<Integer, Character> map4, int expectedSize);

    @Override
     HashIntCharMap newUpdatableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3,
            Map<Integer, Character> map4, Map<Integer, Character> map5, int expectedSize);

    

    
    @Override
     HashIntCharMap newUpdatableMap(Map<Integer, Character> map);

    @Override
     HashIntCharMap newUpdatableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2);

    @Override
     HashIntCharMap newUpdatableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3);

    @Override
     HashIntCharMap newUpdatableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3,
            Map<Integer, Character> map4);

    @Override
     HashIntCharMap newUpdatableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3,
            Map<Integer, Character> map4, Map<Integer, Character> map5);


    @Override
     HashIntCharMap newUpdatableMap(
            net.openhft.function.Consumer<IntCharConsumer> entriesSupplier);

    @Override
     HashIntCharMap newUpdatableMap(
            net.openhft.function.Consumer<IntCharConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashIntCharMap newUpdatableMap(int[] keys, char[] values);

    @Override
     HashIntCharMap newUpdatableMap(int[] keys, char[] values,
            int expectedSize);

    @Override
     HashIntCharMap newUpdatableMap(
            Integer[] keys, Character[] values);

    @Override
     HashIntCharMap newUpdatableMap(
            Integer[] keys, Character[] values, int expectedSize);

    @Override
     HashIntCharMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Character> values);

    @Override
     HashIntCharMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Character> values, int expectedSize);


    @Override
     HashIntCharMap newUpdatableMapOf(int k1, char v1);

    @Override
     HashIntCharMap newUpdatableMapOf(int k1, char v1,
            int k2, char v2);

    @Override
     HashIntCharMap newUpdatableMapOf(int k1, char v1,
            int k2, char v2, int k3, char v3);

    @Override
     HashIntCharMap newUpdatableMapOf(int k1, char v1,
            int k2, char v2, int k3, char v3,
            int k4, char v4);

    @Override
     HashIntCharMap newUpdatableMapOf(int k1, char v1,
            int k2, char v2, int k3, char v3,
            int k4, char v4, int k5, char v5);

    


    @Override
     HashIntCharMap newImmutableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, int expectedSize);

    @Override
     HashIntCharMap newImmutableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3, int expectedSize);

    @Override
     HashIntCharMap newImmutableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3,
            Map<Integer, Character> map4, int expectedSize);

    @Override
     HashIntCharMap newImmutableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3,
            Map<Integer, Character> map4, Map<Integer, Character> map5, int expectedSize);

    

    
    @Override
     HashIntCharMap newImmutableMap(Map<Integer, Character> map);

    @Override
     HashIntCharMap newImmutableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2);

    @Override
     HashIntCharMap newImmutableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3);

    @Override
     HashIntCharMap newImmutableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3,
            Map<Integer, Character> map4);

    @Override
     HashIntCharMap newImmutableMap(Map<Integer, Character> map1,
            Map<Integer, Character> map2, Map<Integer, Character> map3,
            Map<Integer, Character> map4, Map<Integer, Character> map5);


    @Override
     HashIntCharMap newImmutableMap(
            net.openhft.function.Consumer<IntCharConsumer> entriesSupplier);

    @Override
     HashIntCharMap newImmutableMap(
            net.openhft.function.Consumer<IntCharConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashIntCharMap newImmutableMap(int[] keys, char[] values);

    @Override
     HashIntCharMap newImmutableMap(int[] keys, char[] values,
            int expectedSize);

    @Override
     HashIntCharMap newImmutableMap(
            Integer[] keys, Character[] values);

    @Override
     HashIntCharMap newImmutableMap(
            Integer[] keys, Character[] values, int expectedSize);

    @Override
     HashIntCharMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Character> values);

    @Override
     HashIntCharMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Character> values, int expectedSize);


    @Override
     HashIntCharMap newImmutableMapOf(int k1, char v1);

    @Override
     HashIntCharMap newImmutableMapOf(int k1, char v1,
            int k2, char v2);

    @Override
     HashIntCharMap newImmutableMapOf(int k1, char v1,
            int k2, char v2, int k3, char v3);

    @Override
     HashIntCharMap newImmutableMapOf(int k1, char v1,
            int k2, char v2, int k3, char v3,
            int k4, char v4);

    @Override
     HashIntCharMap newImmutableMapOf(int k1, char v1,
            int k2, char v2, int k3, char v3,
            int k4, char v4, int k5, char v5);
}

