/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.IntByteConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashIntByteMap}s, and
 * the default {@link HashIntByteMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashIntByteMap
 */
public final class HashIntByteMaps {

    

    private static final ServiceLoader<HashIntByteMapFactory> LOADER =
            ServiceLoader.load(HashIntByteMapFactory.class);
    private static HashIntByteMapFactory defaultFactory = null;

    public static HashIntByteMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashIntByteMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashIntByteMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashIntByteMap newMutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashIntByteMap newMutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashIntByteMap newMutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashIntByteMap newMutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4, Map<Integer, Byte> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashIntByteMap newMutableMap(
            Map<Integer, Byte> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashIntByteMap newMutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashIntByteMap newMutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashIntByteMap newMutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashIntByteMap newMutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4, Map<Integer, Byte> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashIntByteMap newMutableMap(
            net.openhft.function.Consumer<IntByteConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashIntByteMap newMutableMap(
            net.openhft.function.Consumer<IntByteConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashIntByteMap newMutableMap(
            int[] keys, byte[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashIntByteMap newMutableMap(
            int[] keys, byte[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashIntByteMap newMutableMap(
            Integer[] keys, Byte[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashIntByteMap newMutableMap(
            Integer[] keys, Byte[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashIntByteMap newMutableMap(Iterable<Integer> keys,
            Iterable<Byte> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashIntByteMap newMutableMap(Iterable<Integer> keys,
            Iterable<Byte> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashIntByteMap newMutableMapOf(
            int k1, byte v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashIntByteMap newMutableMapOf(
            int k1, byte v1, int k2, byte v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashIntByteMap newMutableMapOf(
            int k1, byte v1, int k2, byte v2,
            int k3, byte v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashIntByteMap newMutableMapOf(
            int k1, byte v1, int k2, byte v2,
            int k3, byte v3, int k4, byte v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashIntByteMap newMutableMapOf(
            int k1, byte v1, int k2, byte v2,
            int k3, byte v3, int k4, byte v4,
            int k5, byte v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashIntByteMap newUpdatableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashIntByteMap newUpdatableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashIntByteMap newUpdatableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashIntByteMap newUpdatableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4, Map<Integer, Byte> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashIntByteMap newUpdatableMap(
            Map<Integer, Byte> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashIntByteMap newUpdatableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashIntByteMap newUpdatableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashIntByteMap newUpdatableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashIntByteMap newUpdatableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4, Map<Integer, Byte> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashIntByteMap newUpdatableMap(
            net.openhft.function.Consumer<IntByteConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashIntByteMap newUpdatableMap(
            net.openhft.function.Consumer<IntByteConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashIntByteMap newUpdatableMap(
            int[] keys, byte[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashIntByteMap newUpdatableMap(
            int[] keys, byte[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashIntByteMap newUpdatableMap(
            Integer[] keys, Byte[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashIntByteMap newUpdatableMap(
            Integer[] keys, Byte[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashIntByteMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Byte> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashIntByteMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Byte> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashIntByteMap newUpdatableMapOf(
            int k1, byte v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashIntByteMap newUpdatableMapOf(
            int k1, byte v1, int k2, byte v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashIntByteMap newUpdatableMapOf(
            int k1, byte v1, int k2, byte v2,
            int k3, byte v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashIntByteMap newUpdatableMapOf(
            int k1, byte v1, int k2, byte v2,
            int k3, byte v3, int k4, byte v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashIntByteMap newUpdatableMapOf(
            int k1, byte v1, int k2, byte v2,
            int k3, byte v3, int k4, byte v4,
            int k5, byte v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashIntByteMap newImmutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashIntByteMap newImmutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashIntByteMap newImmutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashIntByteMap newImmutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4, Map<Integer, Byte> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashIntByteMap newImmutableMap(
            Map<Integer, Byte> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashIntByteMap newImmutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashIntByteMap newImmutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashIntByteMap newImmutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashIntByteMap newImmutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4, Map<Integer, Byte> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashIntByteMap newImmutableMap(
            net.openhft.function.Consumer<IntByteConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashIntByteMap newImmutableMap(
            net.openhft.function.Consumer<IntByteConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashIntByteMap newImmutableMap(
            int[] keys, byte[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashIntByteMap newImmutableMap(
            int[] keys, byte[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashIntByteMap newImmutableMap(
            Integer[] keys, Byte[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashIntByteMap newImmutableMap(
            Integer[] keys, Byte[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashIntByteMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Byte> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashIntByteMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Byte> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashIntByteMap newImmutableMapOf(
            int k1, byte v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashIntByteMap newImmutableMapOf(
            int k1, byte v1, int k2, byte v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashIntByteMap newImmutableMapOf(
            int k1, byte v1, int k2, byte v2,
            int k3, byte v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashIntByteMap newImmutableMapOf(
            int k1, byte v1, int k2, byte v2,
            int k3, byte v3, int k4, byte v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashIntByteMap newImmutableMapOf(
            int k1, byte v1, int k2, byte v2,
            int k3, byte v3, int k4, byte v4,
            int k5, byte v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashIntByteMaps() {}
}

