/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.IntByteConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashIntByteMaps}
 *
 * @see HashIntByteMap
 * @see HashIntByteMaps#getDefaultFactory()
 */
public interface HashIntByteMapFactory extends IntByteMapFactory
        , IntHashFactory<HashIntByteMapFactory>
         {

    

    

    

    

    

    
    

    
    


    @Override
    HashIntByteMapFactory withDefaultValue(byte defaultValue);

    @Override
     HashIntByteMap newMutableMap();

    @Override
     HashIntByteMap newMutableMap(int expectedSize);

    


    @Override
     HashIntByteMap newMutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, int expectedSize);

    @Override
     HashIntByteMap newMutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3, int expectedSize);

    @Override
     HashIntByteMap newMutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4, int expectedSize);

    @Override
     HashIntByteMap newMutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4, Map<Integer, Byte> map5, int expectedSize);

    

    
    @Override
     HashIntByteMap newMutableMap(Map<Integer, Byte> map);

    @Override
     HashIntByteMap newMutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2);

    @Override
     HashIntByteMap newMutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3);

    @Override
     HashIntByteMap newMutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4);

    @Override
     HashIntByteMap newMutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4, Map<Integer, Byte> map5);


    @Override
     HashIntByteMap newMutableMap(
            net.openhft.function.Consumer<IntByteConsumer> entriesSupplier);

    @Override
     HashIntByteMap newMutableMap(
            net.openhft.function.Consumer<IntByteConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashIntByteMap newMutableMap(int[] keys, byte[] values);

    @Override
     HashIntByteMap newMutableMap(int[] keys, byte[] values,
            int expectedSize);

    @Override
     HashIntByteMap newMutableMap(
            Integer[] keys, Byte[] values);

    @Override
     HashIntByteMap newMutableMap(
            Integer[] keys, Byte[] values, int expectedSize);

    @Override
     HashIntByteMap newMutableMap(Iterable<Integer> keys,
            Iterable<Byte> values);

    @Override
     HashIntByteMap newMutableMap(Iterable<Integer> keys,
            Iterable<Byte> values, int expectedSize);


    @Override
     HashIntByteMap newMutableMapOf(int k1, byte v1);

    @Override
     HashIntByteMap newMutableMapOf(int k1, byte v1,
            int k2, byte v2);

    @Override
     HashIntByteMap newMutableMapOf(int k1, byte v1,
            int k2, byte v2, int k3, byte v3);

    @Override
     HashIntByteMap newMutableMapOf(int k1, byte v1,
            int k2, byte v2, int k3, byte v3,
            int k4, byte v4);

    @Override
     HashIntByteMap newMutableMapOf(int k1, byte v1,
            int k2, byte v2, int k3, byte v3,
            int k4, byte v4, int k5, byte v5);
    @Override
     HashIntByteMap newUpdatableMap();

    @Override
     HashIntByteMap newUpdatableMap(int expectedSize);

    


    @Override
     HashIntByteMap newUpdatableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, int expectedSize);

    @Override
     HashIntByteMap newUpdatableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3, int expectedSize);

    @Override
     HashIntByteMap newUpdatableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4, int expectedSize);

    @Override
     HashIntByteMap newUpdatableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4, Map<Integer, Byte> map5, int expectedSize);

    

    
    @Override
     HashIntByteMap newUpdatableMap(Map<Integer, Byte> map);

    @Override
     HashIntByteMap newUpdatableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2);

    @Override
     HashIntByteMap newUpdatableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3);

    @Override
     HashIntByteMap newUpdatableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4);

    @Override
     HashIntByteMap newUpdatableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4, Map<Integer, Byte> map5);


    @Override
     HashIntByteMap newUpdatableMap(
            net.openhft.function.Consumer<IntByteConsumer> entriesSupplier);

    @Override
     HashIntByteMap newUpdatableMap(
            net.openhft.function.Consumer<IntByteConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashIntByteMap newUpdatableMap(int[] keys, byte[] values);

    @Override
     HashIntByteMap newUpdatableMap(int[] keys, byte[] values,
            int expectedSize);

    @Override
     HashIntByteMap newUpdatableMap(
            Integer[] keys, Byte[] values);

    @Override
     HashIntByteMap newUpdatableMap(
            Integer[] keys, Byte[] values, int expectedSize);

    @Override
     HashIntByteMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Byte> values);

    @Override
     HashIntByteMap newUpdatableMap(Iterable<Integer> keys,
            Iterable<Byte> values, int expectedSize);


    @Override
     HashIntByteMap newUpdatableMapOf(int k1, byte v1);

    @Override
     HashIntByteMap newUpdatableMapOf(int k1, byte v1,
            int k2, byte v2);

    @Override
     HashIntByteMap newUpdatableMapOf(int k1, byte v1,
            int k2, byte v2, int k3, byte v3);

    @Override
     HashIntByteMap newUpdatableMapOf(int k1, byte v1,
            int k2, byte v2, int k3, byte v3,
            int k4, byte v4);

    @Override
     HashIntByteMap newUpdatableMapOf(int k1, byte v1,
            int k2, byte v2, int k3, byte v3,
            int k4, byte v4, int k5, byte v5);

    


    @Override
     HashIntByteMap newImmutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, int expectedSize);

    @Override
     HashIntByteMap newImmutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3, int expectedSize);

    @Override
     HashIntByteMap newImmutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4, int expectedSize);

    @Override
     HashIntByteMap newImmutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4, Map<Integer, Byte> map5, int expectedSize);

    

    
    @Override
     HashIntByteMap newImmutableMap(Map<Integer, Byte> map);

    @Override
     HashIntByteMap newImmutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2);

    @Override
     HashIntByteMap newImmutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3);

    @Override
     HashIntByteMap newImmutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4);

    @Override
     HashIntByteMap newImmutableMap(Map<Integer, Byte> map1,
            Map<Integer, Byte> map2, Map<Integer, Byte> map3,
            Map<Integer, Byte> map4, Map<Integer, Byte> map5);


    @Override
     HashIntByteMap newImmutableMap(
            net.openhft.function.Consumer<IntByteConsumer> entriesSupplier);

    @Override
     HashIntByteMap newImmutableMap(
            net.openhft.function.Consumer<IntByteConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashIntByteMap newImmutableMap(int[] keys, byte[] values);

    @Override
     HashIntByteMap newImmutableMap(int[] keys, byte[] values,
            int expectedSize);

    @Override
     HashIntByteMap newImmutableMap(
            Integer[] keys, Byte[] values);

    @Override
     HashIntByteMap newImmutableMap(
            Integer[] keys, Byte[] values, int expectedSize);

    @Override
     HashIntByteMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Byte> values);

    @Override
     HashIntByteMap newImmutableMap(Iterable<Integer> keys,
            Iterable<Byte> values, int expectedSize);


    @Override
     HashIntByteMap newImmutableMapOf(int k1, byte v1);

    @Override
     HashIntByteMap newImmutableMapOf(int k1, byte v1,
            int k2, byte v2);

    @Override
     HashIntByteMap newImmutableMapOf(int k1, byte v1,
            int k2, byte v2, int k3, byte v3);

    @Override
     HashIntByteMap newImmutableMapOf(int k1, byte v1,
            int k2, byte v2, int k3, byte v3,
            int k4, byte v4);

    @Override
     HashIntByteMap newImmutableMapOf(int k1, byte v1,
            int k2, byte v2, int k3, byte v3,
            int k4, byte v4, int k5, byte v5);
}

