/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.FloatShortConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashFloatShortMap}s, and
 * the default {@link HashFloatShortMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashFloatShortMap
 */
public final class HashFloatShortMaps {

    

    private static final ServiceLoader<HashFloatShortMapFactory> LOADER =
            ServiceLoader.load(HashFloatShortMapFactory.class);
    private static HashFloatShortMapFactory defaultFactory = null;

    public static HashFloatShortMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashFloatShortMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashFloatShortMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashFloatShortMap newMutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashFloatShortMap newMutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashFloatShortMap newMutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashFloatShortMap newMutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4, Map<Float, Short> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashFloatShortMap newMutableMap(
            Map<Float, Short> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashFloatShortMap newMutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashFloatShortMap newMutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashFloatShortMap newMutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashFloatShortMap newMutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4, Map<Float, Short> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashFloatShortMap newMutableMap(
            net.openhft.function.Consumer<FloatShortConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashFloatShortMap newMutableMap(
            net.openhft.function.Consumer<FloatShortConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashFloatShortMap newMutableMap(
            float[] keys, short[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashFloatShortMap newMutableMap(
            float[] keys, short[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashFloatShortMap newMutableMap(
            Float[] keys, Short[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashFloatShortMap newMutableMap(
            Float[] keys, Short[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashFloatShortMap newMutableMap(Iterable<Float> keys,
            Iterable<Short> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashFloatShortMap newMutableMap(Iterable<Float> keys,
            Iterable<Short> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashFloatShortMap newMutableMapOf(
            float k1, short v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashFloatShortMap newMutableMapOf(
            float k1, short v1, float k2, short v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashFloatShortMap newMutableMapOf(
            float k1, short v1, float k2, short v2,
            float k3, short v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashFloatShortMap newMutableMapOf(
            float k1, short v1, float k2, short v2,
            float k3, short v3, float k4, short v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashFloatShortMap newMutableMapOf(
            float k1, short v1, float k2, short v2,
            float k3, short v3, float k4, short v4,
            float k5, short v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashFloatShortMap newUpdatableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashFloatShortMap newUpdatableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashFloatShortMap newUpdatableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashFloatShortMap newUpdatableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4, Map<Float, Short> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashFloatShortMap newUpdatableMap(
            Map<Float, Short> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashFloatShortMap newUpdatableMap(Map<Float, Short> map1,
            Map<Float, Short> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashFloatShortMap newUpdatableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashFloatShortMap newUpdatableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashFloatShortMap newUpdatableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4, Map<Float, Short> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashFloatShortMap newUpdatableMap(
            net.openhft.function.Consumer<FloatShortConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashFloatShortMap newUpdatableMap(
            net.openhft.function.Consumer<FloatShortConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashFloatShortMap newUpdatableMap(
            float[] keys, short[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashFloatShortMap newUpdatableMap(
            float[] keys, short[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashFloatShortMap newUpdatableMap(
            Float[] keys, Short[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashFloatShortMap newUpdatableMap(
            Float[] keys, Short[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashFloatShortMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Short> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashFloatShortMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Short> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashFloatShortMap newUpdatableMapOf(
            float k1, short v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashFloatShortMap newUpdatableMapOf(
            float k1, short v1, float k2, short v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashFloatShortMap newUpdatableMapOf(
            float k1, short v1, float k2, short v2,
            float k3, short v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashFloatShortMap newUpdatableMapOf(
            float k1, short v1, float k2, short v2,
            float k3, short v3, float k4, short v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashFloatShortMap newUpdatableMapOf(
            float k1, short v1, float k2, short v2,
            float k3, short v3, float k4, short v4,
            float k5, short v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashFloatShortMap newImmutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashFloatShortMap newImmutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashFloatShortMap newImmutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashFloatShortMap newImmutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4, Map<Float, Short> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashFloatShortMap newImmutableMap(
            Map<Float, Short> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashFloatShortMap newImmutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashFloatShortMap newImmutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashFloatShortMap newImmutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashFloatShortMap newImmutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4, Map<Float, Short> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashFloatShortMap newImmutableMap(
            net.openhft.function.Consumer<FloatShortConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashFloatShortMap newImmutableMap(
            net.openhft.function.Consumer<FloatShortConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashFloatShortMap newImmutableMap(
            float[] keys, short[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashFloatShortMap newImmutableMap(
            float[] keys, short[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashFloatShortMap newImmutableMap(
            Float[] keys, Short[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashFloatShortMap newImmutableMap(
            Float[] keys, Short[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashFloatShortMap newImmutableMap(Iterable<Float> keys,
            Iterable<Short> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashFloatShortMap newImmutableMap(Iterable<Float> keys,
            Iterable<Short> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashFloatShortMap newImmutableMapOf(
            float k1, short v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashFloatShortMap newImmutableMapOf(
            float k1, short v1, float k2, short v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashFloatShortMap newImmutableMapOf(
            float k1, short v1, float k2, short v2,
            float k3, short v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashFloatShortMap newImmutableMapOf(
            float k1, short v1, float k2, short v2,
            float k3, short v3, float k4, short v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashFloatShortMap newImmutableMapOf(
            float k1, short v1, float k2, short v2,
            float k3, short v3, float k4, short v4,
            float k5, short v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashFloatShortMaps() {}
}

