/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.FloatShortConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashFloatShortMaps}
 *
 * @see HashFloatShortMap
 * @see HashFloatShortMaps#getDefaultFactory()
 */
public interface HashFloatShortMapFactory extends FloatShortMapFactory
        , HashContainerFactory<HashFloatShortMapFactory> {

    

    

    

    

    

    
    

    
    


    @Override
    HashFloatShortMapFactory withDefaultValue(short defaultValue);

    @Override
     HashFloatShortMap newMutableMap();

    @Override
     HashFloatShortMap newMutableMap(int expectedSize);

    


    @Override
     HashFloatShortMap newMutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, int expectedSize);

    @Override
     HashFloatShortMap newMutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3, int expectedSize);

    @Override
     HashFloatShortMap newMutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4, int expectedSize);

    @Override
     HashFloatShortMap newMutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4, Map<Float, Short> map5, int expectedSize);

    

    
    @Override
     HashFloatShortMap newMutableMap(Map<Float, Short> map);

    @Override
     HashFloatShortMap newMutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2);

    @Override
     HashFloatShortMap newMutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3);

    @Override
     HashFloatShortMap newMutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4);

    @Override
     HashFloatShortMap newMutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4, Map<Float, Short> map5);


    @Override
     HashFloatShortMap newMutableMap(
            net.openhft.function.Consumer<FloatShortConsumer> entriesSupplier);

    @Override
     HashFloatShortMap newMutableMap(
            net.openhft.function.Consumer<FloatShortConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashFloatShortMap newMutableMap(float[] keys, short[] values);

    @Override
     HashFloatShortMap newMutableMap(float[] keys, short[] values,
            int expectedSize);

    @Override
     HashFloatShortMap newMutableMap(
            Float[] keys, Short[] values);

    @Override
     HashFloatShortMap newMutableMap(
            Float[] keys, Short[] values, int expectedSize);

    @Override
     HashFloatShortMap newMutableMap(Iterable<Float> keys,
            Iterable<Short> values);

    @Override
     HashFloatShortMap newMutableMap(Iterable<Float> keys,
            Iterable<Short> values, int expectedSize);


    @Override
     HashFloatShortMap newMutableMapOf(float k1, short v1);

    @Override
     HashFloatShortMap newMutableMapOf(float k1, short v1,
            float k2, short v2);

    @Override
     HashFloatShortMap newMutableMapOf(float k1, short v1,
            float k2, short v2, float k3, short v3);

    @Override
     HashFloatShortMap newMutableMapOf(float k1, short v1,
            float k2, short v2, float k3, short v3,
            float k4, short v4);

    @Override
     HashFloatShortMap newMutableMapOf(float k1, short v1,
            float k2, short v2, float k3, short v3,
            float k4, short v4, float k5, short v5);
    @Override
     HashFloatShortMap newUpdatableMap();

    @Override
     HashFloatShortMap newUpdatableMap(int expectedSize);

    


    @Override
     HashFloatShortMap newUpdatableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, int expectedSize);

    @Override
     HashFloatShortMap newUpdatableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3, int expectedSize);

    @Override
     HashFloatShortMap newUpdatableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4, int expectedSize);

    @Override
     HashFloatShortMap newUpdatableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4, Map<Float, Short> map5, int expectedSize);

    

    
    @Override
     HashFloatShortMap newUpdatableMap(Map<Float, Short> map);

    @Override
     HashFloatShortMap newUpdatableMap(Map<Float, Short> map1,
            Map<Float, Short> map2);

    @Override
     HashFloatShortMap newUpdatableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3);

    @Override
     HashFloatShortMap newUpdatableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4);

    @Override
     HashFloatShortMap newUpdatableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4, Map<Float, Short> map5);


    @Override
     HashFloatShortMap newUpdatableMap(
            net.openhft.function.Consumer<FloatShortConsumer> entriesSupplier);

    @Override
     HashFloatShortMap newUpdatableMap(
            net.openhft.function.Consumer<FloatShortConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashFloatShortMap newUpdatableMap(float[] keys, short[] values);

    @Override
     HashFloatShortMap newUpdatableMap(float[] keys, short[] values,
            int expectedSize);

    @Override
     HashFloatShortMap newUpdatableMap(
            Float[] keys, Short[] values);

    @Override
     HashFloatShortMap newUpdatableMap(
            Float[] keys, Short[] values, int expectedSize);

    @Override
     HashFloatShortMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Short> values);

    @Override
     HashFloatShortMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Short> values, int expectedSize);


    @Override
     HashFloatShortMap newUpdatableMapOf(float k1, short v1);

    @Override
     HashFloatShortMap newUpdatableMapOf(float k1, short v1,
            float k2, short v2);

    @Override
     HashFloatShortMap newUpdatableMapOf(float k1, short v1,
            float k2, short v2, float k3, short v3);

    @Override
     HashFloatShortMap newUpdatableMapOf(float k1, short v1,
            float k2, short v2, float k3, short v3,
            float k4, short v4);

    @Override
     HashFloatShortMap newUpdatableMapOf(float k1, short v1,
            float k2, short v2, float k3, short v3,
            float k4, short v4, float k5, short v5);

    


    @Override
     HashFloatShortMap newImmutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, int expectedSize);

    @Override
     HashFloatShortMap newImmutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3, int expectedSize);

    @Override
     HashFloatShortMap newImmutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4, int expectedSize);

    @Override
     HashFloatShortMap newImmutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4, Map<Float, Short> map5, int expectedSize);

    

    
    @Override
     HashFloatShortMap newImmutableMap(Map<Float, Short> map);

    @Override
     HashFloatShortMap newImmutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2);

    @Override
     HashFloatShortMap newImmutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3);

    @Override
     HashFloatShortMap newImmutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4);

    @Override
     HashFloatShortMap newImmutableMap(Map<Float, Short> map1,
            Map<Float, Short> map2, Map<Float, Short> map3,
            Map<Float, Short> map4, Map<Float, Short> map5);


    @Override
     HashFloatShortMap newImmutableMap(
            net.openhft.function.Consumer<FloatShortConsumer> entriesSupplier);

    @Override
     HashFloatShortMap newImmutableMap(
            net.openhft.function.Consumer<FloatShortConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashFloatShortMap newImmutableMap(float[] keys, short[] values);

    @Override
     HashFloatShortMap newImmutableMap(float[] keys, short[] values,
            int expectedSize);

    @Override
     HashFloatShortMap newImmutableMap(
            Float[] keys, Short[] values);

    @Override
     HashFloatShortMap newImmutableMap(
            Float[] keys, Short[] values, int expectedSize);

    @Override
     HashFloatShortMap newImmutableMap(Iterable<Float> keys,
            Iterable<Short> values);

    @Override
     HashFloatShortMap newImmutableMap(Iterable<Float> keys,
            Iterable<Short> values, int expectedSize);


    @Override
     HashFloatShortMap newImmutableMapOf(float k1, short v1);

    @Override
     HashFloatShortMap newImmutableMapOf(float k1, short v1,
            float k2, short v2);

    @Override
     HashFloatShortMap newImmutableMapOf(float k1, short v1,
            float k2, short v2, float k3, short v3);

    @Override
     HashFloatShortMap newImmutableMapOf(float k1, short v1,
            float k2, short v2, float k3, short v3,
            float k4, short v4);

    @Override
     HashFloatShortMap newImmutableMapOf(float k1, short v1,
            float k2, short v2, float k3, short v3,
            float k4, short v4, float k5, short v5);
}

