/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.FloatObjConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashFloatObjMap}s, and
 * the default {@link HashFloatObjMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashFloatObjMap
 */
public final class HashFloatObjMaps {

    

    private static final ServiceLoader<HashFloatObjMapFactory> LOADER =
            ServiceLoader.load(HashFloatObjMapFactory.class);
    private static HashFloatObjMapFactory<Object> defaultFactory = null;

    public static HashFloatObjMapFactory<Object> getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static <V> HashFloatObjMap<V> newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static <V> HashFloatObjMap<V> newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static <V> HashFloatObjMap<V> newMutableMap(Map<Float, ? extends V> map1,
            Map<Float, ? extends V> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static <V> HashFloatObjMap<V> newMutableMap(Map<Float, ? extends V> map1,
            Map<Float, ? extends V> map2, Map<Float, ? extends V> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static <V> HashFloatObjMap<V> newMutableMap(Map<Float, ? extends V> map1,
            Map<Float, ? extends V> map2, Map<Float, ? extends V> map3,
            Map<Float, ? extends V> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static <V> HashFloatObjMap<V> newMutableMap(Map<Float, ? extends V> map1,
            Map<Float, ? extends V> map2, Map<Float, ? extends V> map3,
            Map<Float, ? extends V> map4, Map<Float, ? extends V> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static <V> HashFloatObjMap<V> newMutableMap(
            Map<Float, ? extends V> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static <V> HashFloatObjMap<V> newMutableMap(Map<Float, ? extends V> map1,
            Map<Float, ? extends V> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static <V> HashFloatObjMap<V> newMutableMap(Map<Float, ? extends V> map1,
            Map<Float, ? extends V> map2, Map<Float, ? extends V> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static <V> HashFloatObjMap<V> newMutableMap(Map<Float, ? extends V> map1,
            Map<Float, ? extends V> map2, Map<Float, ? extends V> map3,
            Map<Float, ? extends V> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static <V> HashFloatObjMap<V> newMutableMap(Map<Float, ? extends V> map1,
            Map<Float, ? extends V> map2, Map<Float, ? extends V> map3,
            Map<Float, ? extends V> map4, Map<Float, ? extends V> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static <V> HashFloatObjMap<V> newMutableMap(
            net.openhft.function.Consumer<FloatObjConsumer<V>> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static <V> HashFloatObjMap<V> newMutableMap(
            net.openhft.function.Consumer<FloatObjConsumer<V>> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static <V> HashFloatObjMap<V> newMutableMap(
            float[] keys, V[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static <V> HashFloatObjMap<V> newMutableMap(
            float[] keys, V[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static <V> HashFloatObjMap<V> newMutableMap(
            Float[] keys, V[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static <V> HashFloatObjMap<V> newMutableMap(
            Float[] keys, V[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static <V> HashFloatObjMap<V> newMutableMap(Iterable<Float> keys,
            Iterable<? extends V> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static <V> HashFloatObjMap<V> newMutableMap(Iterable<Float> keys,
            Iterable<? extends V> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static <V> HashFloatObjMap<V> newMutableMapOf(
            float k1, V v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static <V> HashFloatObjMap<V> newMutableMapOf(
            float k1, V v1, float k2, V v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static <V> HashFloatObjMap<V> newMutableMapOf(
            float k1, V v1, float k2, V v2,
            float k3, V v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static <V> HashFloatObjMap<V> newMutableMapOf(
            float k1, V v1, float k2, V v2,
            float k3, V v3, float k4, V v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static <V> HashFloatObjMap<V> newMutableMapOf(
            float k1, V v1, float k2, V v2,
            float k3, V v3, float k4, V v4,
            float k5, V v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static <V> HashFloatObjMap<V> newUpdatableMap(Map<Float, ? extends V> map1,
            Map<Float, ? extends V> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static <V> HashFloatObjMap<V> newUpdatableMap(Map<Float, ? extends V> map1,
            Map<Float, ? extends V> map2, Map<Float, ? extends V> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static <V> HashFloatObjMap<V> newUpdatableMap(Map<Float, ? extends V> map1,
            Map<Float, ? extends V> map2, Map<Float, ? extends V> map3,
            Map<Float, ? extends V> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static <V> HashFloatObjMap<V> newUpdatableMap(Map<Float, ? extends V> map1,
            Map<Float, ? extends V> map2, Map<Float, ? extends V> map3,
            Map<Float, ? extends V> map4, Map<Float, ? extends V> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static <V> HashFloatObjMap<V> newUpdatableMap(
            Map<Float, ? extends V> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static <V> HashFloatObjMap<V> newUpdatableMap(Map<Float, ? extends V> map1,
            Map<Float, ? extends V> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static <V> HashFloatObjMap<V> newUpdatableMap(Map<Float, ? extends V> map1,
            Map<Float, ? extends V> map2, Map<Float, ? extends V> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static <V> HashFloatObjMap<V> newUpdatableMap(Map<Float, ? extends V> map1,
            Map<Float, ? extends V> map2, Map<Float, ? extends V> map3,
            Map<Float, ? extends V> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static <V> HashFloatObjMap<V> newUpdatableMap(Map<Float, ? extends V> map1,
            Map<Float, ? extends V> map2, Map<Float, ? extends V> map3,
            Map<Float, ? extends V> map4, Map<Float, ? extends V> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static <V> HashFloatObjMap<V> newUpdatableMap(
            net.openhft.function.Consumer<FloatObjConsumer<V>> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static <V> HashFloatObjMap<V> newUpdatableMap(
            net.openhft.function.Consumer<FloatObjConsumer<V>> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static <V> HashFloatObjMap<V> newUpdatableMap(
            float[] keys, V[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static <V> HashFloatObjMap<V> newUpdatableMap(
            float[] keys, V[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static <V> HashFloatObjMap<V> newUpdatableMap(
            Float[] keys, V[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static <V> HashFloatObjMap<V> newUpdatableMap(
            Float[] keys, V[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static <V> HashFloatObjMap<V> newUpdatableMap(Iterable<Float> keys,
            Iterable<? extends V> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static <V> HashFloatObjMap<V> newUpdatableMap(Iterable<Float> keys,
            Iterable<? extends V> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static <V> HashFloatObjMap<V> newUpdatableMapOf(
            float k1, V v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static <V> HashFloatObjMap<V> newUpdatableMapOf(
            float k1, V v1, float k2, V v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static <V> HashFloatObjMap<V> newUpdatableMapOf(
            float k1, V v1, float k2, V v2,
            float k3, V v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static <V> HashFloatObjMap<V> newUpdatableMapOf(
            float k1, V v1, float k2, V v2,
            float k3, V v3, float k4, V v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static <V> HashFloatObjMap<V> newUpdatableMapOf(
            float k1, V v1, float k2, V v2,
            float k3, V v3, float k4, V v4,
            float k5, V v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static <V> HashFloatObjMap<V> newImmutableMap(Map<Float, ? extends V> map1,
            Map<Float, ? extends V> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static <V> HashFloatObjMap<V> newImmutableMap(Map<Float, ? extends V> map1,
            Map<Float, ? extends V> map2, Map<Float, ? extends V> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static <V> HashFloatObjMap<V> newImmutableMap(Map<Float, ? extends V> map1,
            Map<Float, ? extends V> map2, Map<Float, ? extends V> map3,
            Map<Float, ? extends V> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static <V> HashFloatObjMap<V> newImmutableMap(Map<Float, ? extends V> map1,
            Map<Float, ? extends V> map2, Map<Float, ? extends V> map3,
            Map<Float, ? extends V> map4, Map<Float, ? extends V> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static <V> HashFloatObjMap<V> newImmutableMap(
            Map<Float, ? extends V> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static <V> HashFloatObjMap<V> newImmutableMap(Map<Float, ? extends V> map1,
            Map<Float, ? extends V> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static <V> HashFloatObjMap<V> newImmutableMap(Map<Float, ? extends V> map1,
            Map<Float, ? extends V> map2, Map<Float, ? extends V> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static <V> HashFloatObjMap<V> newImmutableMap(Map<Float, ? extends V> map1,
            Map<Float, ? extends V> map2, Map<Float, ? extends V> map3,
            Map<Float, ? extends V> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static <V> HashFloatObjMap<V> newImmutableMap(Map<Float, ? extends V> map1,
            Map<Float, ? extends V> map2, Map<Float, ? extends V> map3,
            Map<Float, ? extends V> map4, Map<Float, ? extends V> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static <V> HashFloatObjMap<V> newImmutableMap(
            net.openhft.function.Consumer<FloatObjConsumer<V>> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static <V> HashFloatObjMap<V> newImmutableMap(
            net.openhft.function.Consumer<FloatObjConsumer<V>> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static <V> HashFloatObjMap<V> newImmutableMap(
            float[] keys, V[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static <V> HashFloatObjMap<V> newImmutableMap(
            float[] keys, V[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static <V> HashFloatObjMap<V> newImmutableMap(
            Float[] keys, V[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static <V> HashFloatObjMap<V> newImmutableMap(
            Float[] keys, V[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static <V> HashFloatObjMap<V> newImmutableMap(Iterable<Float> keys,
            Iterable<? extends V> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static <V> HashFloatObjMap<V> newImmutableMap(Iterable<Float> keys,
            Iterable<? extends V> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static <V> HashFloatObjMap<V> newImmutableMapOf(
            float k1, V v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static <V> HashFloatObjMap<V> newImmutableMapOf(
            float k1, V v1, float k2, V v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static <V> HashFloatObjMap<V> newImmutableMapOf(
            float k1, V v1, float k2, V v2,
            float k3, V v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static <V> HashFloatObjMap<V> newImmutableMapOf(
            float k1, V v1, float k2, V v2,
            float k3, V v3, float k4, V v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static <V> HashFloatObjMap<V> newImmutableMapOf(
            float k1, V v1, float k2, V v2,
            float k3, V v3, float k4, V v4,
            float k5, V v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashFloatObjMaps() {}
}

