/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.FloatLongConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashFloatLongMap}s, and
 * the default {@link HashFloatLongMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashFloatLongMap
 */
public final class HashFloatLongMaps {

    

    private static final ServiceLoader<HashFloatLongMapFactory> LOADER =
            ServiceLoader.load(HashFloatLongMapFactory.class);
    private static HashFloatLongMapFactory defaultFactory = null;

    public static HashFloatLongMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashFloatLongMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashFloatLongMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashFloatLongMap newMutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashFloatLongMap newMutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashFloatLongMap newMutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashFloatLongMap newMutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4, Map<Float, Long> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashFloatLongMap newMutableMap(
            Map<Float, Long> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashFloatLongMap newMutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashFloatLongMap newMutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashFloatLongMap newMutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashFloatLongMap newMutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4, Map<Float, Long> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashFloatLongMap newMutableMap(
            net.openhft.function.Consumer<FloatLongConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashFloatLongMap newMutableMap(
            net.openhft.function.Consumer<FloatLongConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashFloatLongMap newMutableMap(
            float[] keys, long[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashFloatLongMap newMutableMap(
            float[] keys, long[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashFloatLongMap newMutableMap(
            Float[] keys, Long[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashFloatLongMap newMutableMap(
            Float[] keys, Long[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashFloatLongMap newMutableMap(Iterable<Float> keys,
            Iterable<Long> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashFloatLongMap newMutableMap(Iterable<Float> keys,
            Iterable<Long> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashFloatLongMap newMutableMapOf(
            float k1, long v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashFloatLongMap newMutableMapOf(
            float k1, long v1, float k2, long v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashFloatLongMap newMutableMapOf(
            float k1, long v1, float k2, long v2,
            float k3, long v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashFloatLongMap newMutableMapOf(
            float k1, long v1, float k2, long v2,
            float k3, long v3, float k4, long v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashFloatLongMap newMutableMapOf(
            float k1, long v1, float k2, long v2,
            float k3, long v3, float k4, long v4,
            float k5, long v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashFloatLongMap newUpdatableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashFloatLongMap newUpdatableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashFloatLongMap newUpdatableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashFloatLongMap newUpdatableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4, Map<Float, Long> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashFloatLongMap newUpdatableMap(
            Map<Float, Long> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashFloatLongMap newUpdatableMap(Map<Float, Long> map1,
            Map<Float, Long> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashFloatLongMap newUpdatableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashFloatLongMap newUpdatableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashFloatLongMap newUpdatableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4, Map<Float, Long> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashFloatLongMap newUpdatableMap(
            net.openhft.function.Consumer<FloatLongConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashFloatLongMap newUpdatableMap(
            net.openhft.function.Consumer<FloatLongConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashFloatLongMap newUpdatableMap(
            float[] keys, long[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashFloatLongMap newUpdatableMap(
            float[] keys, long[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashFloatLongMap newUpdatableMap(
            Float[] keys, Long[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashFloatLongMap newUpdatableMap(
            Float[] keys, Long[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashFloatLongMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Long> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashFloatLongMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Long> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashFloatLongMap newUpdatableMapOf(
            float k1, long v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashFloatLongMap newUpdatableMapOf(
            float k1, long v1, float k2, long v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashFloatLongMap newUpdatableMapOf(
            float k1, long v1, float k2, long v2,
            float k3, long v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashFloatLongMap newUpdatableMapOf(
            float k1, long v1, float k2, long v2,
            float k3, long v3, float k4, long v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashFloatLongMap newUpdatableMapOf(
            float k1, long v1, float k2, long v2,
            float k3, long v3, float k4, long v4,
            float k5, long v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashFloatLongMap newImmutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashFloatLongMap newImmutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashFloatLongMap newImmutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashFloatLongMap newImmutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4, Map<Float, Long> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashFloatLongMap newImmutableMap(
            Map<Float, Long> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashFloatLongMap newImmutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashFloatLongMap newImmutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashFloatLongMap newImmutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashFloatLongMap newImmutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4, Map<Float, Long> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashFloatLongMap newImmutableMap(
            net.openhft.function.Consumer<FloatLongConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashFloatLongMap newImmutableMap(
            net.openhft.function.Consumer<FloatLongConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashFloatLongMap newImmutableMap(
            float[] keys, long[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashFloatLongMap newImmutableMap(
            float[] keys, long[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashFloatLongMap newImmutableMap(
            Float[] keys, Long[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashFloatLongMap newImmutableMap(
            Float[] keys, Long[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashFloatLongMap newImmutableMap(Iterable<Float> keys,
            Iterable<Long> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashFloatLongMap newImmutableMap(Iterable<Float> keys,
            Iterable<Long> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashFloatLongMap newImmutableMapOf(
            float k1, long v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashFloatLongMap newImmutableMapOf(
            float k1, long v1, float k2, long v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashFloatLongMap newImmutableMapOf(
            float k1, long v1, float k2, long v2,
            float k3, long v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashFloatLongMap newImmutableMapOf(
            float k1, long v1, float k2, long v2,
            float k3, long v3, float k4, long v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashFloatLongMap newImmutableMapOf(
            float k1, long v1, float k2, long v2,
            float k3, long v3, float k4, long v4,
            float k5, long v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashFloatLongMaps() {}
}

