/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.FloatLongConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashFloatLongMaps}
 *
 * @see HashFloatLongMap
 * @see HashFloatLongMaps#getDefaultFactory()
 */
public interface HashFloatLongMapFactory extends FloatLongMapFactory
        , HashContainerFactory<HashFloatLongMapFactory> {

    

    

    

    

    

    
    

    
    


    @Override
    HashFloatLongMapFactory withDefaultValue(long defaultValue);

    @Override
     HashFloatLongMap newMutableMap();

    @Override
     HashFloatLongMap newMutableMap(int expectedSize);

    


    @Override
     HashFloatLongMap newMutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, int expectedSize);

    @Override
     HashFloatLongMap newMutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3, int expectedSize);

    @Override
     HashFloatLongMap newMutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4, int expectedSize);

    @Override
     HashFloatLongMap newMutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4, Map<Float, Long> map5, int expectedSize);

    

    
    @Override
     HashFloatLongMap newMutableMap(Map<Float, Long> map);

    @Override
     HashFloatLongMap newMutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2);

    @Override
     HashFloatLongMap newMutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3);

    @Override
     HashFloatLongMap newMutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4);

    @Override
     HashFloatLongMap newMutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4, Map<Float, Long> map5);


    @Override
     HashFloatLongMap newMutableMap(
            net.openhft.function.Consumer<FloatLongConsumer> entriesSupplier);

    @Override
     HashFloatLongMap newMutableMap(
            net.openhft.function.Consumer<FloatLongConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashFloatLongMap newMutableMap(float[] keys, long[] values);

    @Override
     HashFloatLongMap newMutableMap(float[] keys, long[] values,
            int expectedSize);

    @Override
     HashFloatLongMap newMutableMap(
            Float[] keys, Long[] values);

    @Override
     HashFloatLongMap newMutableMap(
            Float[] keys, Long[] values, int expectedSize);

    @Override
     HashFloatLongMap newMutableMap(Iterable<Float> keys,
            Iterable<Long> values);

    @Override
     HashFloatLongMap newMutableMap(Iterable<Float> keys,
            Iterable<Long> values, int expectedSize);


    @Override
     HashFloatLongMap newMutableMapOf(float k1, long v1);

    @Override
     HashFloatLongMap newMutableMapOf(float k1, long v1,
            float k2, long v2);

    @Override
     HashFloatLongMap newMutableMapOf(float k1, long v1,
            float k2, long v2, float k3, long v3);

    @Override
     HashFloatLongMap newMutableMapOf(float k1, long v1,
            float k2, long v2, float k3, long v3,
            float k4, long v4);

    @Override
     HashFloatLongMap newMutableMapOf(float k1, long v1,
            float k2, long v2, float k3, long v3,
            float k4, long v4, float k5, long v5);
    @Override
     HashFloatLongMap newUpdatableMap();

    @Override
     HashFloatLongMap newUpdatableMap(int expectedSize);

    


    @Override
     HashFloatLongMap newUpdatableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, int expectedSize);

    @Override
     HashFloatLongMap newUpdatableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3, int expectedSize);

    @Override
     HashFloatLongMap newUpdatableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4, int expectedSize);

    @Override
     HashFloatLongMap newUpdatableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4, Map<Float, Long> map5, int expectedSize);

    

    
    @Override
     HashFloatLongMap newUpdatableMap(Map<Float, Long> map);

    @Override
     HashFloatLongMap newUpdatableMap(Map<Float, Long> map1,
            Map<Float, Long> map2);

    @Override
     HashFloatLongMap newUpdatableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3);

    @Override
     HashFloatLongMap newUpdatableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4);

    @Override
     HashFloatLongMap newUpdatableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4, Map<Float, Long> map5);


    @Override
     HashFloatLongMap newUpdatableMap(
            net.openhft.function.Consumer<FloatLongConsumer> entriesSupplier);

    @Override
     HashFloatLongMap newUpdatableMap(
            net.openhft.function.Consumer<FloatLongConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashFloatLongMap newUpdatableMap(float[] keys, long[] values);

    @Override
     HashFloatLongMap newUpdatableMap(float[] keys, long[] values,
            int expectedSize);

    @Override
     HashFloatLongMap newUpdatableMap(
            Float[] keys, Long[] values);

    @Override
     HashFloatLongMap newUpdatableMap(
            Float[] keys, Long[] values, int expectedSize);

    @Override
     HashFloatLongMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Long> values);

    @Override
     HashFloatLongMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Long> values, int expectedSize);


    @Override
     HashFloatLongMap newUpdatableMapOf(float k1, long v1);

    @Override
     HashFloatLongMap newUpdatableMapOf(float k1, long v1,
            float k2, long v2);

    @Override
     HashFloatLongMap newUpdatableMapOf(float k1, long v1,
            float k2, long v2, float k3, long v3);

    @Override
     HashFloatLongMap newUpdatableMapOf(float k1, long v1,
            float k2, long v2, float k3, long v3,
            float k4, long v4);

    @Override
     HashFloatLongMap newUpdatableMapOf(float k1, long v1,
            float k2, long v2, float k3, long v3,
            float k4, long v4, float k5, long v5);

    


    @Override
     HashFloatLongMap newImmutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, int expectedSize);

    @Override
     HashFloatLongMap newImmutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3, int expectedSize);

    @Override
     HashFloatLongMap newImmutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4, int expectedSize);

    @Override
     HashFloatLongMap newImmutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4, Map<Float, Long> map5, int expectedSize);

    

    
    @Override
     HashFloatLongMap newImmutableMap(Map<Float, Long> map);

    @Override
     HashFloatLongMap newImmutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2);

    @Override
     HashFloatLongMap newImmutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3);

    @Override
     HashFloatLongMap newImmutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4);

    @Override
     HashFloatLongMap newImmutableMap(Map<Float, Long> map1,
            Map<Float, Long> map2, Map<Float, Long> map3,
            Map<Float, Long> map4, Map<Float, Long> map5);


    @Override
     HashFloatLongMap newImmutableMap(
            net.openhft.function.Consumer<FloatLongConsumer> entriesSupplier);

    @Override
     HashFloatLongMap newImmutableMap(
            net.openhft.function.Consumer<FloatLongConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashFloatLongMap newImmutableMap(float[] keys, long[] values);

    @Override
     HashFloatLongMap newImmutableMap(float[] keys, long[] values,
            int expectedSize);

    @Override
     HashFloatLongMap newImmutableMap(
            Float[] keys, Long[] values);

    @Override
     HashFloatLongMap newImmutableMap(
            Float[] keys, Long[] values, int expectedSize);

    @Override
     HashFloatLongMap newImmutableMap(Iterable<Float> keys,
            Iterable<Long> values);

    @Override
     HashFloatLongMap newImmutableMap(Iterable<Float> keys,
            Iterable<Long> values, int expectedSize);


    @Override
     HashFloatLongMap newImmutableMapOf(float k1, long v1);

    @Override
     HashFloatLongMap newImmutableMapOf(float k1, long v1,
            float k2, long v2);

    @Override
     HashFloatLongMap newImmutableMapOf(float k1, long v1,
            float k2, long v2, float k3, long v3);

    @Override
     HashFloatLongMap newImmutableMapOf(float k1, long v1,
            float k2, long v2, float k3, long v3,
            float k4, long v4);

    @Override
     HashFloatLongMap newImmutableMapOf(float k1, long v1,
            float k2, long v2, float k3, long v3,
            float k4, long v4, float k5, long v5);
}

