/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.FloatIntConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashFloatIntMap}s, and
 * the default {@link HashFloatIntMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashFloatIntMap
 */
public final class HashFloatIntMaps {

    

    private static final ServiceLoader<HashFloatIntMapFactory> LOADER =
            ServiceLoader.load(HashFloatIntMapFactory.class);
    private static HashFloatIntMapFactory defaultFactory = null;

    public static HashFloatIntMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashFloatIntMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashFloatIntMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashFloatIntMap newMutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashFloatIntMap newMutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashFloatIntMap newMutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashFloatIntMap newMutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4, Map<Float, Integer> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashFloatIntMap newMutableMap(
            Map<Float, Integer> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashFloatIntMap newMutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashFloatIntMap newMutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashFloatIntMap newMutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashFloatIntMap newMutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4, Map<Float, Integer> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashFloatIntMap newMutableMap(
            net.openhft.function.Consumer<FloatIntConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashFloatIntMap newMutableMap(
            net.openhft.function.Consumer<FloatIntConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashFloatIntMap newMutableMap(
            float[] keys, int[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashFloatIntMap newMutableMap(
            float[] keys, int[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashFloatIntMap newMutableMap(
            Float[] keys, Integer[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashFloatIntMap newMutableMap(
            Float[] keys, Integer[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashFloatIntMap newMutableMap(Iterable<Float> keys,
            Iterable<Integer> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashFloatIntMap newMutableMap(Iterable<Float> keys,
            Iterable<Integer> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashFloatIntMap newMutableMapOf(
            float k1, int v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashFloatIntMap newMutableMapOf(
            float k1, int v1, float k2, int v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashFloatIntMap newMutableMapOf(
            float k1, int v1, float k2, int v2,
            float k3, int v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashFloatIntMap newMutableMapOf(
            float k1, int v1, float k2, int v2,
            float k3, int v3, float k4, int v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashFloatIntMap newMutableMapOf(
            float k1, int v1, float k2, int v2,
            float k3, int v3, float k4, int v4,
            float k5, int v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashFloatIntMap newUpdatableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashFloatIntMap newUpdatableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashFloatIntMap newUpdatableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashFloatIntMap newUpdatableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4, Map<Float, Integer> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashFloatIntMap newUpdatableMap(
            Map<Float, Integer> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashFloatIntMap newUpdatableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashFloatIntMap newUpdatableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashFloatIntMap newUpdatableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashFloatIntMap newUpdatableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4, Map<Float, Integer> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashFloatIntMap newUpdatableMap(
            net.openhft.function.Consumer<FloatIntConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashFloatIntMap newUpdatableMap(
            net.openhft.function.Consumer<FloatIntConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashFloatIntMap newUpdatableMap(
            float[] keys, int[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashFloatIntMap newUpdatableMap(
            float[] keys, int[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashFloatIntMap newUpdatableMap(
            Float[] keys, Integer[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashFloatIntMap newUpdatableMap(
            Float[] keys, Integer[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashFloatIntMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Integer> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashFloatIntMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Integer> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashFloatIntMap newUpdatableMapOf(
            float k1, int v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashFloatIntMap newUpdatableMapOf(
            float k1, int v1, float k2, int v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashFloatIntMap newUpdatableMapOf(
            float k1, int v1, float k2, int v2,
            float k3, int v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashFloatIntMap newUpdatableMapOf(
            float k1, int v1, float k2, int v2,
            float k3, int v3, float k4, int v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashFloatIntMap newUpdatableMapOf(
            float k1, int v1, float k2, int v2,
            float k3, int v3, float k4, int v4,
            float k5, int v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashFloatIntMap newImmutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashFloatIntMap newImmutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashFloatIntMap newImmutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashFloatIntMap newImmutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4, Map<Float, Integer> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashFloatIntMap newImmutableMap(
            Map<Float, Integer> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashFloatIntMap newImmutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashFloatIntMap newImmutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashFloatIntMap newImmutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashFloatIntMap newImmutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4, Map<Float, Integer> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashFloatIntMap newImmutableMap(
            net.openhft.function.Consumer<FloatIntConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashFloatIntMap newImmutableMap(
            net.openhft.function.Consumer<FloatIntConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashFloatIntMap newImmutableMap(
            float[] keys, int[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashFloatIntMap newImmutableMap(
            float[] keys, int[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashFloatIntMap newImmutableMap(
            Float[] keys, Integer[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashFloatIntMap newImmutableMap(
            Float[] keys, Integer[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashFloatIntMap newImmutableMap(Iterable<Float> keys,
            Iterable<Integer> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashFloatIntMap newImmutableMap(Iterable<Float> keys,
            Iterable<Integer> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashFloatIntMap newImmutableMapOf(
            float k1, int v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashFloatIntMap newImmutableMapOf(
            float k1, int v1, float k2, int v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashFloatIntMap newImmutableMapOf(
            float k1, int v1, float k2, int v2,
            float k3, int v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashFloatIntMap newImmutableMapOf(
            float k1, int v1, float k2, int v2,
            float k3, int v3, float k4, int v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashFloatIntMap newImmutableMapOf(
            float k1, int v1, float k2, int v2,
            float k3, int v3, float k4, int v4,
            float k5, int v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashFloatIntMaps() {}
}

