/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.FloatIntConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashFloatIntMaps}
 *
 * @see HashFloatIntMap
 * @see HashFloatIntMaps#getDefaultFactory()
 */
public interface HashFloatIntMapFactory extends FloatIntMapFactory
        , HashContainerFactory<HashFloatIntMapFactory> {

    

    

    

    

    

    
    

    
    


    @Override
    HashFloatIntMapFactory withDefaultValue(int defaultValue);

    @Override
     HashFloatIntMap newMutableMap();

    @Override
     HashFloatIntMap newMutableMap(int expectedSize);

    


    @Override
     HashFloatIntMap newMutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, int expectedSize);

    @Override
     HashFloatIntMap newMutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3, int expectedSize);

    @Override
     HashFloatIntMap newMutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4, int expectedSize);

    @Override
     HashFloatIntMap newMutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4, Map<Float, Integer> map5, int expectedSize);

    

    
    @Override
     HashFloatIntMap newMutableMap(Map<Float, Integer> map);

    @Override
     HashFloatIntMap newMutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2);

    @Override
     HashFloatIntMap newMutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3);

    @Override
     HashFloatIntMap newMutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4);

    @Override
     HashFloatIntMap newMutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4, Map<Float, Integer> map5);


    @Override
     HashFloatIntMap newMutableMap(
            net.openhft.function.Consumer<FloatIntConsumer> entriesSupplier);

    @Override
     HashFloatIntMap newMutableMap(
            net.openhft.function.Consumer<FloatIntConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashFloatIntMap newMutableMap(float[] keys, int[] values);

    @Override
     HashFloatIntMap newMutableMap(float[] keys, int[] values,
            int expectedSize);

    @Override
     HashFloatIntMap newMutableMap(
            Float[] keys, Integer[] values);

    @Override
     HashFloatIntMap newMutableMap(
            Float[] keys, Integer[] values, int expectedSize);

    @Override
     HashFloatIntMap newMutableMap(Iterable<Float> keys,
            Iterable<Integer> values);

    @Override
     HashFloatIntMap newMutableMap(Iterable<Float> keys,
            Iterable<Integer> values, int expectedSize);


    @Override
     HashFloatIntMap newMutableMapOf(float k1, int v1);

    @Override
     HashFloatIntMap newMutableMapOf(float k1, int v1,
            float k2, int v2);

    @Override
     HashFloatIntMap newMutableMapOf(float k1, int v1,
            float k2, int v2, float k3, int v3);

    @Override
     HashFloatIntMap newMutableMapOf(float k1, int v1,
            float k2, int v2, float k3, int v3,
            float k4, int v4);

    @Override
     HashFloatIntMap newMutableMapOf(float k1, int v1,
            float k2, int v2, float k3, int v3,
            float k4, int v4, float k5, int v5);
    @Override
     HashFloatIntMap newUpdatableMap();

    @Override
     HashFloatIntMap newUpdatableMap(int expectedSize);

    


    @Override
     HashFloatIntMap newUpdatableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, int expectedSize);

    @Override
     HashFloatIntMap newUpdatableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3, int expectedSize);

    @Override
     HashFloatIntMap newUpdatableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4, int expectedSize);

    @Override
     HashFloatIntMap newUpdatableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4, Map<Float, Integer> map5, int expectedSize);

    

    
    @Override
     HashFloatIntMap newUpdatableMap(Map<Float, Integer> map);

    @Override
     HashFloatIntMap newUpdatableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2);

    @Override
     HashFloatIntMap newUpdatableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3);

    @Override
     HashFloatIntMap newUpdatableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4);

    @Override
     HashFloatIntMap newUpdatableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4, Map<Float, Integer> map5);


    @Override
     HashFloatIntMap newUpdatableMap(
            net.openhft.function.Consumer<FloatIntConsumer> entriesSupplier);

    @Override
     HashFloatIntMap newUpdatableMap(
            net.openhft.function.Consumer<FloatIntConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashFloatIntMap newUpdatableMap(float[] keys, int[] values);

    @Override
     HashFloatIntMap newUpdatableMap(float[] keys, int[] values,
            int expectedSize);

    @Override
     HashFloatIntMap newUpdatableMap(
            Float[] keys, Integer[] values);

    @Override
     HashFloatIntMap newUpdatableMap(
            Float[] keys, Integer[] values, int expectedSize);

    @Override
     HashFloatIntMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Integer> values);

    @Override
     HashFloatIntMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Integer> values, int expectedSize);


    @Override
     HashFloatIntMap newUpdatableMapOf(float k1, int v1);

    @Override
     HashFloatIntMap newUpdatableMapOf(float k1, int v1,
            float k2, int v2);

    @Override
     HashFloatIntMap newUpdatableMapOf(float k1, int v1,
            float k2, int v2, float k3, int v3);

    @Override
     HashFloatIntMap newUpdatableMapOf(float k1, int v1,
            float k2, int v2, float k3, int v3,
            float k4, int v4);

    @Override
     HashFloatIntMap newUpdatableMapOf(float k1, int v1,
            float k2, int v2, float k3, int v3,
            float k4, int v4, float k5, int v5);

    


    @Override
     HashFloatIntMap newImmutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, int expectedSize);

    @Override
     HashFloatIntMap newImmutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3, int expectedSize);

    @Override
     HashFloatIntMap newImmutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4, int expectedSize);

    @Override
     HashFloatIntMap newImmutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4, Map<Float, Integer> map5, int expectedSize);

    

    
    @Override
     HashFloatIntMap newImmutableMap(Map<Float, Integer> map);

    @Override
     HashFloatIntMap newImmutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2);

    @Override
     HashFloatIntMap newImmutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3);

    @Override
     HashFloatIntMap newImmutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4);

    @Override
     HashFloatIntMap newImmutableMap(Map<Float, Integer> map1,
            Map<Float, Integer> map2, Map<Float, Integer> map3,
            Map<Float, Integer> map4, Map<Float, Integer> map5);


    @Override
     HashFloatIntMap newImmutableMap(
            net.openhft.function.Consumer<FloatIntConsumer> entriesSupplier);

    @Override
     HashFloatIntMap newImmutableMap(
            net.openhft.function.Consumer<FloatIntConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashFloatIntMap newImmutableMap(float[] keys, int[] values);

    @Override
     HashFloatIntMap newImmutableMap(float[] keys, int[] values,
            int expectedSize);

    @Override
     HashFloatIntMap newImmutableMap(
            Float[] keys, Integer[] values);

    @Override
     HashFloatIntMap newImmutableMap(
            Float[] keys, Integer[] values, int expectedSize);

    @Override
     HashFloatIntMap newImmutableMap(Iterable<Float> keys,
            Iterable<Integer> values);

    @Override
     HashFloatIntMap newImmutableMap(Iterable<Float> keys,
            Iterable<Integer> values, int expectedSize);


    @Override
     HashFloatIntMap newImmutableMapOf(float k1, int v1);

    @Override
     HashFloatIntMap newImmutableMapOf(float k1, int v1,
            float k2, int v2);

    @Override
     HashFloatIntMap newImmutableMapOf(float k1, int v1,
            float k2, int v2, float k3, int v3);

    @Override
     HashFloatIntMap newImmutableMapOf(float k1, int v1,
            float k2, int v2, float k3, int v3,
            float k4, int v4);

    @Override
     HashFloatIntMap newImmutableMapOf(float k1, int v1,
            float k2, int v2, float k3, int v3,
            float k4, int v4, float k5, int v5);
}

