/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.FloatFloatConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashFloatFloatMap}s, and
 * the default {@link HashFloatFloatMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashFloatFloatMap
 */
public final class HashFloatFloatMaps {

    

    private static final ServiceLoader<HashFloatFloatMapFactory> LOADER =
            ServiceLoader.load(HashFloatFloatMapFactory.class);
    private static HashFloatFloatMapFactory defaultFactory = null;

    public static HashFloatFloatMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashFloatFloatMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashFloatFloatMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashFloatFloatMap newMutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashFloatFloatMap newMutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashFloatFloatMap newMutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashFloatFloatMap newMutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4, Map<Float, Float> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashFloatFloatMap newMutableMap(
            Map<Float, Float> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashFloatFloatMap newMutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashFloatFloatMap newMutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashFloatFloatMap newMutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashFloatFloatMap newMutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4, Map<Float, Float> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashFloatFloatMap newMutableMap(
            net.openhft.function.Consumer<FloatFloatConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashFloatFloatMap newMutableMap(
            net.openhft.function.Consumer<FloatFloatConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashFloatFloatMap newMutableMap(
            float[] keys, float[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashFloatFloatMap newMutableMap(
            float[] keys, float[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashFloatFloatMap newMutableMap(
            Float[] keys, Float[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashFloatFloatMap newMutableMap(
            Float[] keys, Float[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashFloatFloatMap newMutableMap(Iterable<Float> keys,
            Iterable<Float> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashFloatFloatMap newMutableMap(Iterable<Float> keys,
            Iterable<Float> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashFloatFloatMap newMutableMapOf(
            float k1, float v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashFloatFloatMap newMutableMapOf(
            float k1, float v1, float k2, float v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashFloatFloatMap newMutableMapOf(
            float k1, float v1, float k2, float v2,
            float k3, float v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashFloatFloatMap newMutableMapOf(
            float k1, float v1, float k2, float v2,
            float k3, float v3, float k4, float v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashFloatFloatMap newMutableMapOf(
            float k1, float v1, float k2, float v2,
            float k3, float v3, float k4, float v4,
            float k5, float v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashFloatFloatMap newUpdatableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashFloatFloatMap newUpdatableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashFloatFloatMap newUpdatableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashFloatFloatMap newUpdatableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4, Map<Float, Float> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashFloatFloatMap newUpdatableMap(
            Map<Float, Float> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashFloatFloatMap newUpdatableMap(Map<Float, Float> map1,
            Map<Float, Float> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashFloatFloatMap newUpdatableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashFloatFloatMap newUpdatableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashFloatFloatMap newUpdatableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4, Map<Float, Float> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashFloatFloatMap newUpdatableMap(
            net.openhft.function.Consumer<FloatFloatConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashFloatFloatMap newUpdatableMap(
            net.openhft.function.Consumer<FloatFloatConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashFloatFloatMap newUpdatableMap(
            float[] keys, float[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashFloatFloatMap newUpdatableMap(
            float[] keys, float[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashFloatFloatMap newUpdatableMap(
            Float[] keys, Float[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashFloatFloatMap newUpdatableMap(
            Float[] keys, Float[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashFloatFloatMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Float> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashFloatFloatMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Float> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashFloatFloatMap newUpdatableMapOf(
            float k1, float v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashFloatFloatMap newUpdatableMapOf(
            float k1, float v1, float k2, float v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashFloatFloatMap newUpdatableMapOf(
            float k1, float v1, float k2, float v2,
            float k3, float v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashFloatFloatMap newUpdatableMapOf(
            float k1, float v1, float k2, float v2,
            float k3, float v3, float k4, float v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashFloatFloatMap newUpdatableMapOf(
            float k1, float v1, float k2, float v2,
            float k3, float v3, float k4, float v4,
            float k5, float v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashFloatFloatMap newImmutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashFloatFloatMap newImmutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashFloatFloatMap newImmutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashFloatFloatMap newImmutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4, Map<Float, Float> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashFloatFloatMap newImmutableMap(
            Map<Float, Float> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashFloatFloatMap newImmutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashFloatFloatMap newImmutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashFloatFloatMap newImmutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashFloatFloatMap newImmutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4, Map<Float, Float> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashFloatFloatMap newImmutableMap(
            net.openhft.function.Consumer<FloatFloatConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashFloatFloatMap newImmutableMap(
            net.openhft.function.Consumer<FloatFloatConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashFloatFloatMap newImmutableMap(
            float[] keys, float[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashFloatFloatMap newImmutableMap(
            float[] keys, float[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashFloatFloatMap newImmutableMap(
            Float[] keys, Float[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashFloatFloatMap newImmutableMap(
            Float[] keys, Float[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashFloatFloatMap newImmutableMap(Iterable<Float> keys,
            Iterable<Float> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashFloatFloatMap newImmutableMap(Iterable<Float> keys,
            Iterable<Float> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashFloatFloatMap newImmutableMapOf(
            float k1, float v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashFloatFloatMap newImmutableMapOf(
            float k1, float v1, float k2, float v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashFloatFloatMap newImmutableMapOf(
            float k1, float v1, float k2, float v2,
            float k3, float v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashFloatFloatMap newImmutableMapOf(
            float k1, float v1, float k2, float v2,
            float k3, float v3, float k4, float v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashFloatFloatMap newImmutableMapOf(
            float k1, float v1, float k2, float v2,
            float k3, float v3, float k4, float v4,
            float k5, float v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashFloatFloatMaps() {}
}

