/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.FloatFloatConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashFloatFloatMaps}
 *
 * @see HashFloatFloatMap
 * @see HashFloatFloatMaps#getDefaultFactory()
 */
public interface HashFloatFloatMapFactory extends FloatFloatMapFactory
        , HashContainerFactory<HashFloatFloatMapFactory> {

    

    

    

    

    

    
    

    
    


    @Override
    HashFloatFloatMapFactory withDefaultValue(float defaultValue);

    @Override
     HashFloatFloatMap newMutableMap();

    @Override
     HashFloatFloatMap newMutableMap(int expectedSize);

    


    @Override
     HashFloatFloatMap newMutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, int expectedSize);

    @Override
     HashFloatFloatMap newMutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3, int expectedSize);

    @Override
     HashFloatFloatMap newMutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4, int expectedSize);

    @Override
     HashFloatFloatMap newMutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4, Map<Float, Float> map5, int expectedSize);

    

    
    @Override
     HashFloatFloatMap newMutableMap(Map<Float, Float> map);

    @Override
     HashFloatFloatMap newMutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2);

    @Override
     HashFloatFloatMap newMutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3);

    @Override
     HashFloatFloatMap newMutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4);

    @Override
     HashFloatFloatMap newMutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4, Map<Float, Float> map5);


    @Override
     HashFloatFloatMap newMutableMap(
            net.openhft.function.Consumer<FloatFloatConsumer> entriesSupplier);

    @Override
     HashFloatFloatMap newMutableMap(
            net.openhft.function.Consumer<FloatFloatConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashFloatFloatMap newMutableMap(float[] keys, float[] values);

    @Override
     HashFloatFloatMap newMutableMap(float[] keys, float[] values,
            int expectedSize);

    @Override
     HashFloatFloatMap newMutableMap(
            Float[] keys, Float[] values);

    @Override
     HashFloatFloatMap newMutableMap(
            Float[] keys, Float[] values, int expectedSize);

    @Override
     HashFloatFloatMap newMutableMap(Iterable<Float> keys,
            Iterable<Float> values);

    @Override
     HashFloatFloatMap newMutableMap(Iterable<Float> keys,
            Iterable<Float> values, int expectedSize);


    @Override
     HashFloatFloatMap newMutableMapOf(float k1, float v1);

    @Override
     HashFloatFloatMap newMutableMapOf(float k1, float v1,
            float k2, float v2);

    @Override
     HashFloatFloatMap newMutableMapOf(float k1, float v1,
            float k2, float v2, float k3, float v3);

    @Override
     HashFloatFloatMap newMutableMapOf(float k1, float v1,
            float k2, float v2, float k3, float v3,
            float k4, float v4);

    @Override
     HashFloatFloatMap newMutableMapOf(float k1, float v1,
            float k2, float v2, float k3, float v3,
            float k4, float v4, float k5, float v5);
    @Override
     HashFloatFloatMap newUpdatableMap();

    @Override
     HashFloatFloatMap newUpdatableMap(int expectedSize);

    


    @Override
     HashFloatFloatMap newUpdatableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, int expectedSize);

    @Override
     HashFloatFloatMap newUpdatableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3, int expectedSize);

    @Override
     HashFloatFloatMap newUpdatableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4, int expectedSize);

    @Override
     HashFloatFloatMap newUpdatableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4, Map<Float, Float> map5, int expectedSize);

    

    
    @Override
     HashFloatFloatMap newUpdatableMap(Map<Float, Float> map);

    @Override
     HashFloatFloatMap newUpdatableMap(Map<Float, Float> map1,
            Map<Float, Float> map2);

    @Override
     HashFloatFloatMap newUpdatableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3);

    @Override
     HashFloatFloatMap newUpdatableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4);

    @Override
     HashFloatFloatMap newUpdatableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4, Map<Float, Float> map5);


    @Override
     HashFloatFloatMap newUpdatableMap(
            net.openhft.function.Consumer<FloatFloatConsumer> entriesSupplier);

    @Override
     HashFloatFloatMap newUpdatableMap(
            net.openhft.function.Consumer<FloatFloatConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashFloatFloatMap newUpdatableMap(float[] keys, float[] values);

    @Override
     HashFloatFloatMap newUpdatableMap(float[] keys, float[] values,
            int expectedSize);

    @Override
     HashFloatFloatMap newUpdatableMap(
            Float[] keys, Float[] values);

    @Override
     HashFloatFloatMap newUpdatableMap(
            Float[] keys, Float[] values, int expectedSize);

    @Override
     HashFloatFloatMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Float> values);

    @Override
     HashFloatFloatMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Float> values, int expectedSize);


    @Override
     HashFloatFloatMap newUpdatableMapOf(float k1, float v1);

    @Override
     HashFloatFloatMap newUpdatableMapOf(float k1, float v1,
            float k2, float v2);

    @Override
     HashFloatFloatMap newUpdatableMapOf(float k1, float v1,
            float k2, float v2, float k3, float v3);

    @Override
     HashFloatFloatMap newUpdatableMapOf(float k1, float v1,
            float k2, float v2, float k3, float v3,
            float k4, float v4);

    @Override
     HashFloatFloatMap newUpdatableMapOf(float k1, float v1,
            float k2, float v2, float k3, float v3,
            float k4, float v4, float k5, float v5);

    


    @Override
     HashFloatFloatMap newImmutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, int expectedSize);

    @Override
     HashFloatFloatMap newImmutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3, int expectedSize);

    @Override
     HashFloatFloatMap newImmutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4, int expectedSize);

    @Override
     HashFloatFloatMap newImmutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4, Map<Float, Float> map5, int expectedSize);

    

    
    @Override
     HashFloatFloatMap newImmutableMap(Map<Float, Float> map);

    @Override
     HashFloatFloatMap newImmutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2);

    @Override
     HashFloatFloatMap newImmutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3);

    @Override
     HashFloatFloatMap newImmutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4);

    @Override
     HashFloatFloatMap newImmutableMap(Map<Float, Float> map1,
            Map<Float, Float> map2, Map<Float, Float> map3,
            Map<Float, Float> map4, Map<Float, Float> map5);


    @Override
     HashFloatFloatMap newImmutableMap(
            net.openhft.function.Consumer<FloatFloatConsumer> entriesSupplier);

    @Override
     HashFloatFloatMap newImmutableMap(
            net.openhft.function.Consumer<FloatFloatConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashFloatFloatMap newImmutableMap(float[] keys, float[] values);

    @Override
     HashFloatFloatMap newImmutableMap(float[] keys, float[] values,
            int expectedSize);

    @Override
     HashFloatFloatMap newImmutableMap(
            Float[] keys, Float[] values);

    @Override
     HashFloatFloatMap newImmutableMap(
            Float[] keys, Float[] values, int expectedSize);

    @Override
     HashFloatFloatMap newImmutableMap(Iterable<Float> keys,
            Iterable<Float> values);

    @Override
     HashFloatFloatMap newImmutableMap(Iterable<Float> keys,
            Iterable<Float> values, int expectedSize);


    @Override
     HashFloatFloatMap newImmutableMapOf(float k1, float v1);

    @Override
     HashFloatFloatMap newImmutableMapOf(float k1, float v1,
            float k2, float v2);

    @Override
     HashFloatFloatMap newImmutableMapOf(float k1, float v1,
            float k2, float v2, float k3, float v3);

    @Override
     HashFloatFloatMap newImmutableMapOf(float k1, float v1,
            float k2, float v2, float k3, float v3,
            float k4, float v4);

    @Override
     HashFloatFloatMap newImmutableMapOf(float k1, float v1,
            float k2, float v2, float k3, float v3,
            float k4, float v4, float k5, float v5);
}

