/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.FloatDoubleConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashFloatDoubleMap}s, and
 * the default {@link HashFloatDoubleMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashFloatDoubleMap
 */
public final class HashFloatDoubleMaps {

    

    private static final ServiceLoader<HashFloatDoubleMapFactory> LOADER =
            ServiceLoader.load(HashFloatDoubleMapFactory.class);
    private static HashFloatDoubleMapFactory defaultFactory = null;

    public static HashFloatDoubleMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashFloatDoubleMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashFloatDoubleMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashFloatDoubleMap newMutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashFloatDoubleMap newMutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashFloatDoubleMap newMutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashFloatDoubleMap newMutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4, Map<Float, Double> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashFloatDoubleMap newMutableMap(
            Map<Float, Double> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashFloatDoubleMap newMutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashFloatDoubleMap newMutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashFloatDoubleMap newMutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashFloatDoubleMap newMutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4, Map<Float, Double> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashFloatDoubleMap newMutableMap(
            net.openhft.function.Consumer<FloatDoubleConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashFloatDoubleMap newMutableMap(
            net.openhft.function.Consumer<FloatDoubleConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashFloatDoubleMap newMutableMap(
            float[] keys, double[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashFloatDoubleMap newMutableMap(
            float[] keys, double[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashFloatDoubleMap newMutableMap(
            Float[] keys, Double[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashFloatDoubleMap newMutableMap(
            Float[] keys, Double[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashFloatDoubleMap newMutableMap(Iterable<Float> keys,
            Iterable<Double> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashFloatDoubleMap newMutableMap(Iterable<Float> keys,
            Iterable<Double> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashFloatDoubleMap newMutableMapOf(
            float k1, double v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashFloatDoubleMap newMutableMapOf(
            float k1, double v1, float k2, double v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashFloatDoubleMap newMutableMapOf(
            float k1, double v1, float k2, double v2,
            float k3, double v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashFloatDoubleMap newMutableMapOf(
            float k1, double v1, float k2, double v2,
            float k3, double v3, float k4, double v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashFloatDoubleMap newMutableMapOf(
            float k1, double v1, float k2, double v2,
            float k3, double v3, float k4, double v4,
            float k5, double v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashFloatDoubleMap newUpdatableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashFloatDoubleMap newUpdatableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashFloatDoubleMap newUpdatableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashFloatDoubleMap newUpdatableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4, Map<Float, Double> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashFloatDoubleMap newUpdatableMap(
            Map<Float, Double> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashFloatDoubleMap newUpdatableMap(Map<Float, Double> map1,
            Map<Float, Double> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashFloatDoubleMap newUpdatableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashFloatDoubleMap newUpdatableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashFloatDoubleMap newUpdatableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4, Map<Float, Double> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashFloatDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<FloatDoubleConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashFloatDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<FloatDoubleConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashFloatDoubleMap newUpdatableMap(
            float[] keys, double[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashFloatDoubleMap newUpdatableMap(
            float[] keys, double[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashFloatDoubleMap newUpdatableMap(
            Float[] keys, Double[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashFloatDoubleMap newUpdatableMap(
            Float[] keys, Double[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashFloatDoubleMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Double> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashFloatDoubleMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Double> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashFloatDoubleMap newUpdatableMapOf(
            float k1, double v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashFloatDoubleMap newUpdatableMapOf(
            float k1, double v1, float k2, double v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashFloatDoubleMap newUpdatableMapOf(
            float k1, double v1, float k2, double v2,
            float k3, double v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashFloatDoubleMap newUpdatableMapOf(
            float k1, double v1, float k2, double v2,
            float k3, double v3, float k4, double v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashFloatDoubleMap newUpdatableMapOf(
            float k1, double v1, float k2, double v2,
            float k3, double v3, float k4, double v4,
            float k5, double v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashFloatDoubleMap newImmutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashFloatDoubleMap newImmutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashFloatDoubleMap newImmutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashFloatDoubleMap newImmutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4, Map<Float, Double> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashFloatDoubleMap newImmutableMap(
            Map<Float, Double> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashFloatDoubleMap newImmutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashFloatDoubleMap newImmutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashFloatDoubleMap newImmutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashFloatDoubleMap newImmutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4, Map<Float, Double> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashFloatDoubleMap newImmutableMap(
            net.openhft.function.Consumer<FloatDoubleConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashFloatDoubleMap newImmutableMap(
            net.openhft.function.Consumer<FloatDoubleConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashFloatDoubleMap newImmutableMap(
            float[] keys, double[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashFloatDoubleMap newImmutableMap(
            float[] keys, double[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashFloatDoubleMap newImmutableMap(
            Float[] keys, Double[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashFloatDoubleMap newImmutableMap(
            Float[] keys, Double[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashFloatDoubleMap newImmutableMap(Iterable<Float> keys,
            Iterable<Double> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashFloatDoubleMap newImmutableMap(Iterable<Float> keys,
            Iterable<Double> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashFloatDoubleMap newImmutableMapOf(
            float k1, double v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashFloatDoubleMap newImmutableMapOf(
            float k1, double v1, float k2, double v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashFloatDoubleMap newImmutableMapOf(
            float k1, double v1, float k2, double v2,
            float k3, double v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashFloatDoubleMap newImmutableMapOf(
            float k1, double v1, float k2, double v2,
            float k3, double v3, float k4, double v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashFloatDoubleMap newImmutableMapOf(
            float k1, double v1, float k2, double v2,
            float k3, double v3, float k4, double v4,
            float k5, double v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashFloatDoubleMaps() {}
}

