/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.FloatDoubleConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashFloatDoubleMaps}
 *
 * @see HashFloatDoubleMap
 * @see HashFloatDoubleMaps#getDefaultFactory()
 */
public interface HashFloatDoubleMapFactory extends FloatDoubleMapFactory
        , HashContainerFactory<HashFloatDoubleMapFactory> {

    

    

    

    

    

    
    

    
    


    @Override
    HashFloatDoubleMapFactory withDefaultValue(double defaultValue);

    @Override
     HashFloatDoubleMap newMutableMap();

    @Override
     HashFloatDoubleMap newMutableMap(int expectedSize);

    


    @Override
     HashFloatDoubleMap newMutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, int expectedSize);

    @Override
     HashFloatDoubleMap newMutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3, int expectedSize);

    @Override
     HashFloatDoubleMap newMutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4, int expectedSize);

    @Override
     HashFloatDoubleMap newMutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4, Map<Float, Double> map5, int expectedSize);

    

    
    @Override
     HashFloatDoubleMap newMutableMap(Map<Float, Double> map);

    @Override
     HashFloatDoubleMap newMutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2);

    @Override
     HashFloatDoubleMap newMutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3);

    @Override
     HashFloatDoubleMap newMutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4);

    @Override
     HashFloatDoubleMap newMutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4, Map<Float, Double> map5);


    @Override
     HashFloatDoubleMap newMutableMap(
            net.openhft.function.Consumer<FloatDoubleConsumer> entriesSupplier);

    @Override
     HashFloatDoubleMap newMutableMap(
            net.openhft.function.Consumer<FloatDoubleConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashFloatDoubleMap newMutableMap(float[] keys, double[] values);

    @Override
     HashFloatDoubleMap newMutableMap(float[] keys, double[] values,
            int expectedSize);

    @Override
     HashFloatDoubleMap newMutableMap(
            Float[] keys, Double[] values);

    @Override
     HashFloatDoubleMap newMutableMap(
            Float[] keys, Double[] values, int expectedSize);

    @Override
     HashFloatDoubleMap newMutableMap(Iterable<Float> keys,
            Iterable<Double> values);

    @Override
     HashFloatDoubleMap newMutableMap(Iterable<Float> keys,
            Iterable<Double> values, int expectedSize);


    @Override
     HashFloatDoubleMap newMutableMapOf(float k1, double v1);

    @Override
     HashFloatDoubleMap newMutableMapOf(float k1, double v1,
            float k2, double v2);

    @Override
     HashFloatDoubleMap newMutableMapOf(float k1, double v1,
            float k2, double v2, float k3, double v3);

    @Override
     HashFloatDoubleMap newMutableMapOf(float k1, double v1,
            float k2, double v2, float k3, double v3,
            float k4, double v4);

    @Override
     HashFloatDoubleMap newMutableMapOf(float k1, double v1,
            float k2, double v2, float k3, double v3,
            float k4, double v4, float k5, double v5);
    @Override
     HashFloatDoubleMap newUpdatableMap();

    @Override
     HashFloatDoubleMap newUpdatableMap(int expectedSize);

    


    @Override
     HashFloatDoubleMap newUpdatableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, int expectedSize);

    @Override
     HashFloatDoubleMap newUpdatableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3, int expectedSize);

    @Override
     HashFloatDoubleMap newUpdatableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4, int expectedSize);

    @Override
     HashFloatDoubleMap newUpdatableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4, Map<Float, Double> map5, int expectedSize);

    

    
    @Override
     HashFloatDoubleMap newUpdatableMap(Map<Float, Double> map);

    @Override
     HashFloatDoubleMap newUpdatableMap(Map<Float, Double> map1,
            Map<Float, Double> map2);

    @Override
     HashFloatDoubleMap newUpdatableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3);

    @Override
     HashFloatDoubleMap newUpdatableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4);

    @Override
     HashFloatDoubleMap newUpdatableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4, Map<Float, Double> map5);


    @Override
     HashFloatDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<FloatDoubleConsumer> entriesSupplier);

    @Override
     HashFloatDoubleMap newUpdatableMap(
            net.openhft.function.Consumer<FloatDoubleConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashFloatDoubleMap newUpdatableMap(float[] keys, double[] values);

    @Override
     HashFloatDoubleMap newUpdatableMap(float[] keys, double[] values,
            int expectedSize);

    @Override
     HashFloatDoubleMap newUpdatableMap(
            Float[] keys, Double[] values);

    @Override
     HashFloatDoubleMap newUpdatableMap(
            Float[] keys, Double[] values, int expectedSize);

    @Override
     HashFloatDoubleMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Double> values);

    @Override
     HashFloatDoubleMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Double> values, int expectedSize);


    @Override
     HashFloatDoubleMap newUpdatableMapOf(float k1, double v1);

    @Override
     HashFloatDoubleMap newUpdatableMapOf(float k1, double v1,
            float k2, double v2);

    @Override
     HashFloatDoubleMap newUpdatableMapOf(float k1, double v1,
            float k2, double v2, float k3, double v3);

    @Override
     HashFloatDoubleMap newUpdatableMapOf(float k1, double v1,
            float k2, double v2, float k3, double v3,
            float k4, double v4);

    @Override
     HashFloatDoubleMap newUpdatableMapOf(float k1, double v1,
            float k2, double v2, float k3, double v3,
            float k4, double v4, float k5, double v5);

    


    @Override
     HashFloatDoubleMap newImmutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, int expectedSize);

    @Override
     HashFloatDoubleMap newImmutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3, int expectedSize);

    @Override
     HashFloatDoubleMap newImmutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4, int expectedSize);

    @Override
     HashFloatDoubleMap newImmutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4, Map<Float, Double> map5, int expectedSize);

    

    
    @Override
     HashFloatDoubleMap newImmutableMap(Map<Float, Double> map);

    @Override
     HashFloatDoubleMap newImmutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2);

    @Override
     HashFloatDoubleMap newImmutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3);

    @Override
     HashFloatDoubleMap newImmutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4);

    @Override
     HashFloatDoubleMap newImmutableMap(Map<Float, Double> map1,
            Map<Float, Double> map2, Map<Float, Double> map3,
            Map<Float, Double> map4, Map<Float, Double> map5);


    @Override
     HashFloatDoubleMap newImmutableMap(
            net.openhft.function.Consumer<FloatDoubleConsumer> entriesSupplier);

    @Override
     HashFloatDoubleMap newImmutableMap(
            net.openhft.function.Consumer<FloatDoubleConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashFloatDoubleMap newImmutableMap(float[] keys, double[] values);

    @Override
     HashFloatDoubleMap newImmutableMap(float[] keys, double[] values,
            int expectedSize);

    @Override
     HashFloatDoubleMap newImmutableMap(
            Float[] keys, Double[] values);

    @Override
     HashFloatDoubleMap newImmutableMap(
            Float[] keys, Double[] values, int expectedSize);

    @Override
     HashFloatDoubleMap newImmutableMap(Iterable<Float> keys,
            Iterable<Double> values);

    @Override
     HashFloatDoubleMap newImmutableMap(Iterable<Float> keys,
            Iterable<Double> values, int expectedSize);


    @Override
     HashFloatDoubleMap newImmutableMapOf(float k1, double v1);

    @Override
     HashFloatDoubleMap newImmutableMapOf(float k1, double v1,
            float k2, double v2);

    @Override
     HashFloatDoubleMap newImmutableMapOf(float k1, double v1,
            float k2, double v2, float k3, double v3);

    @Override
     HashFloatDoubleMap newImmutableMapOf(float k1, double v1,
            float k2, double v2, float k3, double v3,
            float k4, double v4);

    @Override
     HashFloatDoubleMap newImmutableMapOf(float k1, double v1,
            float k2, double v2, float k3, double v3,
            float k4, double v4, float k5, double v5);
}

