/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.FloatCharConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashFloatCharMap}s, and
 * the default {@link HashFloatCharMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashFloatCharMap
 */
public final class HashFloatCharMaps {

    

    private static final ServiceLoader<HashFloatCharMapFactory> LOADER =
            ServiceLoader.load(HashFloatCharMapFactory.class);
    private static HashFloatCharMapFactory defaultFactory = null;

    public static HashFloatCharMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashFloatCharMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashFloatCharMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashFloatCharMap newMutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashFloatCharMap newMutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashFloatCharMap newMutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashFloatCharMap newMutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4, Map<Float, Character> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashFloatCharMap newMutableMap(
            Map<Float, Character> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashFloatCharMap newMutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashFloatCharMap newMutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashFloatCharMap newMutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashFloatCharMap newMutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4, Map<Float, Character> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashFloatCharMap newMutableMap(
            net.openhft.function.Consumer<FloatCharConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashFloatCharMap newMutableMap(
            net.openhft.function.Consumer<FloatCharConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashFloatCharMap newMutableMap(
            float[] keys, char[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashFloatCharMap newMutableMap(
            float[] keys, char[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashFloatCharMap newMutableMap(
            Float[] keys, Character[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashFloatCharMap newMutableMap(
            Float[] keys, Character[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashFloatCharMap newMutableMap(Iterable<Float> keys,
            Iterable<Character> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashFloatCharMap newMutableMap(Iterable<Float> keys,
            Iterable<Character> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashFloatCharMap newMutableMapOf(
            float k1, char v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashFloatCharMap newMutableMapOf(
            float k1, char v1, float k2, char v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashFloatCharMap newMutableMapOf(
            float k1, char v1, float k2, char v2,
            float k3, char v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashFloatCharMap newMutableMapOf(
            float k1, char v1, float k2, char v2,
            float k3, char v3, float k4, char v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashFloatCharMap newMutableMapOf(
            float k1, char v1, float k2, char v2,
            float k3, char v3, float k4, char v4,
            float k5, char v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashFloatCharMap newUpdatableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashFloatCharMap newUpdatableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashFloatCharMap newUpdatableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashFloatCharMap newUpdatableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4, Map<Float, Character> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashFloatCharMap newUpdatableMap(
            Map<Float, Character> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashFloatCharMap newUpdatableMap(Map<Float, Character> map1,
            Map<Float, Character> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashFloatCharMap newUpdatableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashFloatCharMap newUpdatableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashFloatCharMap newUpdatableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4, Map<Float, Character> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashFloatCharMap newUpdatableMap(
            net.openhft.function.Consumer<FloatCharConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashFloatCharMap newUpdatableMap(
            net.openhft.function.Consumer<FloatCharConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashFloatCharMap newUpdatableMap(
            float[] keys, char[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashFloatCharMap newUpdatableMap(
            float[] keys, char[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashFloatCharMap newUpdatableMap(
            Float[] keys, Character[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashFloatCharMap newUpdatableMap(
            Float[] keys, Character[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashFloatCharMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Character> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashFloatCharMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Character> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashFloatCharMap newUpdatableMapOf(
            float k1, char v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashFloatCharMap newUpdatableMapOf(
            float k1, char v1, float k2, char v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashFloatCharMap newUpdatableMapOf(
            float k1, char v1, float k2, char v2,
            float k3, char v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashFloatCharMap newUpdatableMapOf(
            float k1, char v1, float k2, char v2,
            float k3, char v3, float k4, char v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashFloatCharMap newUpdatableMapOf(
            float k1, char v1, float k2, char v2,
            float k3, char v3, float k4, char v4,
            float k5, char v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashFloatCharMap newImmutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashFloatCharMap newImmutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashFloatCharMap newImmutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashFloatCharMap newImmutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4, Map<Float, Character> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashFloatCharMap newImmutableMap(
            Map<Float, Character> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashFloatCharMap newImmutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashFloatCharMap newImmutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashFloatCharMap newImmutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashFloatCharMap newImmutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4, Map<Float, Character> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashFloatCharMap newImmutableMap(
            net.openhft.function.Consumer<FloatCharConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashFloatCharMap newImmutableMap(
            net.openhft.function.Consumer<FloatCharConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashFloatCharMap newImmutableMap(
            float[] keys, char[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashFloatCharMap newImmutableMap(
            float[] keys, char[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashFloatCharMap newImmutableMap(
            Float[] keys, Character[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashFloatCharMap newImmutableMap(
            Float[] keys, Character[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashFloatCharMap newImmutableMap(Iterable<Float> keys,
            Iterable<Character> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashFloatCharMap newImmutableMap(Iterable<Float> keys,
            Iterable<Character> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashFloatCharMap newImmutableMapOf(
            float k1, char v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashFloatCharMap newImmutableMapOf(
            float k1, char v1, float k2, char v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashFloatCharMap newImmutableMapOf(
            float k1, char v1, float k2, char v2,
            float k3, char v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashFloatCharMap newImmutableMapOf(
            float k1, char v1, float k2, char v2,
            float k3, char v3, float k4, char v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashFloatCharMap newImmutableMapOf(
            float k1, char v1, float k2, char v2,
            float k3, char v3, float k4, char v4,
            float k5, char v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashFloatCharMaps() {}
}

