/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.FloatCharConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashFloatCharMaps}
 *
 * @see HashFloatCharMap
 * @see HashFloatCharMaps#getDefaultFactory()
 */
public interface HashFloatCharMapFactory extends FloatCharMapFactory
        , HashContainerFactory<HashFloatCharMapFactory> {

    

    

    

    

    

    
    

    
    


    @Override
    HashFloatCharMapFactory withDefaultValue(char defaultValue);

    @Override
     HashFloatCharMap newMutableMap();

    @Override
     HashFloatCharMap newMutableMap(int expectedSize);

    


    @Override
     HashFloatCharMap newMutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, int expectedSize);

    @Override
     HashFloatCharMap newMutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3, int expectedSize);

    @Override
     HashFloatCharMap newMutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4, int expectedSize);

    @Override
     HashFloatCharMap newMutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4, Map<Float, Character> map5, int expectedSize);

    

    
    @Override
     HashFloatCharMap newMutableMap(Map<Float, Character> map);

    @Override
     HashFloatCharMap newMutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2);

    @Override
     HashFloatCharMap newMutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3);

    @Override
     HashFloatCharMap newMutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4);

    @Override
     HashFloatCharMap newMutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4, Map<Float, Character> map5);


    @Override
     HashFloatCharMap newMutableMap(
            net.openhft.function.Consumer<FloatCharConsumer> entriesSupplier);

    @Override
     HashFloatCharMap newMutableMap(
            net.openhft.function.Consumer<FloatCharConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashFloatCharMap newMutableMap(float[] keys, char[] values);

    @Override
     HashFloatCharMap newMutableMap(float[] keys, char[] values,
            int expectedSize);

    @Override
     HashFloatCharMap newMutableMap(
            Float[] keys, Character[] values);

    @Override
     HashFloatCharMap newMutableMap(
            Float[] keys, Character[] values, int expectedSize);

    @Override
     HashFloatCharMap newMutableMap(Iterable<Float> keys,
            Iterable<Character> values);

    @Override
     HashFloatCharMap newMutableMap(Iterable<Float> keys,
            Iterable<Character> values, int expectedSize);


    @Override
     HashFloatCharMap newMutableMapOf(float k1, char v1);

    @Override
     HashFloatCharMap newMutableMapOf(float k1, char v1,
            float k2, char v2);

    @Override
     HashFloatCharMap newMutableMapOf(float k1, char v1,
            float k2, char v2, float k3, char v3);

    @Override
     HashFloatCharMap newMutableMapOf(float k1, char v1,
            float k2, char v2, float k3, char v3,
            float k4, char v4);

    @Override
     HashFloatCharMap newMutableMapOf(float k1, char v1,
            float k2, char v2, float k3, char v3,
            float k4, char v4, float k5, char v5);
    @Override
     HashFloatCharMap newUpdatableMap();

    @Override
     HashFloatCharMap newUpdatableMap(int expectedSize);

    


    @Override
     HashFloatCharMap newUpdatableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, int expectedSize);

    @Override
     HashFloatCharMap newUpdatableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3, int expectedSize);

    @Override
     HashFloatCharMap newUpdatableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4, int expectedSize);

    @Override
     HashFloatCharMap newUpdatableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4, Map<Float, Character> map5, int expectedSize);

    

    
    @Override
     HashFloatCharMap newUpdatableMap(Map<Float, Character> map);

    @Override
     HashFloatCharMap newUpdatableMap(Map<Float, Character> map1,
            Map<Float, Character> map2);

    @Override
     HashFloatCharMap newUpdatableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3);

    @Override
     HashFloatCharMap newUpdatableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4);

    @Override
     HashFloatCharMap newUpdatableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4, Map<Float, Character> map5);


    @Override
     HashFloatCharMap newUpdatableMap(
            net.openhft.function.Consumer<FloatCharConsumer> entriesSupplier);

    @Override
     HashFloatCharMap newUpdatableMap(
            net.openhft.function.Consumer<FloatCharConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashFloatCharMap newUpdatableMap(float[] keys, char[] values);

    @Override
     HashFloatCharMap newUpdatableMap(float[] keys, char[] values,
            int expectedSize);

    @Override
     HashFloatCharMap newUpdatableMap(
            Float[] keys, Character[] values);

    @Override
     HashFloatCharMap newUpdatableMap(
            Float[] keys, Character[] values, int expectedSize);

    @Override
     HashFloatCharMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Character> values);

    @Override
     HashFloatCharMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Character> values, int expectedSize);


    @Override
     HashFloatCharMap newUpdatableMapOf(float k1, char v1);

    @Override
     HashFloatCharMap newUpdatableMapOf(float k1, char v1,
            float k2, char v2);

    @Override
     HashFloatCharMap newUpdatableMapOf(float k1, char v1,
            float k2, char v2, float k3, char v3);

    @Override
     HashFloatCharMap newUpdatableMapOf(float k1, char v1,
            float k2, char v2, float k3, char v3,
            float k4, char v4);

    @Override
     HashFloatCharMap newUpdatableMapOf(float k1, char v1,
            float k2, char v2, float k3, char v3,
            float k4, char v4, float k5, char v5);

    


    @Override
     HashFloatCharMap newImmutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, int expectedSize);

    @Override
     HashFloatCharMap newImmutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3, int expectedSize);

    @Override
     HashFloatCharMap newImmutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4, int expectedSize);

    @Override
     HashFloatCharMap newImmutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4, Map<Float, Character> map5, int expectedSize);

    

    
    @Override
     HashFloatCharMap newImmutableMap(Map<Float, Character> map);

    @Override
     HashFloatCharMap newImmutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2);

    @Override
     HashFloatCharMap newImmutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3);

    @Override
     HashFloatCharMap newImmutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4);

    @Override
     HashFloatCharMap newImmutableMap(Map<Float, Character> map1,
            Map<Float, Character> map2, Map<Float, Character> map3,
            Map<Float, Character> map4, Map<Float, Character> map5);


    @Override
     HashFloatCharMap newImmutableMap(
            net.openhft.function.Consumer<FloatCharConsumer> entriesSupplier);

    @Override
     HashFloatCharMap newImmutableMap(
            net.openhft.function.Consumer<FloatCharConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashFloatCharMap newImmutableMap(float[] keys, char[] values);

    @Override
     HashFloatCharMap newImmutableMap(float[] keys, char[] values,
            int expectedSize);

    @Override
     HashFloatCharMap newImmutableMap(
            Float[] keys, Character[] values);

    @Override
     HashFloatCharMap newImmutableMap(
            Float[] keys, Character[] values, int expectedSize);

    @Override
     HashFloatCharMap newImmutableMap(Iterable<Float> keys,
            Iterable<Character> values);

    @Override
     HashFloatCharMap newImmutableMap(Iterable<Float> keys,
            Iterable<Character> values, int expectedSize);


    @Override
     HashFloatCharMap newImmutableMapOf(float k1, char v1);

    @Override
     HashFloatCharMap newImmutableMapOf(float k1, char v1,
            float k2, char v2);

    @Override
     HashFloatCharMap newImmutableMapOf(float k1, char v1,
            float k2, char v2, float k3, char v3);

    @Override
     HashFloatCharMap newImmutableMapOf(float k1, char v1,
            float k2, char v2, float k3, char v3,
            float k4, char v4);

    @Override
     HashFloatCharMap newImmutableMapOf(float k1, char v1,
            float k2, char v2, float k3, char v3,
            float k4, char v4, float k5, char v5);
}

