/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.FloatByteConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashFloatByteMap}s, and
 * the default {@link HashFloatByteMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashFloatByteMap
 */
public final class HashFloatByteMaps {

    

    private static final ServiceLoader<HashFloatByteMapFactory> LOADER =
            ServiceLoader.load(HashFloatByteMapFactory.class);
    private static HashFloatByteMapFactory defaultFactory = null;

    public static HashFloatByteMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashFloatByteMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashFloatByteMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashFloatByteMap newMutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashFloatByteMap newMutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashFloatByteMap newMutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashFloatByteMap newMutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4, Map<Float, Byte> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashFloatByteMap newMutableMap(
            Map<Float, Byte> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashFloatByteMap newMutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashFloatByteMap newMutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashFloatByteMap newMutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashFloatByteMap newMutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4, Map<Float, Byte> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashFloatByteMap newMutableMap(
            net.openhft.function.Consumer<FloatByteConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashFloatByteMap newMutableMap(
            net.openhft.function.Consumer<FloatByteConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashFloatByteMap newMutableMap(
            float[] keys, byte[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashFloatByteMap newMutableMap(
            float[] keys, byte[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashFloatByteMap newMutableMap(
            Float[] keys, Byte[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashFloatByteMap newMutableMap(
            Float[] keys, Byte[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashFloatByteMap newMutableMap(Iterable<Float> keys,
            Iterable<Byte> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashFloatByteMap newMutableMap(Iterable<Float> keys,
            Iterable<Byte> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashFloatByteMap newMutableMapOf(
            float k1, byte v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashFloatByteMap newMutableMapOf(
            float k1, byte v1, float k2, byte v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashFloatByteMap newMutableMapOf(
            float k1, byte v1, float k2, byte v2,
            float k3, byte v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashFloatByteMap newMutableMapOf(
            float k1, byte v1, float k2, byte v2,
            float k3, byte v3, float k4, byte v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashFloatByteMap newMutableMapOf(
            float k1, byte v1, float k2, byte v2,
            float k3, byte v3, float k4, byte v4,
            float k5, byte v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashFloatByteMap newUpdatableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashFloatByteMap newUpdatableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashFloatByteMap newUpdatableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashFloatByteMap newUpdatableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4, Map<Float, Byte> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashFloatByteMap newUpdatableMap(
            Map<Float, Byte> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashFloatByteMap newUpdatableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashFloatByteMap newUpdatableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashFloatByteMap newUpdatableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashFloatByteMap newUpdatableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4, Map<Float, Byte> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashFloatByteMap newUpdatableMap(
            net.openhft.function.Consumer<FloatByteConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashFloatByteMap newUpdatableMap(
            net.openhft.function.Consumer<FloatByteConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashFloatByteMap newUpdatableMap(
            float[] keys, byte[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashFloatByteMap newUpdatableMap(
            float[] keys, byte[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashFloatByteMap newUpdatableMap(
            Float[] keys, Byte[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashFloatByteMap newUpdatableMap(
            Float[] keys, Byte[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashFloatByteMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Byte> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashFloatByteMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Byte> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashFloatByteMap newUpdatableMapOf(
            float k1, byte v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashFloatByteMap newUpdatableMapOf(
            float k1, byte v1, float k2, byte v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashFloatByteMap newUpdatableMapOf(
            float k1, byte v1, float k2, byte v2,
            float k3, byte v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashFloatByteMap newUpdatableMapOf(
            float k1, byte v1, float k2, byte v2,
            float k3, byte v3, float k4, byte v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashFloatByteMap newUpdatableMapOf(
            float k1, byte v1, float k2, byte v2,
            float k3, byte v3, float k4, byte v4,
            float k5, byte v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashFloatByteMap newImmutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashFloatByteMap newImmutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashFloatByteMap newImmutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashFloatByteMap newImmutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4, Map<Float, Byte> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashFloatByteMap newImmutableMap(
            Map<Float, Byte> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashFloatByteMap newImmutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashFloatByteMap newImmutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashFloatByteMap newImmutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashFloatByteMap newImmutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4, Map<Float, Byte> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashFloatByteMap newImmutableMap(
            net.openhft.function.Consumer<FloatByteConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashFloatByteMap newImmutableMap(
            net.openhft.function.Consumer<FloatByteConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashFloatByteMap newImmutableMap(
            float[] keys, byte[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashFloatByteMap newImmutableMap(
            float[] keys, byte[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashFloatByteMap newImmutableMap(
            Float[] keys, Byte[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashFloatByteMap newImmutableMap(
            Float[] keys, Byte[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashFloatByteMap newImmutableMap(Iterable<Float> keys,
            Iterable<Byte> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashFloatByteMap newImmutableMap(Iterable<Float> keys,
            Iterable<Byte> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashFloatByteMap newImmutableMapOf(
            float k1, byte v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashFloatByteMap newImmutableMapOf(
            float k1, byte v1, float k2, byte v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashFloatByteMap newImmutableMapOf(
            float k1, byte v1, float k2, byte v2,
            float k3, byte v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashFloatByteMap newImmutableMapOf(
            float k1, byte v1, float k2, byte v2,
            float k3, byte v3, float k4, byte v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashFloatByteMap newImmutableMapOf(
            float k1, byte v1, float k2, byte v2,
            float k3, byte v3, float k4, byte v4,
            float k5, byte v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashFloatByteMaps() {}
}

