/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.FloatByteConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashFloatByteMaps}
 *
 * @see HashFloatByteMap
 * @see HashFloatByteMaps#getDefaultFactory()
 */
public interface HashFloatByteMapFactory extends FloatByteMapFactory
        , HashContainerFactory<HashFloatByteMapFactory> {

    

    

    

    

    

    
    

    
    


    @Override
    HashFloatByteMapFactory withDefaultValue(byte defaultValue);

    @Override
     HashFloatByteMap newMutableMap();

    @Override
     HashFloatByteMap newMutableMap(int expectedSize);

    


    @Override
     HashFloatByteMap newMutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, int expectedSize);

    @Override
     HashFloatByteMap newMutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3, int expectedSize);

    @Override
     HashFloatByteMap newMutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4, int expectedSize);

    @Override
     HashFloatByteMap newMutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4, Map<Float, Byte> map5, int expectedSize);

    

    
    @Override
     HashFloatByteMap newMutableMap(Map<Float, Byte> map);

    @Override
     HashFloatByteMap newMutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2);

    @Override
     HashFloatByteMap newMutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3);

    @Override
     HashFloatByteMap newMutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4);

    @Override
     HashFloatByteMap newMutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4, Map<Float, Byte> map5);


    @Override
     HashFloatByteMap newMutableMap(
            net.openhft.function.Consumer<FloatByteConsumer> entriesSupplier);

    @Override
     HashFloatByteMap newMutableMap(
            net.openhft.function.Consumer<FloatByteConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashFloatByteMap newMutableMap(float[] keys, byte[] values);

    @Override
     HashFloatByteMap newMutableMap(float[] keys, byte[] values,
            int expectedSize);

    @Override
     HashFloatByteMap newMutableMap(
            Float[] keys, Byte[] values);

    @Override
     HashFloatByteMap newMutableMap(
            Float[] keys, Byte[] values, int expectedSize);

    @Override
     HashFloatByteMap newMutableMap(Iterable<Float> keys,
            Iterable<Byte> values);

    @Override
     HashFloatByteMap newMutableMap(Iterable<Float> keys,
            Iterable<Byte> values, int expectedSize);


    @Override
     HashFloatByteMap newMutableMapOf(float k1, byte v1);

    @Override
     HashFloatByteMap newMutableMapOf(float k1, byte v1,
            float k2, byte v2);

    @Override
     HashFloatByteMap newMutableMapOf(float k1, byte v1,
            float k2, byte v2, float k3, byte v3);

    @Override
     HashFloatByteMap newMutableMapOf(float k1, byte v1,
            float k2, byte v2, float k3, byte v3,
            float k4, byte v4);

    @Override
     HashFloatByteMap newMutableMapOf(float k1, byte v1,
            float k2, byte v2, float k3, byte v3,
            float k4, byte v4, float k5, byte v5);
    @Override
     HashFloatByteMap newUpdatableMap();

    @Override
     HashFloatByteMap newUpdatableMap(int expectedSize);

    


    @Override
     HashFloatByteMap newUpdatableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, int expectedSize);

    @Override
     HashFloatByteMap newUpdatableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3, int expectedSize);

    @Override
     HashFloatByteMap newUpdatableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4, int expectedSize);

    @Override
     HashFloatByteMap newUpdatableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4, Map<Float, Byte> map5, int expectedSize);

    

    
    @Override
     HashFloatByteMap newUpdatableMap(Map<Float, Byte> map);

    @Override
     HashFloatByteMap newUpdatableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2);

    @Override
     HashFloatByteMap newUpdatableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3);

    @Override
     HashFloatByteMap newUpdatableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4);

    @Override
     HashFloatByteMap newUpdatableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4, Map<Float, Byte> map5);


    @Override
     HashFloatByteMap newUpdatableMap(
            net.openhft.function.Consumer<FloatByteConsumer> entriesSupplier);

    @Override
     HashFloatByteMap newUpdatableMap(
            net.openhft.function.Consumer<FloatByteConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashFloatByteMap newUpdatableMap(float[] keys, byte[] values);

    @Override
     HashFloatByteMap newUpdatableMap(float[] keys, byte[] values,
            int expectedSize);

    @Override
     HashFloatByteMap newUpdatableMap(
            Float[] keys, Byte[] values);

    @Override
     HashFloatByteMap newUpdatableMap(
            Float[] keys, Byte[] values, int expectedSize);

    @Override
     HashFloatByteMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Byte> values);

    @Override
     HashFloatByteMap newUpdatableMap(Iterable<Float> keys,
            Iterable<Byte> values, int expectedSize);


    @Override
     HashFloatByteMap newUpdatableMapOf(float k1, byte v1);

    @Override
     HashFloatByteMap newUpdatableMapOf(float k1, byte v1,
            float k2, byte v2);

    @Override
     HashFloatByteMap newUpdatableMapOf(float k1, byte v1,
            float k2, byte v2, float k3, byte v3);

    @Override
     HashFloatByteMap newUpdatableMapOf(float k1, byte v1,
            float k2, byte v2, float k3, byte v3,
            float k4, byte v4);

    @Override
     HashFloatByteMap newUpdatableMapOf(float k1, byte v1,
            float k2, byte v2, float k3, byte v3,
            float k4, byte v4, float k5, byte v5);

    


    @Override
     HashFloatByteMap newImmutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, int expectedSize);

    @Override
     HashFloatByteMap newImmutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3, int expectedSize);

    @Override
     HashFloatByteMap newImmutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4, int expectedSize);

    @Override
     HashFloatByteMap newImmutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4, Map<Float, Byte> map5, int expectedSize);

    

    
    @Override
     HashFloatByteMap newImmutableMap(Map<Float, Byte> map);

    @Override
     HashFloatByteMap newImmutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2);

    @Override
     HashFloatByteMap newImmutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3);

    @Override
     HashFloatByteMap newImmutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4);

    @Override
     HashFloatByteMap newImmutableMap(Map<Float, Byte> map1,
            Map<Float, Byte> map2, Map<Float, Byte> map3,
            Map<Float, Byte> map4, Map<Float, Byte> map5);


    @Override
     HashFloatByteMap newImmutableMap(
            net.openhft.function.Consumer<FloatByteConsumer> entriesSupplier);

    @Override
     HashFloatByteMap newImmutableMap(
            net.openhft.function.Consumer<FloatByteConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashFloatByteMap newImmutableMap(float[] keys, byte[] values);

    @Override
     HashFloatByteMap newImmutableMap(float[] keys, byte[] values,
            int expectedSize);

    @Override
     HashFloatByteMap newImmutableMap(
            Float[] keys, Byte[] values);

    @Override
     HashFloatByteMap newImmutableMap(
            Float[] keys, Byte[] values, int expectedSize);

    @Override
     HashFloatByteMap newImmutableMap(Iterable<Float> keys,
            Iterable<Byte> values);

    @Override
     HashFloatByteMap newImmutableMap(Iterable<Float> keys,
            Iterable<Byte> values, int expectedSize);


    @Override
     HashFloatByteMap newImmutableMapOf(float k1, byte v1);

    @Override
     HashFloatByteMap newImmutableMapOf(float k1, byte v1,
            float k2, byte v2);

    @Override
     HashFloatByteMap newImmutableMapOf(float k1, byte v1,
            float k2, byte v2, float k3, byte v3);

    @Override
     HashFloatByteMap newImmutableMapOf(float k1, byte v1,
            float k2, byte v2, float k3, byte v3,
            float k4, byte v4);

    @Override
     HashFloatByteMap newImmutableMapOf(float k1, byte v1,
            float k2, byte v2, float k3, byte v3,
            float k4, byte v4, float k5, byte v5);
}

