/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.function.DoubleShortConsumer;

import java.util.Map;
import java.util.ServiceLoader;


/**
 * This class consists only of static factory methods to construct {@code HashDoubleShortMap}s, and
 * the default {@link HashDoubleShortMapFactory} static provider ({@link #getDefaultFactory()}).
 *
 * @see HashDoubleShortMap
 */
public final class HashDoubleShortMaps {

    

    private static final ServiceLoader<HashDoubleShortMapFactory> LOADER =
            ServiceLoader.load(HashDoubleShortMapFactory.class);
    private static HashDoubleShortMapFactory defaultFactory = null;

    public static HashDoubleShortMapFactory getDefaultFactory() {
        if (defaultFactory != null) {
            return defaultFactory;
        } else {
            // synchronization?
            return defaultFactory = LOADER.iterator().next();
        }
    }

    

    

    

    public static  HashDoubleShortMap newMutableMap() {
        return getDefaultFactory().newMutableMap();
    }

    public static  HashDoubleShortMap newMutableMap(int expectedSize) {
        return getDefaultFactory().newMutableMap(expectedSize);
    }



    
    


    public static  HashDoubleShortMap newMutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, expectedSize);
    }

    public static  HashDoubleShortMap newMutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashDoubleShortMap newMutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashDoubleShortMap newMutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4, Map<Double, Short> map5, int expectedSize) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashDoubleShortMap newMutableMap(
            Map<Double, Short> map) {
        return getDefaultFactory().newMutableMap(map);
    }

    public static  HashDoubleShortMap newMutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2) {
        return getDefaultFactory().newMutableMap(map1, map2);
    }

    public static  HashDoubleShortMap newMutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3) {
        return getDefaultFactory().newMutableMap(map1, map2, map3);
    }

    public static  HashDoubleShortMap newMutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4);
    }

    public static  HashDoubleShortMap newMutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4, Map<Double, Short> map5) {
        return getDefaultFactory().newMutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashDoubleShortMap newMutableMap(
            net.openhft.function.Consumer<DoubleShortConsumer> entriesSupplier) {
        return getDefaultFactory().newMutableMap(entriesSupplier);
    }

    public static  HashDoubleShortMap newMutableMap(
            net.openhft.function.Consumer<DoubleShortConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newMutableMap(entriesSupplier, expectedSize);
    }

    public static  HashDoubleShortMap newMutableMap(
            double[] keys, short[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashDoubleShortMap newMutableMap(
            double[] keys, short[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashDoubleShortMap newMutableMap(
            Double[] keys, Short[] values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashDoubleShortMap newMutableMap(
            Double[] keys, Short[] values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }

    public static  HashDoubleShortMap newMutableMap(Iterable<Double> keys,
            Iterable<Short> values) {
        return getDefaultFactory().newMutableMap(keys, values);
    }

    public static  HashDoubleShortMap newMutableMap(Iterable<Double> keys,
            Iterable<Short> values, int expectedSize) {
        return getDefaultFactory().newMutableMap(keys, values, expectedSize);
    }


    public static  HashDoubleShortMap newMutableMapOf(
            double k1, short v1) {
        return getDefaultFactory().newMutableMapOf(k1, v1);
    }

    public static  HashDoubleShortMap newMutableMapOf(
            double k1, short v1, double k2, short v2) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2);
    }

    public static  HashDoubleShortMap newMutableMapOf(
            double k1, short v1, double k2, short v2,
            double k3, short v3) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashDoubleShortMap newMutableMapOf(
            double k1, short v1, double k2, short v2,
            double k3, short v3, double k4, short v4) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashDoubleShortMap newMutableMapOf(
            double k1, short v1, double k2, short v2,
            double k3, short v3, double k4, short v4,
            double k5, short v5) {
        return getDefaultFactory().newMutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashDoubleShortMap newUpdatableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, expectedSize);
    }

    public static  HashDoubleShortMap newUpdatableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, expectedSize);
    }

    public static  HashDoubleShortMap newUpdatableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashDoubleShortMap newUpdatableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4, Map<Double, Short> map5, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashDoubleShortMap newUpdatableMap(
            Map<Double, Short> map) {
        return getDefaultFactory().newUpdatableMap(map);
    }

    public static  HashDoubleShortMap newUpdatableMap(Map<Double, Short> map1,
            Map<Double, Short> map2) {
        return getDefaultFactory().newUpdatableMap(map1, map2);
    }

    public static  HashDoubleShortMap newUpdatableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3);
    }

    public static  HashDoubleShortMap newUpdatableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4);
    }

    public static  HashDoubleShortMap newUpdatableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4, Map<Double, Short> map5) {
        return getDefaultFactory().newUpdatableMap(map1, map2, map3, map4, map5);
    }


    public static  HashDoubleShortMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleShortConsumer> entriesSupplier) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier);
    }

    public static  HashDoubleShortMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleShortConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newUpdatableMap(entriesSupplier, expectedSize);
    }

    public static  HashDoubleShortMap newUpdatableMap(
            double[] keys, short[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashDoubleShortMap newUpdatableMap(
            double[] keys, short[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashDoubleShortMap newUpdatableMap(
            Double[] keys, Short[] values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashDoubleShortMap newUpdatableMap(
            Double[] keys, Short[] values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }

    public static  HashDoubleShortMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Short> values) {
        return getDefaultFactory().newUpdatableMap(keys, values);
    }

    public static  HashDoubleShortMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Short> values, int expectedSize) {
        return getDefaultFactory().newUpdatableMap(keys, values, expectedSize);
    }


    public static  HashDoubleShortMap newUpdatableMapOf(
            double k1, short v1) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1);
    }

    public static  HashDoubleShortMap newUpdatableMapOf(
            double k1, short v1, double k2, short v2) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2);
    }

    public static  HashDoubleShortMap newUpdatableMapOf(
            double k1, short v1, double k2, short v2,
            double k3, short v3) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashDoubleShortMap newUpdatableMapOf(
            double k1, short v1, double k2, short v2,
            double k3, short v3, double k4, short v4) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashDoubleShortMap newUpdatableMapOf(
            double k1, short v1, double k2, short v2,
            double k3, short v3, double k4, short v4,
            double k5, short v5) {
        return getDefaultFactory().newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    
    


    public static  HashDoubleShortMap newImmutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, expectedSize);
    }

    public static  HashDoubleShortMap newImmutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, expectedSize);
    }

    public static  HashDoubleShortMap newImmutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, expectedSize);
    }

    public static  HashDoubleShortMap newImmutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4, Map<Double, Short> map5, int expectedSize) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5, expectedSize);
    }

    
    

    
    public static  HashDoubleShortMap newImmutableMap(
            Map<Double, Short> map) {
        return getDefaultFactory().newImmutableMap(map);
    }

    public static  HashDoubleShortMap newImmutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2) {
        return getDefaultFactory().newImmutableMap(map1, map2);
    }

    public static  HashDoubleShortMap newImmutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3);
    }

    public static  HashDoubleShortMap newImmutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4);
    }

    public static  HashDoubleShortMap newImmutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4, Map<Double, Short> map5) {
        return getDefaultFactory().newImmutableMap(map1, map2, map3, map4, map5);
    }


    public static  HashDoubleShortMap newImmutableMap(
            net.openhft.function.Consumer<DoubleShortConsumer> entriesSupplier) {
        return getDefaultFactory().newImmutableMap(entriesSupplier);
    }

    public static  HashDoubleShortMap newImmutableMap(
            net.openhft.function.Consumer<DoubleShortConsumer> entriesSupplier,
            int expectedSize) {
        return getDefaultFactory().newImmutableMap(entriesSupplier, expectedSize);
    }

    public static  HashDoubleShortMap newImmutableMap(
            double[] keys, short[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashDoubleShortMap newImmutableMap(
            double[] keys, short[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashDoubleShortMap newImmutableMap(
            Double[] keys, Short[] values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashDoubleShortMap newImmutableMap(
            Double[] keys, Short[] values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }

    public static  HashDoubleShortMap newImmutableMap(Iterable<Double> keys,
            Iterable<Short> values) {
        return getDefaultFactory().newImmutableMap(keys, values);
    }

    public static  HashDoubleShortMap newImmutableMap(Iterable<Double> keys,
            Iterable<Short> values, int expectedSize) {
        return getDefaultFactory().newImmutableMap(keys, values, expectedSize);
    }


    public static  HashDoubleShortMap newImmutableMapOf(
            double k1, short v1) {
        return getDefaultFactory().newImmutableMapOf(k1, v1);
    }

    public static  HashDoubleShortMap newImmutableMapOf(
            double k1, short v1, double k2, short v2) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2);
    }

    public static  HashDoubleShortMap newImmutableMapOf(
            double k1, short v1, double k2, short v2,
            double k3, short v3) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3);
    }

    public static  HashDoubleShortMap newImmutableMapOf(
            double k1, short v1, double k2, short v2,
            double k3, short v3, double k4, short v4) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static  HashDoubleShortMap newImmutableMapOf(
            double k1, short v1, double k2, short v2,
            double k3, short v3, double k4, short v4,
            double k5, short v5) {
        return getDefaultFactory().newImmutableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    private HashDoubleShortMaps() {}
}

