/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.DoubleShortConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashDoubleShortMaps}
 *
 * @see HashDoubleShortMap
 * @see HashDoubleShortMaps#getDefaultFactory()
 */
public interface HashDoubleShortMapFactory extends DoubleShortMapFactory
        , HashContainerFactory<HashDoubleShortMapFactory> {

    

    

    

    

    

    
    

    
    


    @Override
    HashDoubleShortMapFactory withDefaultValue(short defaultValue);

    @Override
     HashDoubleShortMap newMutableMap();

    @Override
     HashDoubleShortMap newMutableMap(int expectedSize);

    


    @Override
     HashDoubleShortMap newMutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, int expectedSize);

    @Override
     HashDoubleShortMap newMutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3, int expectedSize);

    @Override
     HashDoubleShortMap newMutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4, int expectedSize);

    @Override
     HashDoubleShortMap newMutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4, Map<Double, Short> map5, int expectedSize);

    

    
    @Override
     HashDoubleShortMap newMutableMap(Map<Double, Short> map);

    @Override
     HashDoubleShortMap newMutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2);

    @Override
     HashDoubleShortMap newMutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3);

    @Override
     HashDoubleShortMap newMutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4);

    @Override
     HashDoubleShortMap newMutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4, Map<Double, Short> map5);


    @Override
     HashDoubleShortMap newMutableMap(
            net.openhft.function.Consumer<DoubleShortConsumer> entriesSupplier);

    @Override
     HashDoubleShortMap newMutableMap(
            net.openhft.function.Consumer<DoubleShortConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashDoubleShortMap newMutableMap(double[] keys, short[] values);

    @Override
     HashDoubleShortMap newMutableMap(double[] keys, short[] values,
            int expectedSize);

    @Override
     HashDoubleShortMap newMutableMap(
            Double[] keys, Short[] values);

    @Override
     HashDoubleShortMap newMutableMap(
            Double[] keys, Short[] values, int expectedSize);

    @Override
     HashDoubleShortMap newMutableMap(Iterable<Double> keys,
            Iterable<Short> values);

    @Override
     HashDoubleShortMap newMutableMap(Iterable<Double> keys,
            Iterable<Short> values, int expectedSize);


    @Override
     HashDoubleShortMap newMutableMapOf(double k1, short v1);

    @Override
     HashDoubleShortMap newMutableMapOf(double k1, short v1,
            double k2, short v2);

    @Override
     HashDoubleShortMap newMutableMapOf(double k1, short v1,
            double k2, short v2, double k3, short v3);

    @Override
     HashDoubleShortMap newMutableMapOf(double k1, short v1,
            double k2, short v2, double k3, short v3,
            double k4, short v4);

    @Override
     HashDoubleShortMap newMutableMapOf(double k1, short v1,
            double k2, short v2, double k3, short v3,
            double k4, short v4, double k5, short v5);
    @Override
     HashDoubleShortMap newUpdatableMap();

    @Override
     HashDoubleShortMap newUpdatableMap(int expectedSize);

    


    @Override
     HashDoubleShortMap newUpdatableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, int expectedSize);

    @Override
     HashDoubleShortMap newUpdatableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3, int expectedSize);

    @Override
     HashDoubleShortMap newUpdatableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4, int expectedSize);

    @Override
     HashDoubleShortMap newUpdatableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4, Map<Double, Short> map5, int expectedSize);

    

    
    @Override
     HashDoubleShortMap newUpdatableMap(Map<Double, Short> map);

    @Override
     HashDoubleShortMap newUpdatableMap(Map<Double, Short> map1,
            Map<Double, Short> map2);

    @Override
     HashDoubleShortMap newUpdatableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3);

    @Override
     HashDoubleShortMap newUpdatableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4);

    @Override
     HashDoubleShortMap newUpdatableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4, Map<Double, Short> map5);


    @Override
     HashDoubleShortMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleShortConsumer> entriesSupplier);

    @Override
     HashDoubleShortMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleShortConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashDoubleShortMap newUpdatableMap(double[] keys, short[] values);

    @Override
     HashDoubleShortMap newUpdatableMap(double[] keys, short[] values,
            int expectedSize);

    @Override
     HashDoubleShortMap newUpdatableMap(
            Double[] keys, Short[] values);

    @Override
     HashDoubleShortMap newUpdatableMap(
            Double[] keys, Short[] values, int expectedSize);

    @Override
     HashDoubleShortMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Short> values);

    @Override
     HashDoubleShortMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Short> values, int expectedSize);


    @Override
     HashDoubleShortMap newUpdatableMapOf(double k1, short v1);

    @Override
     HashDoubleShortMap newUpdatableMapOf(double k1, short v1,
            double k2, short v2);

    @Override
     HashDoubleShortMap newUpdatableMapOf(double k1, short v1,
            double k2, short v2, double k3, short v3);

    @Override
     HashDoubleShortMap newUpdatableMapOf(double k1, short v1,
            double k2, short v2, double k3, short v3,
            double k4, short v4);

    @Override
     HashDoubleShortMap newUpdatableMapOf(double k1, short v1,
            double k2, short v2, double k3, short v3,
            double k4, short v4, double k5, short v5);

    


    @Override
     HashDoubleShortMap newImmutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, int expectedSize);

    @Override
     HashDoubleShortMap newImmutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3, int expectedSize);

    @Override
     HashDoubleShortMap newImmutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4, int expectedSize);

    @Override
     HashDoubleShortMap newImmutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4, Map<Double, Short> map5, int expectedSize);

    

    
    @Override
     HashDoubleShortMap newImmutableMap(Map<Double, Short> map);

    @Override
     HashDoubleShortMap newImmutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2);

    @Override
     HashDoubleShortMap newImmutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3);

    @Override
     HashDoubleShortMap newImmutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4);

    @Override
     HashDoubleShortMap newImmutableMap(Map<Double, Short> map1,
            Map<Double, Short> map2, Map<Double, Short> map3,
            Map<Double, Short> map4, Map<Double, Short> map5);


    @Override
     HashDoubleShortMap newImmutableMap(
            net.openhft.function.Consumer<DoubleShortConsumer> entriesSupplier);

    @Override
     HashDoubleShortMap newImmutableMap(
            net.openhft.function.Consumer<DoubleShortConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashDoubleShortMap newImmutableMap(double[] keys, short[] values);

    @Override
     HashDoubleShortMap newImmutableMap(double[] keys, short[] values,
            int expectedSize);

    @Override
     HashDoubleShortMap newImmutableMap(
            Double[] keys, Short[] values);

    @Override
     HashDoubleShortMap newImmutableMap(
            Double[] keys, Short[] values, int expectedSize);

    @Override
     HashDoubleShortMap newImmutableMap(Iterable<Double> keys,
            Iterable<Short> values);

    @Override
     HashDoubleShortMap newImmutableMap(Iterable<Double> keys,
            Iterable<Short> values, int expectedSize);


    @Override
     HashDoubleShortMap newImmutableMapOf(double k1, short v1);

    @Override
     HashDoubleShortMap newImmutableMapOf(double k1, short v1,
            double k2, short v2);

    @Override
     HashDoubleShortMap newImmutableMapOf(double k1, short v1,
            double k2, short v2, double k3, short v3);

    @Override
     HashDoubleShortMap newImmutableMapOf(double k1, short v1,
            double k2, short v2, double k3, short v3,
            double k4, short v4);

    @Override
     HashDoubleShortMap newImmutableMapOf(double k1, short v1,
            double k2, short v2, double k3, short v3,
            double k4, short v4, double k5, short v5);
}

