/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.collect.map.hash;

import net.openhft.collect.*;
import net.openhft.collect.hash.*;
import net.openhft.function.DoubleLongConsumer;
import net.openhft.collect.map.*;
import javax.annotation.Nullable;

import java.util.Map;


/**
 * An immutable factory of {@code HashDoubleLongMaps}
 *
 * @see HashDoubleLongMap
 * @see HashDoubleLongMaps#getDefaultFactory()
 */
public interface HashDoubleLongMapFactory extends DoubleLongMapFactory
        , HashContainerFactory<HashDoubleLongMapFactory> {

    

    

    

    

    

    
    

    
    


    @Override
    HashDoubleLongMapFactory withDefaultValue(long defaultValue);

    @Override
     HashDoubleLongMap newMutableMap();

    @Override
     HashDoubleLongMap newMutableMap(int expectedSize);

    


    @Override
     HashDoubleLongMap newMutableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, int expectedSize);

    @Override
     HashDoubleLongMap newMutableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3, int expectedSize);

    @Override
     HashDoubleLongMap newMutableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3,
            Map<Double, Long> map4, int expectedSize);

    @Override
     HashDoubleLongMap newMutableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3,
            Map<Double, Long> map4, Map<Double, Long> map5, int expectedSize);

    

    
    @Override
     HashDoubleLongMap newMutableMap(Map<Double, Long> map);

    @Override
     HashDoubleLongMap newMutableMap(Map<Double, Long> map1,
            Map<Double, Long> map2);

    @Override
     HashDoubleLongMap newMutableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3);

    @Override
     HashDoubleLongMap newMutableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3,
            Map<Double, Long> map4);

    @Override
     HashDoubleLongMap newMutableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3,
            Map<Double, Long> map4, Map<Double, Long> map5);


    @Override
     HashDoubleLongMap newMutableMap(
            net.openhft.function.Consumer<DoubleLongConsumer> entriesSupplier);

    @Override
     HashDoubleLongMap newMutableMap(
            net.openhft.function.Consumer<DoubleLongConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashDoubleLongMap newMutableMap(double[] keys, long[] values);

    @Override
     HashDoubleLongMap newMutableMap(double[] keys, long[] values,
            int expectedSize);

    @Override
     HashDoubleLongMap newMutableMap(
            Double[] keys, Long[] values);

    @Override
     HashDoubleLongMap newMutableMap(
            Double[] keys, Long[] values, int expectedSize);

    @Override
     HashDoubleLongMap newMutableMap(Iterable<Double> keys,
            Iterable<Long> values);

    @Override
     HashDoubleLongMap newMutableMap(Iterable<Double> keys,
            Iterable<Long> values, int expectedSize);


    @Override
     HashDoubleLongMap newMutableMapOf(double k1, long v1);

    @Override
     HashDoubleLongMap newMutableMapOf(double k1, long v1,
            double k2, long v2);

    @Override
     HashDoubleLongMap newMutableMapOf(double k1, long v1,
            double k2, long v2, double k3, long v3);

    @Override
     HashDoubleLongMap newMutableMapOf(double k1, long v1,
            double k2, long v2, double k3, long v3,
            double k4, long v4);

    @Override
     HashDoubleLongMap newMutableMapOf(double k1, long v1,
            double k2, long v2, double k3, long v3,
            double k4, long v4, double k5, long v5);
    @Override
     HashDoubleLongMap newUpdatableMap();

    @Override
     HashDoubleLongMap newUpdatableMap(int expectedSize);

    


    @Override
     HashDoubleLongMap newUpdatableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, int expectedSize);

    @Override
     HashDoubleLongMap newUpdatableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3, int expectedSize);

    @Override
     HashDoubleLongMap newUpdatableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3,
            Map<Double, Long> map4, int expectedSize);

    @Override
     HashDoubleLongMap newUpdatableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3,
            Map<Double, Long> map4, Map<Double, Long> map5, int expectedSize);

    

    
    @Override
     HashDoubleLongMap newUpdatableMap(Map<Double, Long> map);

    @Override
     HashDoubleLongMap newUpdatableMap(Map<Double, Long> map1,
            Map<Double, Long> map2);

    @Override
     HashDoubleLongMap newUpdatableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3);

    @Override
     HashDoubleLongMap newUpdatableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3,
            Map<Double, Long> map4);

    @Override
     HashDoubleLongMap newUpdatableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3,
            Map<Double, Long> map4, Map<Double, Long> map5);


    @Override
     HashDoubleLongMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleLongConsumer> entriesSupplier);

    @Override
     HashDoubleLongMap newUpdatableMap(
            net.openhft.function.Consumer<DoubleLongConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashDoubleLongMap newUpdatableMap(double[] keys, long[] values);

    @Override
     HashDoubleLongMap newUpdatableMap(double[] keys, long[] values,
            int expectedSize);

    @Override
     HashDoubleLongMap newUpdatableMap(
            Double[] keys, Long[] values);

    @Override
     HashDoubleLongMap newUpdatableMap(
            Double[] keys, Long[] values, int expectedSize);

    @Override
     HashDoubleLongMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Long> values);

    @Override
     HashDoubleLongMap newUpdatableMap(Iterable<Double> keys,
            Iterable<Long> values, int expectedSize);


    @Override
     HashDoubleLongMap newUpdatableMapOf(double k1, long v1);

    @Override
     HashDoubleLongMap newUpdatableMapOf(double k1, long v1,
            double k2, long v2);

    @Override
     HashDoubleLongMap newUpdatableMapOf(double k1, long v1,
            double k2, long v2, double k3, long v3);

    @Override
     HashDoubleLongMap newUpdatableMapOf(double k1, long v1,
            double k2, long v2, double k3, long v3,
            double k4, long v4);

    @Override
     HashDoubleLongMap newUpdatableMapOf(double k1, long v1,
            double k2, long v2, double k3, long v3,
            double k4, long v4, double k5, long v5);

    


    @Override
     HashDoubleLongMap newImmutableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, int expectedSize);

    @Override
     HashDoubleLongMap newImmutableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3, int expectedSize);

    @Override
     HashDoubleLongMap newImmutableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3,
            Map<Double, Long> map4, int expectedSize);

    @Override
     HashDoubleLongMap newImmutableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3,
            Map<Double, Long> map4, Map<Double, Long> map5, int expectedSize);

    

    
    @Override
     HashDoubleLongMap newImmutableMap(Map<Double, Long> map);

    @Override
     HashDoubleLongMap newImmutableMap(Map<Double, Long> map1,
            Map<Double, Long> map2);

    @Override
     HashDoubleLongMap newImmutableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3);

    @Override
     HashDoubleLongMap newImmutableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3,
            Map<Double, Long> map4);

    @Override
     HashDoubleLongMap newImmutableMap(Map<Double, Long> map1,
            Map<Double, Long> map2, Map<Double, Long> map3,
            Map<Double, Long> map4, Map<Double, Long> map5);


    @Override
     HashDoubleLongMap newImmutableMap(
            net.openhft.function.Consumer<DoubleLongConsumer> entriesSupplier);

    @Override
     HashDoubleLongMap newImmutableMap(
            net.openhft.function.Consumer<DoubleLongConsumer> entriesSupplier,
            int expectedSize);

    @Override
     HashDoubleLongMap newImmutableMap(double[] keys, long[] values);

    @Override
     HashDoubleLongMap newImmutableMap(double[] keys, long[] values,
            int expectedSize);

    @Override
     HashDoubleLongMap newImmutableMap(
            Double[] keys, Long[] values);

    @Override
     HashDoubleLongMap newImmutableMap(
            Double[] keys, Long[] values, int expectedSize);

    @Override
     HashDoubleLongMap newImmutableMap(Iterable<Double> keys,
            Iterable<Long> values);

    @Override
     HashDoubleLongMap newImmutableMap(Iterable<Double> keys,
            Iterable<Long> values, int expectedSize);


    @Override
     HashDoubleLongMap newImmutableMapOf(double k1, long v1);

    @Override
     HashDoubleLongMap newImmutableMapOf(double k1, long v1,
            double k2, long v2);

    @Override
     HashDoubleLongMap newImmutableMapOf(double k1, long v1,
            double k2, long v2, double k3, long v3);

    @Override
     HashDoubleLongMap newImmutableMapOf(double k1, long v1,
            double k2, long v2, double k3, long v3,
            double k4, long v4);

    @Override
     HashDoubleLongMap newImmutableMapOf(double k1, long v1,
            double k2, long v2, double k3, long v3,
            double k4, long v4, double k5, long v5);
}

